/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.transform;

import io.lucenia.indexmanagement.IndexManagementIndices;
import io.lucenia.indexmanagement.common.model.dimension.DateHistogram;
import io.lucenia.indexmanagement.common.model.dimension.Dimension;
import io.lucenia.indexmanagement.transform.exceptions.TransformIndexException;
import io.lucenia.indexmanagement.transform.model.Transform;
import io.lucenia.indexmanagement.util.IndexUtils;
import io.skylite.common.action.ActionListener;
import io.skylite.common.xcontent.XContentFactory;
import io.skylite.core.action.admin.indices.mapping.get.GetMappingsRequest;
import io.skylite.core.action.admin.indices.mapping.get.GetMappingsResponse;
import io.skylite.core.aggregations.AggregationBuilder;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.metadata.MappingMetadata;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentHelper;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.search.aggregations.support.ValuesSourceAggregationBuilder;

public class TargetIndexMappingService {
    private static final Logger logger = LogManager.getLogger(TargetIndexMappingService.class);
    private static Client client;
    private static final String TYPE = "type";
    private static final String PROPERTIES = "properties";
    private static final Set<String> DATE_FIELD_TYPES;
    public static final String DEFAULT_DATE_FORMAT = "strict_date_optional_time||epoch_millis";

    private TargetIndexMappingService() {
    }

    public static void initialize(Client client) {
        TargetIndexMappingService.client = client;
    }

    public static CompletableFuture<Map<String, Object>> getTargetMappingsForDates(final Transform transform) {
        final CompletableFuture<Map<String, Object>> future = new CompletableFuture<Map<String, Object>>();
        final String sourceIndex = transform.getSourceIndex();
        try {
            GetMappingsRequest request = (GetMappingsRequest)new GetMappingsRequest().indices(new String[]{sourceIndex});
            client.admin().indices().getMappings(request, (ActionListener)new ActionListener<GetMappingsResponse>(){

                public void onResponse(GetMappingsResponse response) {
                    try {
                        if (response == null) {
                            future.completeExceptionally(new IllegalStateException("GetMappingResponse for [" + transform.getSourceIndex() + "] was null"));
                            return;
                        }
                        MappingMetadata mappingMetadata = (MappingMetadata)response.getMappings().get(sourceIndex);
                        Map sourceIndexMapping = mappingMetadata != null ? mappingMetadata.getSourceAsMap() : null;
                        HashMap<String, Object> targetIndexDateFieldMappings = new HashMap<String, Object>();
                        if (sourceIndexMapping != null && !sourceIndexMapping.isEmpty()) {
                            TargetIndexMappingService.mapDateTermAggregation(transform, sourceIndexMapping, targetIndexDateFieldMappings);
                            TargetIndexMappingService.mapDateAggregation(transform.getAggregations().getAggregatorFactories(), sourceIndexMapping, targetIndexDateFieldMappings, null);
                        }
                        future.complete(targetIndexDateFieldMappings);
                    }
                    catch (Exception e) {
                        future.completeExceptionally(e);
                    }
                }

                public void onFailure(Exception e) {
                    if (e instanceof IndexNotFoundException) {
                        logger.error("Index " + sourceIndex + " doesn't exist");
                        future.complete(Map.of());
                    } else {
                        future.completeExceptionally(e);
                    }
                }
            });
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    private static void mapDateTermAggregation(Transform transform, Map<String, Object> sourceIndexMapping, Map<String, Object> dateFieldMappings) throws TransformIndexException {
        for (Dimension dimension : transform.getGroups()) {
            if (!TargetIndexMappingService.isFieldInMappings(dimension.getSourceField(), sourceIndexMapping)) {
                throw new TransformIndexException("Missing field " + dimension.getSourceField() + " in source index");
            }
            Map<?, ?> sourceFieldType = IndexUtils.getFieldFromMappings(dimension.getSourceField(), sourceIndexMapping);
            if (dimension instanceof DateHistogram || !TargetIndexMappingService.isSourceFieldDate(sourceFieldType)) continue;
            Map<String, String> dateTypeTargetMapping = Map.of(TYPE, sourceFieldType.get(TYPE), "format", DEFAULT_DATE_FORMAT);
            dateFieldMappings.put(dimension.getTargetField(), dateTypeTargetMapping);
        }
    }

    private static boolean isSourceFieldDate(Map<?, ?> sourceFieldType) {
        return sourceFieldType != null && sourceFieldType.get(TYPE) != null && DATE_FIELD_TYPES.contains(sourceFieldType.get(TYPE));
    }

    public static String createTargetIndexMapping(Map<String, Object> dateFieldMappings) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder();
        String dynamicMappings = IndexManagementIndices.transformTargetMappings;
        ByteBuffer byteBuffer = ByteBuffer.wrap(dynamicMappings.getBytes(StandardCharsets.UTF_8));
        BytesReference bytesReference = BytesReference.fromByteBuffer((ByteBuffer)byteBuffer);
        XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)bytesReference, (MediaType)MediaTypeRegistry.JSON);
        block8: while (!xcp.isClosed()) {
            XContentParser.Token token = xcp.currentToken();
            String fieldName = xcp.currentName();
            if (token == null) {
                xcp.nextToken();
                continue;
            }
            switch (token) {
                case VALUE_NUMBER: {
                    builder.field(fieldName, xcp.intValue());
                    break;
                }
                case VALUE_STRING: {
                    builder.field(fieldName, xcp.text());
                    break;
                }
                case START_OBJECT: {
                    if (fieldName != null) {
                        builder.startObject(fieldName);
                        break;
                    }
                    builder.startObject();
                    break;
                }
                case END_OBJECT: {
                    builder.endObject();
                    break;
                }
                case START_ARRAY: {
                    builder.startArray(fieldName);
                    break;
                }
                case END_ARRAY: {
                    builder.endArray();
                    if (dateFieldMappings.isEmpty()) break;
                    builder.startObject(PROPERTIES);
                    TargetIndexMappingService.mapCompositeAggregation(dateFieldMappings, builder);
                    builder.endObject();
                    break;
                }
                default: {
                    xcp.nextToken();
                    continue block8;
                }
            }
            xcp.nextToken();
        }
        return builder.toString();
    }

    private static void mapCompositeAggregation(Map<String, Object> compositeAggregation, XContentBuilder builder) throws IOException {
        for (Map.Entry<String, Object> entry : compositeAggregation.entrySet()) {
            if (entry.getValue() instanceof Map) {
                builder.startObject(entry.getKey());
                TargetIndexMappingService.mapCompositeAggregation((Map)entry.getValue(), builder);
                builder.endObject();
                continue;
            }
            if (!DATE_FIELD_TYPES.contains(entry.getValue())) continue;
            builder.field(entry.getKey(), entry.getValue().toString());
        }
    }

    private static String createTargetIndexMappingsAsString(Map<String, Object> dateFieldMappings, String dynamicMappings) {
        String compositeAgg = TargetIndexMappingService.mapCompositeAggregationToString(dateFieldMappings);
        return dynamicMappings.trim().substring(0, dynamicMappings.trim().length() - 1) + ", \n \"properties\" : \n { \n " + compositeAgg + " \n } \n }";
    }

    private static String mapCompositeAggregationToString(Map<String, Object> compositeAggregation) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Map.Entry<String, Object> entry : compositeAggregation.entrySet()) {
            if (!isFirst) {
                sb.append(",");
            }
            isFirst = false;
            if (entry.getValue() instanceof Map) {
                sb.append("\"").append(entry.getKey()).append("\" : {");
                sb.append(TargetIndexMappingService.mapCompositeAggregationToString((Map)entry.getValue()));
                sb.append("\n }");
                continue;
            }
            sb.append("\n");
            sb.append("\"").append(entry.getKey()).append("\" : \"").append(entry.getValue()).append("\"");
        }
        return sb.toString();
    }

    private static void mapDateAggregation(Collection<AggregationBuilder> aggBuilders, Map<String, Object> sourceIndexMapping, Map<String, Object> targetIndexMapping, String parentPath) {
        for (AggregationBuilder aggBuilder : aggBuilders) {
            ValuesSourceAggregationBuilder valuesSourceAgg;
            String sourceIdxFieldName;
            Map<?, ?> sourceFieldType;
            String fullPath;
            String targetIdxFieldName = aggBuilder.getName();
            String string = fullPath = parentPath != null ? parentPath + "." + targetIdxFieldName : targetIdxFieldName;
            if (aggBuilder instanceof ValuesSourceAggregationBuilder && (sourceFieldType = IndexUtils.getFieldFromMappings(sourceIdxFieldName = (valuesSourceAgg = (ValuesSourceAggregationBuilder)aggBuilder).field(), sourceIndexMapping)) != null && !sourceFieldType.isEmpty() && "date".equals(sourceFieldType.get(TYPE))) {
                Map<String, String> dateTypeTargetMapping = Map.of(TYPE, "date", "format", DEFAULT_DATE_FORMAT);
                targetIndexMapping.put(fullPath, dateTypeTargetMapping);
            }
            if (aggBuilder.getSubAggregations() == null || aggBuilder.getSubAggregations().isEmpty()) continue;
            TargetIndexMappingService.mapDateAggregation(aggBuilder.getSubAggregations(), sourceIndexMapping, targetIndexMapping, fullPath);
        }
    }

    private static boolean isFieldInMappings(String fieldName, Map<?, ?> mappings) {
        return IndexUtils.getFieldFromMappings(fieldName, mappings) != null;
    }

    static {
        DATE_FIELD_TYPES = Set.of("date", "date_nanos");
    }
}

