/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.transform;

import io.lucenia.indexmanagement.transform.TargetIndexMappingService;
import io.lucenia.indexmanagement.transform.exceptions.TransformIndexException;
import io.lucenia.indexmanagement.transform.settings.TransformSettings;
import io.lucenia.indexmanagement.transform.util.TransformContext;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteSecurityException;
import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.DocWriteRequest;
import io.skylite.core.action.admin.indices.create.CreateIndexRequest;
import io.skylite.core.action.bulk.BackoffPolicy;
import io.skylite.core.action.bulk.BulkItemResponse;
import io.skylite.core.action.bulk.BulkRequest;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.settings.Settings;
import io.skylite.core.transport.RemoteTransportException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransformIndexer {
    private final Logger logger = LogManager.getLogger(TransformIndexer.class);
    private final ClusterService clusterService;
    private final Client client;
    private volatile BackoffPolicy backoffPolicy;

    public TransformIndexer(Settings settings, ClusterService clusterService, Client client) {
        this.clusterService = clusterService;
        this.client = client;
        this.backoffPolicy = BackoffPolicy.constantBackoff((TimeValue)((TimeValue)TransformSettings.TRANSFORM_JOB_INDEX_BACKOFF_MILLIS.get(settings)), (int)((Integer)TransformSettings.TRANSFORM_JOB_INDEX_BACKOFF_COUNT.get(settings)));
        clusterService.getClusterSettings().addSettingsUpdateConsumer(TransformSettings.TRANSFORM_JOB_INDEX_BACKOFF_MILLIS, TransformSettings.TRANSFORM_JOB_INDEX_BACKOFF_COUNT, (millis, count) -> {
            this.backoffPolicy = BackoffPolicy.constantBackoff((TimeValue)millis, (int)count);
        });
    }

    private void createTargetIndex(String targetIndex, Map<String, Object> targetFieldMappings, ActionListener<Void> listener) {
        if (!this.clusterService.state().getRoutingTable().hasIndex(targetIndex)) {
            try {
                String transformTargetIndexMapping = TargetIndexMappingService.createTargetIndexMapping(targetFieldMappings);
                CreateIndexRequest request = new CreateIndexRequest(targetIndex).mapping(transformTargetIndexMapping);
                this.client.admin().indices().create(request, ActionListener.wrap(response -> {
                    if (!response.isAcknowledged()) {
                        this.logger.error("Failed to create the target index {}", (Object)targetIndex);
                        listener.onFailure((Exception)new TransformIndexException("Failed to create the target index"));
                    } else {
                        listener.onResponse(null);
                    }
                }, arg_0 -> listener.onFailure(arg_0)));
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        } else {
            listener.onResponse(null);
        }
    }

    public void index(String transformTargetIndex, List<DocWriteRequest<?>> docsToIndex, TransformContext transformContext, ActionListener<Long> listener) {
        if (docsToIndex.isEmpty()) {
            listener.onResponse((Object)0L);
            return;
        }
        String targetIndex = docsToIndex.get(0).index();
        this.logger.debug("Attempting to index {} documents to {}", (Object)docsToIndex.size(), (Object)targetIndex);
        this.createTargetIndex(transformTargetIndex, transformContext.getTargetIndexDateFieldMappings(), (ActionListener<Void>)ActionListener.wrap(v -> this.indexWithRetry(docsToIndex, this.backoffPolicy.iterator(), 0L, new ArrayList<BulkItemResponse>(), listener), arg_0 -> listener.onFailure(arg_0)));
    }

    private void indexWithRetry(List<DocWriteRequest<?>> docsToIndex, Iterator<TimeValue> backoffIterator, long indexTimeInMillis, List<BulkItemResponse> nonRetryableFailures, ActionListener<Long> listener) {
        if (docsToIndex.isEmpty()) {
            if (!nonRetryableFailures.isEmpty()) {
                this.logger.error("Failed to index {} documents", (Object)nonRetryableFailures.size());
                listener.onFailure((Exception)((Object)SkyliteExceptionsHelper.convertToOpenSearchException((Exception)nonRetryableFailures.get(0).getFailure().getCause())));
            } else {
                listener.onResponse((Object)indexTimeInMillis);
            }
            return;
        }
        try {
            BulkRequest bulkRequest = new BulkRequest().add(docsToIndex);
            this.client.bulk(bulkRequest, ActionListener.wrap(bulkResponse -> {
                long updatedIndexTime = indexTimeInMillis + bulkResponse.getTook().getMillis();
                ArrayList<BulkItemResponse> retryableFailures = new ArrayList<BulkItemResponse>();
                ArrayList<DocWriteRequest> updatableDocsToIndex = new ArrayList<DocWriteRequest>();
                for (BulkItemResponse item : bulkResponse.getItems()) {
                    if (!item.isFailed()) continue;
                    if (item.status() == RestStatus.TOO_MANY_REQUESTS) {
                        retryableFailures.add(item);
                        updatableDocsToIndex.add((DocWriteRequest)docsToIndex.get(item.getItemId()));
                        continue;
                    }
                    nonRetryableFailures.add(item);
                }
                if (!updatableDocsToIndex.isEmpty()) {
                    if (!backoffIterator.hasNext()) {
                        listener.onFailure((Exception)new TransformIndexException("Exceeded retry attempts for indexing transform documents"));
                        return;
                    }
                    TimeValue backoff = (TimeValue)backoffIterator.next();
                    this.logger.warn("Retrying indexing in " + String.valueOf(backoff));
                    new Thread(() -> {
                        try {
                            TimeUnit.MILLISECONDS.sleep(backoff.millis());
                            this.indexWithRetry(updatableDocsToIndex, backoffIterator, updatedIndexTime, nonRetryableFailures, listener);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            listener.onFailure((Exception)new TransformIndexException("Indexing interrupted", e));
                        }
                    }).start();
                } else {
                    this.indexWithRetry(new ArrayList(), backoffIterator, updatedIndexTime, nonRetryableFailures, listener);
                }
            }, e -> {
                Exception unwrappedException;
                Exception exception = unwrappedException = e instanceof RemoteTransportException ? (Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)((RemoteTransportException)((Object)((Object)e)))) : e;
                if (e instanceof SkyliteSecurityException) {
                    listener.onFailure((Exception)new TransformIndexException("Failed to index the documents - missing required index permissions: " + e.getLocalizedMessage(), unwrappedException));
                } else {
                    listener.onFailure((Exception)new TransformIndexException("Failed to index the documents", unwrappedException));
                }
            }));
        }
        catch (Exception e2) {
            listener.onFailure((Exception)new TransformIndexException("Failed to index the documents", e2));
        }
    }
}

