/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.transform;

import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.lucenia.indexmanagement.transform.exceptions.TransformMetadataException;
import io.lucenia.indexmanagement.transform.model.ContinuousTransformStats;
import io.lucenia.indexmanagement.transform.model.Transform;
import io.lucenia.indexmanagement.transform.model.TransformMetadata;
import io.lucenia.indexmanagement.transform.model.TransformStats;
import io.lucenia.indexmanagement.util.IndexUtils;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.common.xcontent.XContentFactory;
import io.skylite.core.action.DocWriteRequest;
import io.skylite.core.action.DocWriteResponse;
import io.skylite.core.action.get.GetRequest;
import io.skylite.core.action.index.IndexRequest;
import io.skylite.core.client.Client;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.transport.RemoteTransportException;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentHelper;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.time.Instant;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransformMetadataService {
    private final Logger logger = LogManager.getLogger(TransformMetadataService.class);
    private final Client client;
    private final NamedXContentRegistry xContentRegistry;

    public TransformMetadataService(Client client, NamedXContentRegistry xContentRegistry) {
        this.client = client;
        this.xContentRegistry = xContentRegistry;
    }

    public void getMetadata(Transform transform, ActionListener<TransformMetadata> listener) {
        if (transform.getMetadataId() != null) {
            GetRequest getRequest = new GetRequest(".opendistro-ism-config", transform.getMetadataId()).routing(transform.getId());
            this.client.get(getRequest, ActionListener.wrap(response -> {
                BytesReference metadataSource = response.getSourceAsBytesRef();
                if (metadataSource == null) {
                    listener.onFailure((Exception)new TransformMetadataException("Failed to parse the existing metadata document"));
                    return;
                }
                try {
                    XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)metadataSource, (MediaType)MediaTypeRegistry.JSON);
                    TransformMetadata transformMetadata = LuceniaExtensions.parseWithType(xcp, response.getId(), response.getSeqNo(), response.getPrimaryTerm(), TransformMetadata::parse);
                    if (transformMetadata != null) {
                        listener.onResponse((Object)transformMetadata);
                    } else {
                        listener.onFailure((Exception)new TransformMetadataException("Failed to parse the existing metadata document"));
                    }
                }
                catch (IOException e) {
                    listener.onFailure((Exception)new TransformMetadataException("Failed to parse the existing metadata document", e));
                }
            }, arg_0 -> listener.onFailure(arg_0)));
        } else {
            this.logger.debug("Creating metadata doc as none exists at the moment for transform job [{}]", (Object)transform.getId());
            this.createMetadata(transform, listener);
        }
    }

    private void createMetadata(Transform transform, ActionListener<TransformMetadata> listener) {
        String id = IndexUtils.hashToFixedSize("TransformMetadata#" + transform.getId() + "#" + String.valueOf(transform.getLastUpdateTime()));
        TransformMetadata metadata = new TransformMetadata(id, -1L, -1L, transform.getId(), null, Instant.now(), TransformMetadata.Status.INIT, null, new TransformStats(0L, 0L, 0L, 0L, 0L), null, transform.isContinuous() ? new ContinuousTransformStats(null, null) : null);
        this.writeMetadata(metadata, false, listener);
    }

    public void writeMetadata(TransformMetadata metadata, boolean updating, ActionListener<TransformMetadata> listener) {
        String errorMessage = "Failed to " + (updating ? "update" : "create") + " metadata doc " + metadata.getId() + " for transform job " + metadata.getTransformId();
        try {
            XContentBuilder builder = metadata.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS);
            IndexRequest indexRequest = new IndexRequest(".opendistro-ism-config").source(builder).id(metadata.getId()).routing(metadata.getTransformId());
            if (updating) {
                indexRequest.setIfSeqNo(metadata.getSeqNo()).setIfPrimaryTerm(metadata.getPrimaryTerm());
            } else {
                indexRequest.opType(DocWriteRequest.OpType.CREATE);
            }
            this.client.index(indexRequest, ActionListener.wrap(response -> {
                DocWriteResponse.Result result = response.getResult();
                if (result == DocWriteResponse.Result.CREATED || result == DocWriteResponse.Result.UPDATED) {
                    TransformMetadata updatedMetadata = new TransformMetadata(metadata.getId(), response.getSeqNo(), response.getPrimaryTerm(), metadata.getTransformId(), metadata.getAfterKey(), metadata.getLastUpdatedAt(), metadata.getStatus(), metadata.getFailureReason(), metadata.getStats(), metadata.getShardIDToGlobalCheckpoint(), metadata.getContinuousStats());
                    listener.onResponse((Object)updatedMetadata);
                } else {
                    this.logger.error(errorMessage);
                    listener.onFailure((Exception)new TransformMetadataException("Failed to write metadata, received " + result.getLowercase() + " status"));
                }
            }, e -> {
                Exception unwrappedException = e instanceof RemoteTransportException ? (Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)((RemoteTransportException)((Object)((Object)e)))) : e;
                this.logger.error(errorMessage, (Throwable)unwrappedException);
                listener.onFailure((Exception)new TransformMetadataException(errorMessage, unwrappedException));
            }));
        }
        catch (Exception e2) {
            this.logger.error(errorMessage, (Throwable)e2);
            listener.onFailure((Exception)new TransformMetadataException(errorMessage, e2));
        }
    }
}

