/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.transform;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class TransformProcessedBucketLog {
    public static final int MAX_SIZE = 100000000;
    public static final int HEX_RADIX = 16;
    private Set<String> processedBuckets = new HashSet<String>();

    public void addBuckets(List<Map<String, Object>> buckets) {
        for (Map<String, Object> bucket : buckets) {
            this.addBucket(bucket);
        }
    }

    private void addBucket(Map<String, Object> bucket) {
        if (this.processedBuckets.size() >= 100000000) {
            return;
        }
        this.processedBuckets.add(this.computeBucketHash(bucket));
    }

    private boolean isProcessed(Map<String, Object> bucket) {
        return this.processedBuckets.contains(this.computeBucketHash(bucket));
    }

    public boolean isNotProcessed(Map<String, Object> bucket) {
        return !this.isProcessed(bucket);
    }

    private String computeBucketHash(Map<String, Object> bucket) {
        try {
            MessageDigest md5Crypt = MessageDigest.getInstance("MD5");
            TreeMap<String, Object> sortedBucket = new TreeMap<String, Object>(bucket);
            for (Map.Entry<String, Object> entry : sortedBucket.entrySet()) {
                byte[] bytes = entry.getValue() == null ? "null".getBytes(StandardCharsets.UTF_8) : entry.getValue().toString().getBytes(StandardCharsets.UTF_8);
                md5Crypt.update(bytes);
            }
            return new BigInteger(1, md5Crypt.digest()).toString(16);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("MD5 algorithm not found", e);
        }
    }
}

