/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.transform;

import io.lucenia.indexmanagement.luceniaapi.IndexManagementSecurityContext;
import io.lucenia.indexmanagement.transform.TargetIndexMappingService;
import io.lucenia.indexmanagement.transform.TransformIndexer;
import io.lucenia.indexmanagement.transform.TransformMetadataService;
import io.lucenia.indexmanagement.transform.TransformProcessedBucketLog;
import io.lucenia.indexmanagement.transform.TransformSearchService;
import io.lucenia.indexmanagement.transform.TransformValidator;
import io.lucenia.indexmanagement.transform.action.index.IndexTransformAction;
import io.lucenia.indexmanagement.transform.action.index.IndexTransformRequest;
import io.lucenia.indexmanagement.transform.action.index.IndexTransformResponse;
import io.lucenia.indexmanagement.transform.exceptions.TransformValidationException;
import io.lucenia.indexmanagement.transform.model.BucketSearchResult;
import io.lucenia.indexmanagement.transform.model.BucketsToTransform;
import io.lucenia.indexmanagement.transform.model.ContinuousTransformStats;
import io.lucenia.indexmanagement.transform.model.ShardNewDocuments;
import io.lucenia.indexmanagement.transform.model.Transform;
import io.lucenia.indexmanagement.transform.model.TransformMetadata;
import io.lucenia.indexmanagement.transform.model.TransformSearchResult;
import io.lucenia.indexmanagement.transform.model.TransformStats;
import io.lucenia.indexmanagement.transform.model.TransformValidationResult;
import io.lucenia.indexmanagement.transform.util.TransformContext;
import io.lucenia.indexmanagement.transform.util.TransformLockManager;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.DocWriteRequest;
import io.skylite.core.action.WriteRequest;
import io.skylite.core.action.index.IndexRequest;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.SkyliteExecutors;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.jobs.JobExecutionContext;
import io.skylite.core.jobs.ScheduledJobParameter;
import io.skylite.core.monitor.jvm.JvmService;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.jobs.ScheduledJobRunner;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransformRunner
implements ScheduledJobRunner {
    private static final Logger logger = LogManager.getLogger(TransformRunner.class);
    private static final List<TransformMetadata.Status> STOPPED_STATUSES = List.of(TransformMetadata.Status.STOPPED, TransformMetadata.Status.FINISHED);
    public static final TransformRunner INSTANCE = new TransformRunner();
    private ExecutorService executorService;
    private Client client;
    private NamedXContentRegistry xContentRegistry;
    private ClusterService clusterService;
    private Settings settings;
    private TransformMetadataService transformMetadataService;
    private TransformSearchService transformSearchService;
    private TransformIndexer transformIndexer;
    private TransformValidator transformValidator;
    private ThreadPool threadPool;

    private TransformRunner() {
    }

    public TransformRunner initialize(Client client, ClusterService clusterService, NamedXContentRegistry xContentRegistry, Settings settings, IndexNameExpressionResolver indexNameExpressionResolver, JvmService jvmService, ThreadPool threadPool) {
        this.clusterService = clusterService;
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.settings = settings;
        this.transformSearchService = new TransformSearchService(settings, clusterService, client);
        this.transformMetadataService = new TransformMetadataService(client, xContentRegistry);
        this.transformIndexer = new TransformIndexer(settings, clusterService, client);
        this.transformValidator = new TransformValidator(indexNameExpressionResolver, clusterService, client, settings, jvmService);
        this.threadPool = threadPool;
        if (this.executorService == null) {
            this.executorService = SkyliteExecutors.newScaling((String)"transform-runner", (int)0, (int)Math.max(4, Runtime.getRuntime().availableProcessors()), (long)30L, (TimeUnit)TimeUnit.SECONDS, (ThreadFactory)SkyliteExecutors.daemonThreadFactory((String)"transform-runner"), (ThreadContext)threadPool.getThreadContext());
        }
        return this;
    }

    public void runJob(ScheduledJobParameter job, JobExecutionContext context) {
        if (!(job instanceof Transform)) {
            throw new IllegalArgumentException("Received invalid job type [" + job.getClass().getSimpleName() + "] with id [" + context.getJobId() + "]");
        }
        Transform transform = (Transform)job;
        CompletableFuture.runAsync(() -> {
            try {
                if (transform.isEnabled()) {
                    this.transformMetadataService.getMetadata(transform, (ActionListener<TransformMetadata>)ActionListener.wrap(metadata -> {
                        try {
                            Transform currentTransform = transform;
                            if (transform.getMetadataId() == null) {
                                currentTransform = this.updateTransform(this.createTransformWithMetadataId(transform, metadata.getId()));
                            }
                            this.executeJob(currentTransform, (TransformMetadata)metadata, context);
                        }
                        catch (Exception e) {
                            logger.error("Failed to execute job [" + transform.getId() + "] because " + e.getLocalizedMessage(), (Throwable)e);
                        }
                    }, e -> logger.error("Failed to get metadata for job [" + transform.getId() + "] because " + e.getLocalizedMessage(), (Throwable)e)));
                }
            }
            catch (Exception e2) {
                logger.error("Failed to run job [" + transform.getId() + "] because " + e2.getLocalizedMessage(), (Throwable)e2);
            }
        }, this.executorService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeJob(Transform transform, TransformMetadata metadata, JobExecutionContext context) {
        block22: {
            Map<ShardId, Long> newGlobalCheckpoints = null;
            Instant newGlobalCheckpointTime = null;
            TransformMetadata currentMetadata = metadata;
            TransformProcessedBucketLog transformProcessedBucketLog = new TransformProcessedBucketLog();
            BucketsToTransform bucketsToTransform = new BucketsToTransform(new HashSet<Map<String, Object>>(), metadata);
            TransformContext transformContext = new TransformContext(new TransformLockManager(transform, context));
            TransformLockManager transformLockManager = transformContext.getTransformLockManager();
            transformLockManager.acquireLockForScheduledJob();
            logger.info("Starting executeJob for transform [{}], continuous={}, metadataStatus={}", (Object)transform.getId(), (Object)transform.isContinuous(), (Object)metadata.getStatus());
            int iteration = 0;
            try {
                do {
                    logger.debug("Transform [{}] iteration {}: currentShard={}, afterKey={}", (Object)transform.getId(), (Object)(++iteration), bucketsToTransform.getCurrentShard() != null ? bucketsToTransform.getCurrentShard().getShardId() : "null", currentMetadata.getAfterKey());
                    if (transformLockManager.getLock() == null) {
                        logger.warn("Cannot acquire lock for transform job " + transform.getId());
                        return;
                    }
                    if (STOPPED_STATUSES.contains((Object)currentMetadata.getStatus())) {
                        logger.warn("Transform job " + transform.getId() + " is in " + String.valueOf((Object)currentMetadata.getStatus()) + " status. Skipping execution");
                        return;
                    }
                    TransformMetadata validatedMetadata = this.validateTransform(transform, currentMetadata);
                    if (validatedMetadata.getStatus() == TransformMetadata.Status.FAILED) {
                        currentMetadata = validatedMetadata;
                        return;
                    }
                    Map<String, Object> targetIndexDateFieldMappings = TargetIndexMappingService.getTargetMappingsForDates(transform).join();
                    transformContext.setTargetDateFieldMappings(targetIndexDateFieldMappings);
                    if (transform.isContinuous()) {
                        logger.debug("Transform [{}] continuous mode: shardsToSearch={}, currentShard={}", (Object)transform.getId(), (Object)(bucketsToTransform.getShardsToSearch() != null ? "initialized" : "null"), bucketsToTransform.getCurrentShard() != null ? bucketsToTransform.getCurrentShard().getShardId() : "null");
                        if (bucketsToTransform.getShardsToSearch() == null) {
                            logger.debug("Transform [{}] initializing shards to search", (Object)transform.getId());
                            newGlobalCheckpointTime = Instant.now();
                            newGlobalCheckpoints = this.getShardsGlobalCheckpointSync(transform.getSourceIndex());
                            logger.debug("Transform [{}] got global checkpoints: {}", (Object)transform.getId(), newGlobalCheckpoints);
                            bucketsToTransform = bucketsToTransform.initializeShardsToSearch(metadata.getShardIDToGlobalCheckpoint(), newGlobalCheckpoints);
                            logger.debug("Transform [{}] after initializeShardsToSearch: currentShard={}", (Object)transform.getId(), bucketsToTransform.getCurrentShard() != null ? bucketsToTransform.getCurrentShard().getShardId() : "null");
                        }
                        if (bucketsToTransform.getCurrentShard() != null) {
                            logger.debug("Transform [{}] processing shard {}", (Object)transform.getId(), (Object)bucketsToTransform.getCurrentShard().getShardId());
                            bucketsToTransform = this.getBucketsToTransformIteration(transform, bucketsToTransform, transformContext);
                            currentMetadata = bucketsToTransform.getMetadata();
                            logger.debug("Transform [{}] after getBucketsToTransformIteration: modifiedBuckets={}, afterKey={}", (Object)transform.getId(), (Object)bucketsToTransform.getModifiedBuckets().size(), currentMetadata.getAfterKey());
                            Set<Map<String, Object>> modifiedBuckets = bucketsToTransform.getModifiedBuckets().stream().filter(transformProcessedBucketLog::isNotProcessed).collect(Collectors.toSet());
                            logger.debug("Transform [{}] filtered to {} unprocessed buckets", (Object)transform.getId(), (Object)modifiedBuckets.size());
                            currentMetadata = this.recomputeModifiedBuckets(transform, currentMetadata, modifiedBuckets, transformContext);
                            logger.debug("Transform [{}] after recomputeModifiedBuckets: documentsProcessed={}", (Object)transform.getId(), (Object)currentMetadata.getStats().getDocumentsProcessed());
                            transformProcessedBucketLog.addBuckets(new ArrayList<Map<String, Object>>(modifiedBuckets));
                            currentMetadata = this.writeMetadataSync(currentMetadata, true);
                            bucketsToTransform = this.createBucketsToTransformWithMetadata(bucketsToTransform, currentMetadata);
                            logger.debug("Transform [{}] updated metadata: afterKey={}, currentShard={}", (Object)transform.getId(), currentMetadata.getAfterKey(), bucketsToTransform.getCurrentShard() != null ? bucketsToTransform.getCurrentShard().getShardId() : "null");
                        } else {
                            logger.debug("Transform [{}] no current shard to process", (Object)transform.getId());
                        }
                    } else {
                        currentMetadata = this.computeBucketsIteration(transform, currentMetadata, transformContext);
                        currentMetadata = this.writeMetadataSync(currentMetadata, true);
                    }
                    transformLockManager.renewLockForScheduledJob();
                } while (bucketsToTransform.getCurrentShard() != null || currentMetadata.getAfterKey() != null);
                if (transformLockManager.getLock() == null) break block22;
                if (transform.isContinuous() && currentMetadata.getStatus() != TransformMetadata.Status.FAILED) {
                    currentMetadata = new TransformMetadata.Builder(currentMetadata).shardIDToGlobalCheckpoint(newGlobalCheckpoints).continuousStats(new ContinuousTransformStats(newGlobalCheckpointTime, null)).build();
                }
                this.writeMetadataSync(currentMetadata, true);
            }
            catch (Exception e) {
                logger.error("Failed to execute the transform job [" + transform.getId() + "] because of exception [" + e.getLocalizedMessage() + "]", (Throwable)e);
                currentMetadata = new TransformMetadata.Builder(currentMetadata).lastUpdatedAt(Instant.now()).status(TransformMetadata.Status.FAILED).failureReason(e.getLocalizedMessage()).build();
                break block22;
            }
            finally {
                if (transformLockManager.getLock() != null) {
                    if (transform.isContinuous() && currentMetadata.getStatus() != TransformMetadata.Status.FAILED) {
                        currentMetadata = new TransformMetadata.Builder(currentMetadata).shardIDToGlobalCheckpoint(newGlobalCheckpoints).continuousStats(new ContinuousTransformStats(newGlobalCheckpointTime, null)).build();
                    }
                    this.writeMetadataSync(currentMetadata, true);
                    if (!transform.isContinuous() || currentMetadata.getStatus() == TransformMetadata.Status.FAILED) {
                        logger.info("Disabling the transform job " + transform.getId());
                        this.updateTransform(this.createTransformWithEnabled(transform, false, null));
                    }
                    transformLockManager.releaseLockForScheduledJob();
                }
            }
            if (!transform.isContinuous() || currentMetadata.getStatus() == TransformMetadata.Status.FAILED) {
                logger.info("Disabling the transform job " + transform.getId());
                this.updateTransform(this.createTransformWithEnabled(transform, false, null));
            }
            transformLockManager.releaseLockForScheduledJob();
        }
    }

    private BucketsToTransform getBucketsToTransformIteration(Transform transform, BucketsToTransform bucketsToTransform, TransformContext transformContext) {
        BucketsToTransform currentBucketsToTransform = bucketsToTransform;
        ShardNewDocuments currentShard = bucketsToTransform.getCurrentShard();
        currentBucketsToTransform.getModifiedBuckets().clear();
        if (currentShard != null) {
            try (IndexManagementSecurityContext ignored = new IndexManagementSecurityContext(transform.getId(), this.settings, this.threadPool.getThreadContext(), transform.getUser());){
                BucketSearchResult bucketSearchResult = this.getShardLevelModifiedBucketsSync(transform, currentBucketsToTransform.getMetadata().getAfterKey(), currentShard, transformContext);
                currentBucketsToTransform.getModifiedBuckets().addAll(bucketSearchResult.getModifiedBuckets());
                long mergedSearchTime = currentBucketsToTransform.getMetadata().getStats().getSearchTimeInMillis() + bucketSearchResult.getSearchTimeInMillis();
                TransformStats updatedStats = new TransformStats.Builder(currentBucketsToTransform.getMetadata().getStats()).pagesProcessed(currentBucketsToTransform.getMetadata().getStats().getPagesProcessed() + 1L).searchTimeInMillis(mergedSearchTime).build();
                TransformMetadata updatedMetadata = new TransformMetadata.Builder(currentBucketsToTransform.getMetadata()).stats(updatedStats).afterKey(bucketSearchResult.getAfterKey()).build();
                currentBucketsToTransform = new BucketsToTransform.Builder(currentBucketsToTransform).metadata(updatedMetadata).currentShard(currentShard).build();
            }
        }
        if (currentBucketsToTransform.getMetadata().getAfterKey() == null) {
            Iterator<ShardNewDocuments> shardsToSearch = currentBucketsToTransform.getShardsToSearch();
            currentBucketsToTransform = shardsToSearch != null && shardsToSearch.hasNext() ? new BucketsToTransform.Builder(currentBucketsToTransform).currentShard(shardsToSearch.next()).build() : new BucketsToTransform.Builder(currentBucketsToTransform).currentShard(null).build();
        }
        return currentBucketsToTransform;
    }

    private TransformMetadata validateTransform(Transform transform, TransformMetadata transformMetadata) throws TransformValidationException {
        try (IndexManagementSecurityContext ignored = new IndexManagementSecurityContext(transform.getId(), this.settings, this.threadPool.getThreadContext(), transform.getUser());){
            TransformValidationResult validationResult = this.transformValidator.validate(transform);
            if (!validationResult.isValid()) {
                String failureMessage = "Failed validation - " + String.valueOf(validationResult.getIssues());
                TransformMetadata failureMetadata = new TransformMetadata.Builder(transformMetadata).status(TransformMetadata.Status.FAILED).failureReason(failureMessage).build();
                TransformMetadata transformMetadata2 = this.writeMetadataSync(failureMetadata, true);
                return transformMetadata2;
            }
            TransformMetadata transformMetadata3 = transformMetadata;
            return transformMetadata3;
        }
    }

    private TransformMetadata computeBucketsIteration(Transform transform, TransformMetadata metadata, TransformContext transformContext) {
        long indexTimeInMillis;
        TransformSearchResult transformSearchResult;
        try (IndexManagementSecurityContext ignored = new IndexManagementSecurityContext(transform.getId(), this.settings, this.threadPool.getThreadContext(), transform.getUser());){
            transformSearchResult = this.executeCompositeSearchSync(transform, metadata.getAfterKey(), null, transformContext);
        }
        try (IndexManagementSecurityContext ignored = new IndexManagementSecurityContext(transform.getId(), this.settings, this.threadPool.getThreadContext(), transform.getUser());){
            indexTimeInMillis = this.indexDocsSync(transform.getTargetIndex(), new ArrayList<IndexRequest>(transformSearchResult.getDocsToIndex()), transformContext);
        }
        Map<String, Object> afterKey = transformSearchResult.getAfterKey();
        TransformStats stats = transformSearchResult.getStats();
        TransformStats updatedStats = new TransformStats.Builder(stats).pagesProcessed(stats.getPagesProcessed()).indexTimeInMillis(stats.getIndexTimeInMillis() + indexTimeInMillis).documentsIndexed(transformSearchResult.getDocsToIndex().size()).build();
        TransformMetadata mergedMetadata = metadata.mergeStats(updatedStats);
        return new TransformMetadata.Builder(mergedMetadata).afterKey(afterKey).lastUpdatedAt(Instant.now()).status(afterKey == null ? TransformMetadata.Status.FINISHED : TransformMetadata.Status.STARTED).build();
    }

    private TransformMetadata recomputeModifiedBuckets(Transform transform, TransformMetadata metadata, Set<Map<String, Object>> modifiedBuckets, TransformContext transformContext) {
        long indexTimeInMillis;
        TransformSearchResult transformSearchResult;
        if (modifiedBuckets.isEmpty()) {
            return new TransformMetadata.Builder(metadata).lastUpdatedAt(Instant.now()).status(TransformMetadata.Status.STARTED).build();
        }
        try (IndexManagementSecurityContext ignored = new IndexManagementSecurityContext(transform.getId(), this.settings, this.threadPool.getThreadContext(), transform.getUser());){
            transformSearchResult = this.executeCompositeSearchSync(transform, null, modifiedBuckets, transformContext);
        }
        try (IndexManagementSecurityContext ignored = new IndexManagementSecurityContext(transform.getId(), this.settings, this.threadPool.getThreadContext(), transform.getUser());){
            indexTimeInMillis = this.indexDocsSync(transform.getTargetIndex(), new ArrayList<IndexRequest>(transformSearchResult.getDocsToIndex()), transformContext);
        }
        TransformStats stats = transformSearchResult.getStats();
        TransformStats updatedStats = new TransformStats.Builder(stats).pagesProcessed(transform.isContinuous() ? 0L : stats.getPagesProcessed()).indexTimeInMillis(stats.getIndexTimeInMillis() + indexTimeInMillis).documentsIndexed(transformSearchResult.getDocsToIndex().size()).build();
        TransformMetadata mergedMetadata = metadata.mergeStats(updatedStats);
        return new TransformMetadata.Builder(mergedMetadata).lastUpdatedAt(Instant.now()).status(TransformMetadata.Status.STARTED).build();
    }

    private Transform updateTransform(Transform transform) {
        IndexTransformRequest request = new IndexTransformRequest(this.createTransformWithUpdatedAt(transform, Instant.now()), WriteRequest.RefreshPolicy.IMMEDIATE);
        try (IndexManagementSecurityContext ignored = new IndexManagementSecurityContext(transform.getId(), this.settings, this.threadPool.getThreadContext(), null);){
            IndexTransformResponse response = (IndexTransformResponse)((Object)this.client.execute((ActionType)IndexTransformAction.INSTANCE, (ActionRequest)request).actionGet());
            Transform transform2 = this.createTransformWithSeqNoAndPrimaryTerm(transform, response.getSeqNo(), response.getPrimaryTerm());
            return transform2;
        }
    }

    private Transform createTransformWithMetadataId(Transform original, String metadataId) {
        return new Transform(original.getId(), original.getSeqNo(), original.getPrimaryTerm(), original.getSchemaVersion(), original.getJobSchedule(), metadataId, original.getUpdatedAt(), original.isEnabled(), original.getEnabledAt(), original.getDescription(), original.getSourceIndex(), original.getDataSelectionQuery(), original.getTargetIndex(), original.getPageSize(), original.getGroups(), original.getAggregations(), original.isContinuous(), original.getUser());
    }

    private Transform createTransformWithSeqNoAndPrimaryTerm(Transform original, long seqNo, long primaryTerm) {
        return new Transform(original.getId(), seqNo, primaryTerm, original.getSchemaVersion(), original.getJobSchedule(), original.getMetadataId(), original.getUpdatedAt(), original.isEnabled(), original.getEnabledAt(), original.getDescription(), original.getSourceIndex(), original.getDataSelectionQuery(), original.getTargetIndex(), original.getPageSize(), original.getGroups(), original.getAggregations(), original.isContinuous(), original.getUser());
    }

    private Transform createTransformWithEnabled(Transform original, boolean enabled, Instant enabledAt) {
        return new Transform(original.getId(), original.getSeqNo(), original.getPrimaryTerm(), original.getSchemaVersion(), original.getJobSchedule(), original.getMetadataId(), original.getUpdatedAt(), enabled, enabledAt, original.getDescription(), original.getSourceIndex(), original.getDataSelectionQuery(), original.getTargetIndex(), original.getPageSize(), original.getGroups(), original.getAggregations(), original.isContinuous(), original.getUser());
    }

    private Transform createTransformWithUpdatedAt(Transform original, Instant updatedAt) {
        return new Transform(original.getId(), original.getSeqNo(), original.getPrimaryTerm(), original.getSchemaVersion(), original.getJobSchedule(), original.getMetadataId(), updatedAt, original.isEnabled(), original.getEnabledAt(), original.getDescription(), original.getSourceIndex(), original.getDataSelectionQuery(), original.getTargetIndex(), original.getPageSize(), original.getGroups(), original.getAggregations(), original.isContinuous(), original.getUser());
    }

    private BucketsToTransform createBucketsToTransformWithMetadata(BucketsToTransform original, TransformMetadata metadata) {
        return new BucketsToTransform.Builder(original).metadata(metadata).build();
    }

    private Map<ShardId, Long> getShardsGlobalCheckpointSync(String index) {
        CompletableFuture future = new CompletableFuture();
        this.transformSearchService.getShardsGlobalCheckpoint(index, (ActionListener<Map<ShardId, Long>>)ActionListener.wrap(future::complete, future::completeExceptionally));
        try {
            return (Map)future.orTimeout(5L, TimeUnit.MINUTES).join();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get shard global checkpoints for index: " + index, e);
        }
    }

    private TransformMetadata writeMetadataSync(TransformMetadata metadata, boolean updating) {
        CompletableFuture future = new CompletableFuture();
        this.transformMetadataService.writeMetadata(metadata, updating, (ActionListener<TransformMetadata>)ActionListener.wrap(future::complete, future::completeExceptionally));
        try {
            return (TransformMetadata)future.orTimeout(5L, TimeUnit.MINUTES).join();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to write metadata for transform: " + metadata.getTransformId(), e);
        }
    }

    private BucketSearchResult getShardLevelModifiedBucketsSync(Transform transform, Map<String, Object> afterKey, ShardNewDocuments currentShard, TransformContext transformContext) {
        CompletableFuture future = new CompletableFuture();
        this.transformSearchService.getShardLevelModifiedBuckets(transform, afterKey, currentShard, transformContext, (ActionListener<BucketSearchResult>)ActionListener.wrap(future::complete, future::completeExceptionally));
        try {
            return (BucketSearchResult)future.orTimeout(5L, TimeUnit.MINUTES).join();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get shard level modified buckets for transform: " + transform.getId(), e);
        }
    }

    private TransformSearchResult executeCompositeSearchSync(Transform transform, Map<String, Object> afterKey, Set<Map<String, Object>> modifiedBuckets, TransformContext transformContext) {
        CompletableFuture future = new CompletableFuture();
        this.transformSearchService.executeCompositeSearch(transform, afterKey, modifiedBuckets, transformContext, (ActionListener<TransformSearchResult>)ActionListener.wrap(future::complete, future::completeExceptionally));
        try {
            return (TransformSearchResult)future.orTimeout(5L, TimeUnit.MINUTES).join();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to execute composite search for transform: " + transform.getId(), e);
        }
    }

    private long indexDocsSync(String targetIndex, List<DocWriteRequest<?>> docsToIndex, TransformContext transformContext) {
        CompletableFuture future = new CompletableFuture();
        this.transformIndexer.index(targetIndex, docsToIndex, transformContext, (ActionListener<Long>)ActionListener.wrap(future::complete, future::completeExceptionally));
        try {
            return (Long)future.orTimeout(5L, TimeUnit.MINUTES).join();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to index documents for target index: " + targetIndex, e);
        }
    }
}

