/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.transform;

import io.lucenia.indexmanagement.common.model.dimension.Dimension;
import io.lucenia.indexmanagement.common.retry.RetryUtils;
import io.lucenia.indexmanagement.transform.exceptions.TransformSearchServiceException;
import io.lucenia.indexmanagement.transform.model.BucketSearchResult;
import io.lucenia.indexmanagement.transform.model.ShardNewDocuments;
import io.lucenia.indexmanagement.transform.model.Transform;
import io.lucenia.indexmanagement.transform.model.TransformSearchResult;
import io.lucenia.indexmanagement.transform.model.TransformStats;
import io.lucenia.indexmanagement.transform.settings.TransformSettings;
import io.lucenia.indexmanagement.transform.util.TransformContext;
import io.lucenia.indexmanagement.transform.util.TransformUtils;
import io.lucenia.indexmanagement.util.IndexUtils;
import io.skylite.SkyliteException;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteSecurityException;
import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.common.util.concurrent.SkyliteRejectedExecutionException;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.indices.stats.IndicesStatsAction;
import io.skylite.core.action.admin.indices.stats.IndicesStatsRequest;
import io.skylite.core.action.admin.indices.stats.IndicesStatsResponse;
import io.skylite.core.action.admin.indices.stats.ShardStats;
import io.skylite.core.action.bulk.BackoffPolicy;
import io.skylite.core.action.index.IndexRequest;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.action.search.TransportSearchAction;
import io.skylite.core.aggregations.Aggregation;
import io.skylite.core.aggregations.AggregationBuilder;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.index.Index;
import io.skylite.core.index.query.BoolQueryBuilder;
import io.skylite.core.index.query.ExistsQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.RangeQueryBuilder;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.settings.Settings;
import io.skylite.core.transport.RemoteTransportException;
import io.skylite.core.xcontent.MediaTypeRegistry;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.opensearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.opensearch.search.aggregations.metrics.InternalAvg;
import org.opensearch.search.aggregations.metrics.InternalMax;
import org.opensearch.search.aggregations.metrics.InternalMin;
import org.opensearch.search.aggregations.metrics.InternalSum;
import org.opensearch.search.aggregations.metrics.InternalValueCount;
import org.opensearch.search.aggregations.metrics.NumericMetricsAggregation;
import org.opensearch.search.aggregations.metrics.Percentile;
import org.opensearch.search.aggregations.metrics.Percentiles;
import org.opensearch.search.aggregations.metrics.ScriptedMetric;

public class TransformSearchService {
    private final Logger logger = LogManager.getLogger(TransformSearchService.class);
    public static final String FAILED_SEARCH_ERROR_MESSAGE = "Failed to search data in source indices";
    public static final String MODIFIED_BUCKETS_ERROR_MESSAGE = "Failed to get the modified buckets in source indices";
    public static final String GET_SHARDS_ERROR_MESSAGE = "Failed to get the shards in the source indices";
    private final Settings settings;
    private final ClusterService clusterService;
    private final Client client;
    private volatile BackoffPolicy backoffPolicy;
    private volatile TimeValue cancelAfterTimeInterval;

    public TransformSearchService(Settings settings, ClusterService clusterService, Client client) {
        this.settings = settings;
        this.clusterService = clusterService;
        this.client = client;
        this.backoffPolicy = BackoffPolicy.constantBackoff((TimeValue)((TimeValue)TransformSettings.TRANSFORM_JOB_SEARCH_BACKOFF_MILLIS.get(settings)), (int)((Integer)TransformSettings.TRANSFORM_JOB_SEARCH_BACKOFF_COUNT.get(settings)));
        this.cancelAfterTimeInterval = (TimeValue)TransportSearchAction.SEARCH_CANCEL_AFTER_TIME_INTERVAL_SETTING.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(TransformSettings.TRANSFORM_JOB_SEARCH_BACKOFF_MILLIS, TransformSettings.TRANSFORM_JOB_SEARCH_BACKOFF_COUNT, (millis, count) -> {
            this.backoffPolicy = BackoffPolicy.constantBackoff((TimeValue)millis, (int)count);
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(TransportSearchAction.SEARCH_CANCEL_AFTER_TIME_INTERVAL_SETTING, it -> {
            this.cancelAfterTimeInterval = it;
        });
    }

    public void getShardsGlobalCheckpoint(String index, ActionListener<Map<ShardId, Long>> listener) {
        this.getShardsGlobalCheckpointWithRetry(index, this.backoffPolicy.iterator(), 1, listener);
    }

    private void getShardsGlobalCheckpointWithRetry(String index, Iterator<TimeValue> backoffIterator, int retryAttempt, ActionListener<Map<ShardId, Long>> listener) {
        try {
            IndicesStatsRequest request = ((IndicesStatsRequest)new IndicesStatsRequest().indices(new String[]{index})).clear();
            if (retryAttempt > 1) {
                this.logger.debug(this.getShardsRetryMessage(retryAttempt));
            }
            this.client.execute((ActionType)IndicesStatsAction.INSTANCE, (ActionRequest)request, ActionListener.wrap(searchResponse -> {
                if (searchResponse.getStatus() == RestStatus.OK) {
                    listener.onResponse(TransformSearchService.convertIndicesStatsResponse(searchResponse));
                } else {
                    listener.onFailure((Exception)new TransformSearchServiceException("Failed to get the shards in the source indices - " + String.valueOf(searchResponse.getStatus())));
                }
            }, e -> {
                boolean shouldRetry = false;
                if (e instanceof SkyliteException) {
                    SkyliteException ose = (SkyliteException)((Object)((Object)e));
                    shouldRetry = backoffIterator.hasNext() && (RetryUtils.isRetryable(ose) || ose.status() == RestStatus.NOT_FOUND);
                } else if (e instanceof SkyliteRejectedExecutionException && backoffIterator.hasNext()) {
                    shouldRetry = true;
                }
                if (shouldRetry) {
                    TimeValue backoff = (TimeValue)backoffIterator.next();
                    this.logger.warn("Operation failed. Retrying in " + String.valueOf(backoff) + ".", (Throwable)e);
                    new Thread(() -> {
                        try {
                            TimeUnit.MILLISECONDS.sleep(backoff.millis());
                            this.getShardsGlobalCheckpointWithRetry(index, backoffIterator, retryAttempt + 1, listener);
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                            listener.onFailure((Exception)new TransformSearchServiceException(GET_SHARDS_ERROR_MESSAGE, ie));
                        }
                    }).start();
                } else {
                    Exception unwrappedException;
                    Exception exception = unwrappedException = e instanceof RemoteTransportException ? (Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)((RemoteTransportException)((Object)((Object)e)))) : e;
                    if (e instanceof SkyliteSecurityException) {
                        listener.onFailure((Exception)new TransformSearchServiceException("Failed to get the shards in the source indices - missing required index permissions: " + e.getLocalizedMessage(), unwrappedException));
                    } else {
                        listener.onFailure((Exception)new TransformSearchServiceException(GET_SHARDS_ERROR_MESSAGE, unwrappedException));
                    }
                }
            }));
        }
        catch (Exception e2) {
            listener.onFailure((Exception)new TransformSearchServiceException(GET_SHARDS_ERROR_MESSAGE, e2));
        }
    }

    public void getShardLevelModifiedBuckets(Transform transform, Map<String, Object> afterKey, ShardNewDocuments currentShard, TransformContext transformContext, ActionListener<BucketSearchResult> listener) {
        int pageSize = this.calculateMaxPageSize(transform);
        this.getShardLevelModifiedBucketsWithRetry(transform, afterKey, currentShard, transformContext, pageSize, 0, Instant.now().getEpochSecond(), listener);
    }

    private void getShardLevelModifiedBucketsWithRetry(Transform transform, Map<String, Object> afterKey, ShardNewDocuments currentShard, TransformContext transformContext, int pageSize, int retryAttempt, long searchStart, ActionListener<BucketSearchResult> listener) {
        try {
            Long searchRequestTimeoutInSeconds = transformContext.getMaxRequestTimeoutInSeconds();
            if (searchRequestTimeoutInSeconds == null) {
                return;
            }
            int temp = transformContext.getLastSuccessfulPageSize() != null ? transformContext.getLastSuccessfulPageSize() : (int)((double)pageSize / Math.pow(2.0, retryAttempt));
            int currentPageSize = Math.max(1, temp);
            if (retryAttempt > 0) {
                this.logger.debug("Attempt [{}] to get modified buckets for transform [{}]. Attempting again with reduced page size [{}]", (Object)retryAttempt, (Object)transform.getId(), (Object)currentPageSize);
            }
            SearchRequest request = TransformSearchService.getShardLevelBucketsSearchRequest(transform, afterKey, currentPageSize, currentShard, searchRequestTimeoutInSeconds);
            this.client.search(request, ActionListener.wrap(searchResponse -> {
                transformContext.setLastSuccessfulPageSize(currentPageSize);
                transformContext.renewLockForLongSearch(Instant.now().getEpochSecond() - searchStart);
                listener.onResponse((Object)TransformSearchService.convertBucketSearchResponse(transform, searchResponse));
            }, e -> this.handleSearchError((Throwable)e, () -> this.getShardLevelModifiedBucketsWithRetry(transform, afterKey, currentShard, transformContext, pageSize, retryAttempt + 1, searchStart, listener), (ActionListener)listener)));
        }
        catch (Exception e2) {
            this.handleSearchError(e2, null, listener);
        }
    }

    private int calculateMaxPageSize(Transform transform) {
        return Math.min(transform.getPageSize(), 1024 / (transform.getGroups().size() + 1));
    }

    public void executeCompositeSearch(Transform transform, Map<String, Object> afterKey, Set<Map<String, Object>> modifiedBuckets, TransformContext transformContext, ActionListener<TransformSearchResult> listener) {
        int pageSize = modifiedBuckets == null || modifiedBuckets.isEmpty() ? transform.getPageSize() : modifiedBuckets.size();
        this.executeCompositeSearchWithRetry(transform, afterKey, modifiedBuckets, transformContext, pageSize, 0, Instant.now().getEpochSecond(), listener);
    }

    private void executeCompositeSearchWithRetry(Transform transform, Map<String, Object> afterKey, Set<Map<String, Object>> modifiedBuckets, TransformContext transformContext, int pageSize, int retryAttempt, long searchStart, ActionListener<TransformSearchResult> listener) {
        try {
            Long searchRequestTimeoutInSeconds = transformContext.getMaxRequestTimeoutInSeconds();
            if (searchRequestTimeoutInSeconds == null) {
                searchRequestTimeoutInSeconds = this.getCancelAfterTimeIntervalSeconds(this.cancelAfterTimeInterval.seconds());
            }
            int temp = transformContext.getLastSuccessfulPageSize() != null ? transformContext.getLastSuccessfulPageSize() : (int)((double)pageSize / Math.pow(2.0, retryAttempt));
            int currentPageSize = Math.max(1, temp);
            if (retryAttempt > 0) {
                this.logger.debug("Attempt [{}] of composite search failed for transform [{}]. Attempting again with reduced page size [{}]", (Object)retryAttempt, (Object)transform.getId(), (Object)currentPageSize);
            }
            SearchRequest request = TransformSearchService.getSearchServiceRequest(transform, afterKey, currentPageSize, modifiedBuckets, searchRequestTimeoutInSeconds);
            this.client.search(request, ActionListener.wrap(searchResponse -> {
                transformContext.setLastSuccessfulPageSize(currentPageSize);
                transformContext.renewLockForLongSearch(Instant.now().getEpochSecond() - searchStart);
                listener.onResponse((Object)TransformSearchService.convertResponse(transform, searchResponse, true, modifiedBuckets, transformContext.getTargetIndexDateFieldMappings()));
            }, e -> this.handleSearchError((Throwable)e, () -> this.executeCompositeSearchWithRetry(transform, afterKey, modifiedBuckets, transformContext, pageSize, retryAttempt + 1, searchStart, listener), (ActionListener)listener)));
        }
        catch (Exception e2) {
            this.handleSearchError(e2, null, listener);
        }
    }

    private <T> void handleSearchError(Throwable e, Runnable retryAction, ActionListener<T> listener) {
        this.logger.error(e.getMessage(), e.getCause());
        Exception unwrappedException = e instanceof RemoteTransportException ? (Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)e) : (Exception)e;
        if (e instanceof SkyliteSecurityException) {
            listener.onFailure((Exception)new TransformSearchServiceException("Failed to search data in source indices - missing required index permissions: " + e.getLocalizedMessage(), unwrappedException));
        } else if (retryAction != null && this.isRetryableError(unwrappedException)) {
            retryAction.run();
        } else {
            listener.onFailure((Exception)new TransformSearchServiceException(FAILED_SEARCH_ERROR_MESSAGE, unwrappedException));
        }
    }

    private boolean isRetryableError(Exception e) {
        if (e instanceof SkyliteException) {
            return TransformUtils.isTransformRetryable((SkyliteException)((Object)e), List.of());
        }
        return false;
    }

    private long getCancelAfterTimeIntervalSeconds(long givenIntervalSeconds) {
        if (givenIntervalSeconds == -1L) {
            return -1L;
        }
        return Math.max(givenIntervalSeconds, 600L);
    }

    public static SearchRequest getSearchServiceRequest(Transform transform, Map<String, Object> afterKey, int pageSize, Set<Map<String, Object>> modifiedBuckets, Long timeoutInSeconds) throws TransformSearchServiceException {
        ArrayList<CompositeValuesSourceBuilder> sources = new ArrayList<CompositeValuesSourceBuilder>();
        for (Dimension group : transform.getGroups()) {
            sources.add(group.toSourceBuilder(false).missingBucket(true));
        }
        CompositeAggregationBuilder aggregationBuilder = (CompositeAggregationBuilder)new CompositeAggregationBuilder(transform.getId(), sources).size(pageSize).subAggregations(transform.getAggregations());
        if (afterKey != null) {
            aggregationBuilder.aggregateAfter(afterKey);
        }
        QueryBuilder query = modifiedBuckets == null ? transform.getDataSelectionQuery() : TransformSearchService.getQueryWithModifiedBuckets(transform.getDataSelectionQuery(), modifiedBuckets, transform.getGroups());
        return TransformSearchService.getSearchServiceRequest(transform.getSourceIndex(), query, aggregationBuilder, timeoutInSeconds);
    }

    private static QueryBuilder getQueryWithModifiedBuckets(QueryBuilder originalQuery, Set<Map<String, Object>> modifiedBuckets, List<Dimension> groups) throws TransformSearchServiceException {
        BoolQueryBuilder query = QueryBuilders.boolQuery().must(originalQuery).minimumShouldMatch(1);
        for (Map<String, Object> bucket : modifiedBuckets) {
            BoolQueryBuilder bucketQuery = QueryBuilders.boolQuery();
            for (Map.Entry<String, Object> group : bucket.entrySet()) {
                ExistsQueryBuilder subQuery;
                Dimension transformGroup = groups.stream().filter(it -> it.getTargetField().equals(group.getKey())).findFirst().orElse(null);
                if (transformGroup == null) {
                    throw new TransformSearchServiceException("Failed to find a transform group matching the bucket field [" + group.getKey() + "]");
                }
                if (group.getValue() == null) {
                    subQuery = new ExistsQueryBuilder(transformGroup.getSourceField());
                    bucketQuery.mustNot((QueryBuilder)subQuery);
                    continue;
                }
                subQuery = transformGroup.toBucketQuery(group.getValue());
                bucketQuery.filter((QueryBuilder)subQuery);
            }
            query.should((QueryBuilder)bucketQuery);
        }
        return query;
    }

    private static SearchRequest getSearchServiceRequest(String index, QueryBuilder query, CompositeAggregationBuilder aggregationBuilder, Long timeoutInSeconds) {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().trackTotalHits(false).size(0).aggregation((AggregationBuilder)aggregationBuilder).query(query);
        SearchRequest request = new SearchRequest(new String[]{index}).source(searchSourceBuilder).allowPartialSearchResults(false);
        if (timeoutInSeconds != null) {
            request.setCancelAfterTimeInterval(TimeValue.timeValueSeconds((long)timeoutInSeconds));
        }
        return request;
    }

    private static SearchRequest getShardLevelBucketsSearchRequest(Transform transform, Map<String, Object> afterKey, int pageSize, ShardNewDocuments currentShard, long timeoutInSeconds) {
        RangeQueryBuilder rangeQuery = TransformSearchService.getSeqNoRangeQuery(currentShard.getFrom(), currentShard.getTo());
        BoolQueryBuilder query = QueryBuilders.boolQuery().filter((QueryBuilder)rangeQuery).must(transform.getDataSelectionQuery());
        ArrayList<CompositeValuesSourceBuilder> sources = new ArrayList<CompositeValuesSourceBuilder>();
        for (Dimension group : transform.getGroups()) {
            sources.add(group.toSourceBuilder(false).missingBucket(true));
        }
        CompositeAggregationBuilder aggregationBuilder = new CompositeAggregationBuilder(transform.getId(), sources).size(pageSize);
        if (afterKey != null) {
            aggregationBuilder.aggregateAfter(afterKey);
        }
        SearchRequest request = TransformSearchService.getSearchServiceRequest(currentShard.getShardId().getIndexName(), (QueryBuilder)query, aggregationBuilder, timeoutInSeconds);
        return request.preference("_shards:" + currentShard.getShardId().getId());
    }

    private static RangeQueryBuilder getSeqNoRangeQuery(Long from, long to) {
        RangeQueryBuilder rangeQuery = new RangeQueryBuilder("_seq_no");
        if (to >= 0L) {
            rangeQuery.to((Object)to, true);
        }
        if (from != null && from >= 0L) {
            rangeQuery.from((Object)from, false);
        }
        return rangeQuery;
    }

    public static TransformSearchResult convertResponse(Transform transform, SearchResponse searchResponse, boolean waterMarkDocuments, Set<Map<String, Object>> modifiedBuckets, Map<String, Object> targetIndexDateFieldMappings) throws TransformSearchServiceException {
        CompositeAggregation aggs = (CompositeAggregation)searchResponse.getAggregations().get(transform.getId());
        List<? extends CompositeAggregation.Bucket> buckets = modifiedBuckets != null ? TransformSearchService.filterBuckets(aggs.getBuckets(), modifiedBuckets) : aggs.getBuckets();
        long documentsProcessed = 0L;
        for (CompositeAggregation.Bucket bucket2 : buckets) {
            documentsProcessed += bucket2.getDocCount();
        }
        long pagesProcessed = 1L;
        long searchTime = searchResponse.getTook().getMillis();
        TransformStats stats = new TransformStats(pagesProcessed, documentsProcessed, 0L, 0L, searchTime);
        Map afterKey = aggs.afterKey();
        ArrayList<IndexRequest> docsToIndex = new ArrayList<IndexRequest>();
        for (CompositeAggregation.Bucket bucket3 : buckets) {
            String id = transform.getId() + "#" + bucket3.getKey().entrySet().stream().map(bucket -> bucket.getValue() != null ? bucket.getValue().toString() : "#ODFE-MAGIC-NULL-MAGIC-ODFE#").reduce((a, b) -> a + ":" + b).orElse("");
            String hashedId = IndexUtils.hashToFixedSize(id);
            Map<String, Object> document = transform.convertToDoc(bucket3.getDocCount(), waterMarkDocuments);
            bucket3.getKey().forEach(document::put);
            for (Aggregation aggregation : bucket3.getAggregations()) {
                document.put(aggregation.getName(), TransformSearchService.getAggregationValue(aggregation, targetIndexDateFieldMappings));
            }
            IndexRequest indexRequest = new IndexRequest(transform.getTargetIndex()).id(hashedId).source(document, MediaTypeRegistry.JSON);
            docsToIndex.add(indexRequest);
        }
        return new TransformSearchResult(stats, docsToIndex, afterKey);
    }

    private static List<? extends CompositeAggregation.Bucket> filterBuckets(List<? extends CompositeAggregation.Bucket> buckets, Set<Map<String, Object>> modifiedBuckets) {
        ArrayList<CompositeAggregation.Bucket> filtered = new ArrayList<CompositeAggregation.Bucket>();
        for (CompositeAggregation.Bucket bucket : buckets) {
            if (!modifiedBuckets.contains(bucket.getKey())) continue;
            filtered.add(bucket);
        }
        return filtered;
    }

    private static BucketSearchResult convertBucketSearchResponse(Transform transform, SearchResponse searchResponse) {
        CompositeAggregation aggs = (CompositeAggregation)searchResponse.getAggregations().get(transform.getId());
        HashSet<Map<String, Object>> modifiedBuckets = new HashSet<Map<String, Object>>();
        for (CompositeAggregation.Bucket bucket : aggs.getBuckets()) {
            modifiedBuckets.add(bucket.getKey());
        }
        return new BucketSearchResult(modifiedBuckets, aggs.afterKey(), searchResponse.getTook().getMillis());
    }

    private static Object getAggregationValue(Aggregation aggregation, Map<String, Object> targetIndexDateFieldMappings) throws TransformSearchServiceException {
        if (aggregation instanceof InternalSum || aggregation instanceof InternalMin || aggregation instanceof InternalMax || aggregation instanceof InternalAvg || aggregation instanceof InternalValueCount) {
            NumericMetricsAggregation.SingleValue agg = (NumericMetricsAggregation.SingleValue)aggregation;
            if (aggregation instanceof InternalValueCount || aggregation instanceof InternalSum || !targetIndexDateFieldMappings.containsKey(agg.getName())) {
                return agg.value();
            }
            return (long)agg.value();
        }
        if (aggregation instanceof Percentiles) {
            HashMap<String, Double> percentiles = new HashMap<String, Double>();
            for (Percentile percentile : (Percentiles)aggregation) {
                percentiles.put(String.valueOf(percentile.getPercent()), percentile.getValue());
            }
            return percentiles;
        }
        if (aggregation instanceof ScriptedMetric) {
            return ((ScriptedMetric)aggregation).aggregation();
        }
        throw new TransformSearchServiceException("Found aggregation [" + aggregation.getName() + "] of type [" + aggregation.getType() + "] in composite result that is not currently supported");
    }

    public static Map<ShardId, Long> convertIndicesStatsResponse(IndicesStatsResponse response) {
        ShardStats[] shardsToSearch;
        HashMap<ShardId, Long> shardStats = new HashMap<ShardId, Long>();
        for (ShardStats shard : shardsToSearch = response.getShards()) {
            if (!shard.getShardRouting().primary() || !shard.getShardRouting().active()) continue;
            ShardId shardId = shard.getShardRouting().shardId();
            ShardId shardIDNoUUID = new ShardId(new Index(shardId.getIndex().getName(), "_na_"), shardId.getId());
            long globalCheckpoint = shard.getSeqNoStats() != null ? shard.getSeqNoStats().getGlobalCheckpoint() : -2L;
            shardStats.put(shardIDNoUUID, globalCheckpoint);
        }
        return shardStats;
    }

    private String getShardsRetryMessage(int attemptNumber) {
        return "Attempt [" + attemptNumber + "] to get shard global checkpoint numbers";
    }
}

