/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.transform.action.delete;

import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.lucenia.indexmanagement.settings.IndexManagementSettings;
import io.lucenia.indexmanagement.transform.action.delete.DeleteTransformsRequest;
import io.lucenia.indexmanagement.transform.model.Transform;
import io.lucenia.indexmanagement.util.SecurityUtils;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.WriteRequest;
import io.skylite.core.action.bulk.BulkRequest;
import io.skylite.core.action.bulk.BulkResponse;
import io.skylite.core.action.delete.DeleteRequest;
import io.skylite.core.action.get.MultiGetItemResponse;
import io.skylite.core.action.get.MultiGetRequest;
import io.skylite.core.action.get.MultiGetResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.search.fetch.subphase.FetchSourceContext;
import io.skylite.core.security.auth.User;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.NamedXContentRegistry;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportDeleteTransformsAction
extends HandledTransportAction<DeleteTransformsRequest, BulkResponse> {
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final Client client;
    private final Settings settings;
    private final ClusterService clusterService;
    private final NamedXContentRegistry xContentRegistry;
    private volatile boolean filterByEnabled;

    @Inject
    public TransportDeleteTransformsAction(TransportService transportService, Client client, Settings settings, ClusterService clusterService, NamedXContentRegistry xContentRegistry, ActionFilters actionFilters) {
        super("cluster:admin/lucenia/transform/delete", transportService, actionFilters, DeleteTransformsRequest::new);
        this.client = client;
        this.settings = settings;
        this.clusterService = clusterService;
        this.xContentRegistry = xContentRegistry;
        this.filterByEnabled = (Boolean)IndexManagementSettings.FILTER_BY_BACKEND_ROLES.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(IndexManagementSettings.FILTER_BY_BACKEND_ROLES, it -> {
            this.filterByEnabled = it;
        });
    }

    protected void doExecute(Task task, DeleteTransformsRequest request, ActionListener<BulkResponse> actionListener) {
        new DeleteTransformHandler(this.client, request, actionListener).start();
    }

    class DeleteTransformHandler {
        private final Client client;
        private final DeleteTransformsRequest request;
        private final ActionListener<BulkResponse> actionListener;
        private final User user;

        DeleteTransformHandler(Client client, DeleteTransformsRequest request, ActionListener<BulkResponse> actionListener) {
            this.client = client;
            this.request = request;
            this.actionListener = actionListener;
            this.user = SecurityUtils.buildUser(client.threadPool().getThreadContext());
        }

        void start() {
            TransportDeleteTransformsAction.this.log.debug("User and roles string from thread context: {}", this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
            MultiGetRequest getRequest = new MultiGetRequest();
            FetchSourceContext fetchSourceContext = new FetchSourceContext(true);
            for (String id : this.request.getIds()) {
                getRequest.add(new MultiGetRequest.Item(".opendistro-ism-config", id).fetchSourceContext(fetchSourceContext));
            }
            try (ThreadContext.StoredContext ignored = this.client.threadPool().getThreadContext().stashContext();){
                this.client.multiGet(getRequest, (ActionListener)new ActionListener<MultiGetResponse>(){

                    public void onResponse(MultiGetResponse response) {
                        try {
                            if (response.getResponses()[0].isFailed()) {
                                DeleteTransformHandler.this.actionListener.onFailure((Exception)((Object)new SkyliteStatusException("Cluster missing system index .opendistro-ism-config, cannot execute the request", RestStatus.BAD_REQUEST, new Object[0])));
                                return;
                            }
                            DeleteTransformHandler.this.bulkDelete(response, DeleteTransformHandler.this.request.getIds(), DeleteTransformHandler.this.request.getForce(), DeleteTransformHandler.this.actionListener);
                        }
                        catch (Exception e) {
                            DeleteTransformHandler.this.actionListener.onFailure(e);
                        }
                    }

                    public void onFailure(Exception e) {
                        DeleteTransformHandler.this.actionListener.onFailure(e);
                    }
                });
            }
        }

        private void bulkDelete(MultiGetResponse response, List<String> ids, boolean forceDelete, final ActionListener<BulkResponse> actionListener) {
            ArrayList<String> enabledIDs = new ArrayList<String>();
            ArrayList<String> notTransform = new ArrayList<String>();
            ArrayList<String> noPermission = new ArrayList<String>();
            for (MultiGetItemResponse item : response.getResponses()) {
                if (!item.getResponse().isExists()) continue;
                try {
                    Transform transform = LuceniaExtensions.parseFromGetResponse(item.getResponse(), TransportDeleteTransformsAction.this.xContentRegistry, Transform::parse);
                    boolean enabled = transform.isEnabled();
                    if (enabled && !forceDelete) {
                        enabledIDs.add(item.getId());
                    }
                    if (SecurityUtils.userHasPermissionForResource(this.user, transform.getUser(), TransportDeleteTransformsAction.this.filterByEnabled)) continue;
                    noPermission.add(item.getId());
                }
                catch (Exception e) {
                    notTransform.add(item.getId());
                }
            }
            if (!noPermission.isEmpty()) {
                actionListener.onFailure((Exception)((Object)new SkyliteStatusException("Don't have permission to delete some/all transforms in " + String.valueOf(this.request.getIds()), RestStatus.FORBIDDEN, new Object[0])));
                return;
            }
            if (!notTransform.isEmpty()) {
                actionListener.onFailure((Exception)((Object)new SkyliteStatusException("Cannot find transforms " + String.valueOf(notTransform), RestStatus.BAD_REQUEST, new Object[0])));
                return;
            }
            if (!enabledIDs.isEmpty()) {
                actionListener.onFailure((Exception)((Object)new SkyliteStatusException(String.valueOf(enabledIDs) + " transform(s) are enabled, please disable them before deleting them or set force flag", RestStatus.CONFLICT, new Object[0])));
                return;
            }
            BulkRequest bulkDeleteRequest = new BulkRequest();
            bulkDeleteRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            for (String id : ids) {
                bulkDeleteRequest.add(new DeleteRequest(".opendistro-ism-config", id));
            }
            this.client.bulk(bulkDeleteRequest, (ActionListener)new ActionListener<BulkResponse>(){

                public void onResponse(BulkResponse response) {
                    actionListener.onResponse((Object)response);
                }

                public void onFailure(Exception e) {
                    actionListener.onFailure(e);
                }
            });
        }
    }
}

