/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.transform.action.explain;

import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.lucenia.indexmanagement.settings.IndexManagementSettings;
import io.lucenia.indexmanagement.transform.action.explain.ExplainTransformRequest;
import io.lucenia.indexmanagement.transform.action.explain.ExplainTransformResponse;
import io.lucenia.indexmanagement.transform.model.ContinuousTransformStats;
import io.lucenia.indexmanagement.transform.model.ExplainTransform;
import io.lucenia.indexmanagement.transform.model.Transform;
import io.lucenia.indexmanagement.transform.model.TransformMetadata;
import io.lucenia.indexmanagement.util.SecurityUtils;
import io.skylite.ResourceNotFoundException;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.index.query.BoolQueryBuilder;
import io.skylite.core.index.query.IdsQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.WildcardQueryBuilder;
import io.skylite.core.search.SearchHit;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.security.auth.User;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.RemoteTransportException;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentHelper;
import io.skylite.core.xcontent.XContentParser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportExplainTransformAction
extends HandledTransportAction<ExplainTransformRequest, ExplainTransformResponse> {
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final Client client;
    private final ClusterService clusterService;
    private final Settings settings;
    private final NamedXContentRegistry xContentRegistry;
    private volatile boolean filterByEnabled;

    @Inject
    public TransportExplainTransformAction(TransportService transportService, Client client, ActionFilters actionFilters, ClusterService clusterService, Settings settings, NamedXContentRegistry xContentRegistry) {
        super("cluster:admin/lucenia/transform/explain", transportService, actionFilters, ExplainTransformRequest::new);
        this.client = client;
        this.clusterService = clusterService;
        this.settings = settings;
        this.xContentRegistry = xContentRegistry;
        this.filterByEnabled = (Boolean)IndexManagementSettings.FILTER_BY_BACKEND_ROLES.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(IndexManagementSettings.FILTER_BY_BACKEND_ROLES, it -> {
            this.filterByEnabled = it;
        });
    }

    protected void doExecute(Task task, ExplainTransformRequest request, final ActionListener<ExplainTransformResponse> actionListener) {
        this.log.debug("User and roles string from thread context: {}", this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
        final List<String> ids = request.getTransformIDs();
        final Map idsToExplain = ids.stream().filter(id -> !id.contains("*")).collect(HashMap::new, (m, id) -> m.put(id, null), HashMap::putAll);
        final HashMap failedToExplain = new HashMap();
        BoolQueryBuilder queryBuilder = new BoolQueryBuilder().minimumShouldMatch(1);
        for (String id2 : ids) {
            queryBuilder.should((QueryBuilder)new WildcardQueryBuilder("transform.transform_id.keyword", "*" + id2 + "*"));
        }
        User user = SecurityUtils.buildUser(this.client.threadPool().getThreadContext());
        SecurityUtils.addUserFilter(user, queryBuilder, this.filterByEnabled, "transform.user");
        SearchRequest searchRequest = new SearchRequest(new String[]{".opendistro-ism-config"}).source(new SearchSourceBuilder().seqNoAndPrimaryTerm(Boolean.valueOf(true)).query((QueryBuilder)queryBuilder));
        try (ThreadContext.StoredContext ignored = this.client.threadPool().getThreadContext().stashContext();){
            this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

                public void onResponse(SearchResponse response) {
                    final HashMap<String, Transform> metadataIdToTransform = new HashMap<String, Transform>();
                    try {
                        for (SearchHit hit : response.getHits().getHits()) {
                            Transform transform = LuceniaExtensions.parseWithType(TransportExplainTransformAction.this.contentParser(hit.getSourceRef()), hit.getId(), hit.getSeqNo(), hit.getPrimaryTerm(), Transform::parse);
                            idsToExplain.put(transform.getId(), new ExplainTransform(transform.getMetadataId(), null));
                            if (transform.getMetadataId() == null) continue;
                            metadataIdToTransform.put(transform.getMetadataId(), transform);
                        }
                    }
                    catch (Exception e) {
                        TransportExplainTransformAction.this.log.error("Failed to parse explain response", (Throwable)e);
                        actionListener.onFailure(e);
                        return;
                    }
                    List<String> metadataIds = idsToExplain.values().stream().filter(explain -> explain != null && explain.getMetadataID() != null).map(ExplainTransform::getMetadataID).collect(Collectors.toList());
                    SearchRequest metadataSearchRequest = new SearchRequest(new String[]{".opendistro-ism-config"}).source(new SearchSourceBuilder().query((QueryBuilder)new IdsQueryBuilder().addIds(metadataIds.toArray(new String[0]))));
                    TransportExplainTransformAction.this.client.search(metadataSearchRequest, (ActionListener)new ActionListener<SearchResponse>(){

                        public void onResponse(SearchResponse response) {
                            for (SearchHit hit : response.getHits().getHits()) {
                                try {
                                    TransformMetadata metadata = LuceniaExtensions.parseWithType(TransportExplainTransformAction.this.contentParser(hit.getSourceRef()), hit.getId(), hit.getSeqNo(), hit.getPrimaryTerm(), TransformMetadata::parse);
                                    Transform transform = (Transform)metadataIdToTransform.get(metadata.getId());
                                    if (transform != null && Boolean.TRUE.equals(transform.isContinuous()) && metadata.getStatus() != TransformMetadata.Status.FAILED) {
                                        this.addContinuousStats(transform, metadata, idsToExplain);
                                        continue;
                                    }
                                    idsToExplain.computeIfPresent(metadata.getTransformId(), (key, explainTransform) -> explainTransform.withMetadata(metadata.toBuilder().shardIDToGlobalCheckpoint(null).build()));
                                }
                                catch (Exception e) {
                                    TransportExplainTransformAction.this.log.error("Failed to parse transform [" + hit.getId() + "] metadata", (Throwable)e);
                                    idsToExplain.remove(hit.getId());
                                    failedToExplain.put(hit.getId(), "Failed to parse transform metadata - " + e.getMessage());
                                }
                            }
                            actionListener.onResponse((Object)new ExplainTransformResponse(idsToExplain, failedToExplain));
                        }

                        public void onFailure(Exception e) {
                            TransportExplainTransformAction.this.log.error("Failed to search transform metadata", (Throwable)e);
                            if (e instanceof RemoteTransportException) {
                                actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)e));
                            } else {
                                actionListener.onFailure(e);
                            }
                        }

                        private void addContinuousStats(Transform transform, TransformMetadata metadata, Map<String, ExplainTransform> idsToExplain) {
                            try {
                                ContinuousTransformStats continuousStats = transform.getContinuousStats(TransportExplainTransformAction.this.client, metadata);
                                if (continuousStats == null) {
                                    TransportExplainTransformAction.this.log.error("Failed to get continuous transform stats for transform [" + transform.getId() + "]");
                                    idsToExplain.remove(transform.getId());
                                    failedToExplain.put(transform.getId(), "Failed to get continuous transform stats");
                                } else {
                                    idsToExplain.computeIfPresent(metadata.getTransformId(), (key, explainTransform) -> explainTransform.withMetadata(metadata.toBuilder().shardIDToGlobalCheckpoint(null).continuousStats(continuousStats).build()));
                                }
                            }
                            catch (Exception e) {
                                TransportExplainTransformAction.this.log.error("Failed to get continuous stats", (Throwable)e);
                                idsToExplain.remove(transform.getId());
                                failedToExplain.put(transform.getId(), "Failed to get continuous transform stats");
                            }
                        }
                    });
                }

                public void onFailure(Exception e) {
                    TransportExplainTransformAction.this.log.error("Failed to search for transforms", (Throwable)e);
                    if (e instanceof ResourceNotFoundException) {
                        String failureReason = "Failed to search transform metadata";
                        Map<String, String> nonWildcardIds = ids.stream().filter(id -> !id.contains("*")).collect(Collectors.toMap(id -> id, id -> failureReason));
                        actionListener.onResponse((Object)new ExplainTransformResponse(new HashMap<String, ExplainTransform>(), nonWildcardIds));
                    } else if (e instanceof RemoteTransportException) {
                        actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)e));
                    } else {
                        actionListener.onFailure(e);
                    }
                }
            });
        }
    }

    private XContentParser contentParser(BytesReference bytesReference) throws Exception {
        return XContentHelper.createParser((NamedXContentRegistry)this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)bytesReference, (MediaType)MediaTypeRegistry.JSON);
    }
}

