/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.transform.action.get;

import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.search.fetch.subphase.FetchSourceContext;
import java.io.IOException;

public class GetTransformRequest
extends ActionRequest {
    private final String id;
    private final FetchSourceContext srcContext;
    private final String preference;

    public GetTransformRequest(String id, FetchSourceContext srcContext, String preference) {
        this.id = id;
        this.srcContext = srcContext;
        this.preference = preference;
    }

    public GetTransformRequest(String id, FetchSourceContext srcContext) {
        this(id, srcContext, null);
    }

    public GetTransformRequest(String id) {
        this(id, null, null);
    }

    public GetTransformRequest(StreamInput sin) throws IOException {
        super(sin);
        this.id = sin.readString();
        this.srcContext = sin.readBoolean() ? new FetchSourceContext(sin) : null;
        this.preference = sin.readOptionalString();
    }

    public String getId() {
        return this.id;
    }

    public FetchSourceContext getSrcContext() {
        return this.srcContext;
    }

    public String getPreference() {
        return this.preference;
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.id == null || this.id.isBlank()) {
            validationException = ValidateActions.addValidationError((String)"id is missing", validationException);
        }
        return validationException;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.id);
        if (this.srcContext == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.srcContext.writeTo(out);
        }
        out.writeOptionalString(this.preference);
    }
}

