/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.transform.action.get;

import io.lucenia.indexmanagement.indexstatemanagement.util.RestHandlerUtils;
import io.lucenia.indexmanagement.transform.model.Transform;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.List;

public class GetTransformsResponse
extends ActionResponse
implements ToXContentObject {
    private final List<Transform> transforms;
    private final int totalTransforms;
    private final RestStatus status;

    public GetTransformsResponse(List<Transform> transforms, int totalTransforms, RestStatus status) {
        this.transforms = transforms;
        this.totalTransforms = totalTransforms;
        this.status = status;
    }

    public GetTransformsResponse(StreamInput sin) throws IOException {
        super(sin);
        this.transforms = sin.readList(Transform::new);
        this.totalTransforms = sin.readInt();
        this.status = (RestStatus)sin.readEnum(RestStatus.class);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.transforms);
        out.writeInt(this.totalTransforms);
        out.writeEnum((Enum)this.status);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field("total_transforms", this.totalTransforms).startArray("transforms");
        for (Transform transform : this.transforms) {
            builder.startObject().field("_id", transform.getId()).field("_seq_no", transform.getSeqNo()).field("_primary_term", transform.getPrimaryTerm()).field("transform");
            transform.toXContent(builder, (ToXContent.Params)RestHandlerUtils.XCONTENT_WITHOUT_TYPE_AND_USER);
            builder.endObject();
        }
        builder.endArray();
        return builder.endObject();
    }

    public List<Transform> getTransforms() {
        return this.transforms;
    }

    public int getTotalTransforms() {
        return this.totalTransforms;
    }

    public RestStatus getStatus() {
        return this.status;
    }
}

