/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.transform.action.get;

import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.lucenia.indexmanagement.settings.IndexManagementSettings;
import io.lucenia.indexmanagement.transform.action.get.GetTransformRequest;
import io.lucenia.indexmanagement.transform.action.get.GetTransformResponse;
import io.lucenia.indexmanagement.transform.model.Transform;
import io.lucenia.indexmanagement.util.SecurityUtils;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.get.GetRequest;
import io.skylite.core.action.get.GetResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.security.auth.User;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.NamedXContentRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportGetTransformAction
extends HandledTransportAction<GetTransformRequest, GetTransformResponse> {
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final Client client;
    private final Settings settings;
    private final ClusterService clusterService;
    private final NamedXContentRegistry xContentRegistry;
    private volatile boolean filterByEnabled;

    @Inject
    public TransportGetTransformAction(TransportService transportService, Client client, Settings settings, ClusterService clusterService, ActionFilters actionFilters, NamedXContentRegistry xContentRegistry) {
        super("cluster:admin/lucenia/transform/get", transportService, actionFilters, GetTransformRequest::new);
        this.client = client;
        this.settings = settings;
        this.clusterService = clusterService;
        this.xContentRegistry = xContentRegistry;
        this.filterByEnabled = (Boolean)IndexManagementSettings.FILTER_BY_BACKEND_ROLES.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(IndexManagementSettings.FILTER_BY_BACKEND_ROLES, it -> {
            this.filterByEnabled = it;
        });
    }

    protected void doExecute(Task task, final GetTransformRequest request, final ActionListener<GetTransformResponse> listener) {
        this.log.debug("User and roles string from thread context: {}", this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
        final User user = SecurityUtils.buildUser(this.client.threadPool().getThreadContext());
        GetRequest getRequest = new GetRequest(".opendistro-ism-config", request.getId()).preference(request.getPreference());
        try (ThreadContext.StoredContext ignored = this.client.threadPool().getThreadContext().stashContext();){
            this.client.get(getRequest, (ActionListener)new ActionListener<GetResponse>(){

                public void onResponse(GetResponse response) {
                    if (!response.isExists()) {
                        listener.onFailure((Exception)((Object)new SkyliteStatusException("Transform not found", RestStatus.NOT_FOUND, new Object[0])));
                        return;
                    }
                    try {
                        Transform transform;
                        try {
                            transform = LuceniaExtensions.parseFromGetResponse(response, TransportGetTransformAction.this.xContentRegistry, Transform::parse);
                        }
                        catch (IllegalArgumentException e) {
                            listener.onFailure((Exception)((Object)new SkyliteStatusException("Transform not found", RestStatus.NOT_FOUND, new Object[0])));
                            return;
                        }
                        if (!SecurityUtils.userHasPermissionForResource(user, transform.getUser(), TransportGetTransformAction.this.filterByEnabled, "transform", request.getId(), listener)) {
                            return;
                        }
                        GetTransformResponse transformResponse = request.getSrcContext() != null && !request.getSrcContext().fetchSource() ? new GetTransformResponse(response.getId(), response.getVersion(), response.getSeqNo(), response.getPrimaryTerm(), RestStatus.OK, null) : new GetTransformResponse(response.getId(), response.getVersion(), response.getSeqNo(), response.getPrimaryTerm(), RestStatus.OK, transform);
                        listener.onResponse((Object)transformResponse);
                    }
                    catch (Exception e) {
                        listener.onFailure((Exception)((Object)new SkyliteStatusException("Failed to parse transform", RestStatus.INTERNAL_SERVER_ERROR, SkyliteExceptionsHelper.unwrapCause((Throwable)e), new Object[0])));
                    }
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        }
    }
}

