/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.transform.action.get;

import io.lucenia.indexmanagement.settings.IndexManagementSettings;
import io.lucenia.indexmanagement.transform.action.get.GetTransformsRequest;
import io.lucenia.indexmanagement.transform.action.get.GetTransformsResponse;
import io.lucenia.indexmanagement.util.ScheduledJobUtils;
import io.lucenia.indexmanagement.util.SecurityUtils;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.index.query.BoolQueryBuilder;
import io.skylite.core.index.query.ExistsQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.WildcardQueryBuilder;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.search.sort.SortOrder;
import io.skylite.core.security.auth.User;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportGetTransformsAction
extends HandledTransportAction<GetTransformsRequest, GetTransformsResponse> {
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final Client client;
    private final Settings settings;
    private final ClusterService clusterService;
    private final NamedXContentRegistry xContentRegistry;
    private volatile boolean filterByEnabled;

    @Inject
    public TransportGetTransformsAction(TransportService transportService, Client client, Settings settings, ClusterService clusterService, ActionFilters actionFilters, NamedXContentRegistry xContentRegistry) {
        super("cluster:admin/lucenia/transform/get_transforms", transportService, actionFilters, GetTransformsRequest::new);
        this.client = client;
        this.settings = settings;
        this.clusterService = clusterService;
        this.xContentRegistry = xContentRegistry;
        this.filterByEnabled = (Boolean)IndexManagementSettings.FILTER_BY_BACKEND_ROLES.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(IndexManagementSettings.FILTER_BY_BACKEND_ROLES, it -> {
            this.filterByEnabled = it;
        });
    }

    protected void doExecute(Task task, GetTransformsRequest request, ActionListener<GetTransformsResponse> listener) {
        this.log.debug("User and roles string from thread context: {}", this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
        String searchString = request.getSearchString().trim();
        int from = request.getFrom();
        int size = request.getSize();
        String sortField = request.getSortField();
        String sortDirection = request.getSortDirection();
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder().filter((QueryBuilder)new ExistsQueryBuilder("transform"));
        if (!searchString.isEmpty()) {
            boolQueryBuilder.filter((QueryBuilder)new WildcardQueryBuilder("transform.transform_id.keyword", "*" + searchString + "*"));
        }
        User user = SecurityUtils.buildUser(this.client.threadPool().getThreadContext());
        SecurityUtils.addUserFilter(user, boolQueryBuilder, this.filterByEnabled, "transform.user");
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)boolQueryBuilder).from(from).size(size).seqNoAndPrimaryTerm(Boolean.valueOf(true)).sort(sortField, SortOrder.fromString((String)sortDirection));
        try (ThreadContext.StoredContext ignored = this.client.threadPool().getThreadContext().stashContext();){
            ScheduledJobUtils.getJobs(this.client, searchSourceBuilder, listener, "transform", (bytesRef, unused) -> {
                try {
                    return XContentHelper.createParser((NamedXContentRegistry)this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)bytesRef, (MediaType)MediaTypeRegistry.JSON);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }
}

