/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.transform.action.index;

import io.lucenia.indexmanagement.transform.model.Transform;
import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.core.action.DocWriteRequest;
import io.skylite.core.action.WriteRequest;
import io.skylite.core.action.index.IndexRequest;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import java.io.IOException;

public class IndexTransformRequest
extends IndexRequest {
    private Transform transform;

    public IndexTransformRequest(StreamInput sin) throws IOException {
        super(sin);
        this.transform = new Transform(sin);
        super.setRefreshPolicy(WriteRequest.RefreshPolicy.readFrom((StreamInput)sin));
    }

    public IndexTransformRequest(Transform transform, WriteRequest.RefreshPolicy refreshPolicy) {
        this.transform = transform;
        if (transform.getSeqNo() == -2L || transform.getPrimaryTerm() == 0L) {
            this.opType(DocWriteRequest.OpType.CREATE);
        } else {
            this.setIfSeqNo(transform.getSeqNo());
            this.setIfPrimaryTerm(transform.getPrimaryTerm());
        }
        super.setRefreshPolicy(refreshPolicy);
    }

    public Transform getTransform() {
        return this.transform;
    }

    public void setTransform(Transform transform) {
        this.transform = transform;
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.transform.getId() == null || this.transform.getId().isBlank()) {
            validationException = ValidateActions.addValidationError((String)"transformID is missing", validationException);
        }
        return validationException;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.transform.writeTo(out);
        this.getRefreshPolicy().writeTo(out);
    }
}

