/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.transform.action.index;

import io.lucenia.indexmanagement.IndexManagementIndices;
import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.lucenia.indexmanagement.settings.IndexManagementSettings;
import io.lucenia.indexmanagement.transform.TransformValidator;
import io.lucenia.indexmanagement.transform.action.index.IndexTransformRequest;
import io.lucenia.indexmanagement.transform.action.index.IndexTransformResponse;
import io.lucenia.indexmanagement.transform.model.Transform;
import io.lucenia.indexmanagement.util.IndexUtils;
import io.lucenia.indexmanagement.util.SecurityUtils;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.common.xcontent.XContentFactory;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.DocWriteRequest;
import io.skylite.core.action.admin.indices.mapping.get.GetMappingsAction;
import io.skylite.core.action.admin.indices.mapping.get.GetMappingsRequest;
import io.skylite.core.action.admin.indices.mapping.get.GetMappingsResponse;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.action.get.GetRequest;
import io.skylite.core.action.get.GetResponse;
import io.skylite.core.action.index.IndexRequest;
import io.skylite.core.action.index.IndexResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.security.auth.User;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.ToXContent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportIndexTransformAction
extends HandledTransportAction<IndexTransformRequest, IndexTransformResponse> {
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final Client client;
    private final IndexManagementIndices indexManagementIndices;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final ClusterService clusterService;
    private final Settings settings;
    private final NamedXContentRegistry xContentRegistry;
    private volatile boolean filterByEnabled;

    @Inject
    public TransportIndexTransformAction(TransportService transportService, Client client, ActionFilters actionFilters, IndexManagementIndices indexManagementIndices, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService, Settings settings, NamedXContentRegistry xContentRegistry) {
        super("cluster:admin/lucenia/transform/index", transportService, actionFilters, IndexTransformRequest::new);
        this.client = client;
        this.indexManagementIndices = indexManagementIndices;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.clusterService = clusterService;
        this.settings = settings;
        this.xContentRegistry = xContentRegistry;
        this.filterByEnabled = (Boolean)IndexManagementSettings.FILTER_BY_BACKEND_ROLES.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(IndexManagementSettings.FILTER_BY_BACKEND_ROLES, it -> {
            this.filterByEnabled = it;
        });
    }

    protected void doExecute(Task task, IndexTransformRequest request, ActionListener<IndexTransformResponse> listener) {
        new IndexTransformHandler(this.client, listener, request).start();
    }

    class IndexTransformHandler {
        private final Client client;
        private final ActionListener<IndexTransformResponse> actionListener;
        private final IndexTransformRequest request;
        private final User user;

        IndexTransformHandler(Client client, ActionListener<IndexTransformResponse> actionListener, IndexTransformRequest request) {
            this.client = client;
            this.actionListener = actionListener;
            this.request = request;
            this.user = SecurityUtils.buildUser(client.threadPool().getThreadContext(), request.getTransform().getUser());
        }

        void start() {
            TransportIndexTransformAction.this.log.debug("User and roles string from thread context: {}", this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
            try (ThreadContext.StoredContext ignored = this.client.threadPool().getThreadContext().stashContext();){
                if (!SecurityUtils.validateUserConfiguration(this.user, TransportIndexTransformAction.this.filterByEnabled, this.actionListener)) {
                    return;
                }
                TransportIndexTransformAction.this.indexManagementIndices.checkAndUpdateIMConfigIndex((ActionListener<AcknowledgedResponse>)ActionListener.wrap(this::onConfigIndexAcknowledgedResponse, arg_0 -> this.actionListener.onFailure(arg_0)));
            }
        }

        private void onConfigIndexAcknowledgedResponse(AcknowledgedResponse response) {
            if (response.isAcknowledged()) {
                TransportIndexTransformAction.this.log.info("Successfully created or updated {} with newest mappings.", (Object)".opendistro-ism-config");
                if (this.request.opType() == DocWriteRequest.OpType.CREATE) {
                    this.validateAndPutTransform();
                } else {
                    this.updateTransform();
                }
            } else {
                String message = "Unable to create or update .opendistro-ism-config with newest mappings.";
                TransportIndexTransformAction.this.log.error(message);
                this.actionListener.onFailure((Exception)((Object)new SkyliteStatusException(message, RestStatus.INTERNAL_SERVER_ERROR, new Object[0])));
            }
        }

        private void updateTransform() {
            GetRequest getRequest = new GetRequest(".opendistro-ism-config", this.request.getTransform().getId());
            this.client.get(getRequest, ActionListener.wrap(this::onGetTransform, arg_0 -> this.actionListener.onFailure(arg_0)));
        }

        private void onGetTransform(GetResponse response) throws IOException {
            Transform transform;
            if (!response.isExists()) {
                this.actionListener.onFailure((Exception)((Object)new SkyliteStatusException("Transform not found", RestStatus.NOT_FOUND, new Object[0])));
                return;
            }
            try {
                transform = LuceniaExtensions.parseFromGetResponse(response, TransportIndexTransformAction.this.xContentRegistry, Transform::parse);
            }
            catch (IllegalArgumentException e) {
                this.actionListener.onFailure((Exception)((Object)new SkyliteStatusException("Transform not found", RestStatus.NOT_FOUND, new Object[0])));
                return;
            }
            if (!SecurityUtils.userHasPermissionForResource(this.user, transform.getUser(), TransportIndexTransformAction.this.filterByEnabled, "transform", transform.getId(), this.actionListener)) {
                return;
            }
            List<String> modified = this.modifiedImmutableProperties(transform, this.request.getTransform());
            if (!modified.isEmpty()) {
                this.actionListener.onFailure((Exception)((Object)new SkyliteStatusException("Not allowed to modify " + String.valueOf(modified), RestStatus.BAD_REQUEST, new Object[0])));
                return;
            }
            this.putTransform();
        }

        private List<String> modifiedImmutableProperties(Transform transform, Transform newTransform) {
            ArrayList<String> modified = new ArrayList<String>();
            if (!transform.getSourceIndex().equals(newTransform.getSourceIndex())) {
                modified.add("source_index");
            }
            if (!transform.getTargetIndex().equals(newTransform.getTargetIndex())) {
                modified.add("target_index");
            }
            if (!transform.getDataSelectionQuery().equals((Object)newTransform.getDataSelectionQuery())) {
                modified.add("data_selection_query");
            }
            if (!transform.getGroups().equals(newTransform.getGroups())) {
                modified.add("groups");
            }
            if (!transform.getAggregations().equals((Object)newTransform.getAggregations())) {
                modified.add("aggregations");
            }
            if (!transform.isContinuous() == newTransform.isContinuous()) {
                modified.add("continuous");
            }
            return modified;
        }

        private void putTransform() {
            try {
                final Transform transform = new Transform.Builder(this.request.getTransform()).schemaVersion(IndexUtils.getIndexManagementConfigSchemaVersion()).user(this.user).build();
                ((IndexRequest)this.request.index(".opendistro-ism-config")).id(this.request.getTransform().getId()).source(transform.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS)).timeout(IndexRequest.DEFAULT_TIMEOUT);
                this.client.index((IndexRequest)this.request, (ActionListener)new ActionListener<IndexResponse>(){

                    public void onResponse(IndexResponse response) {
                        if (response.getShardInfo().getFailed() > 0) {
                            String failureReasons = String.join((CharSequence)",", (CharSequence[])Arrays.stream(response.getShardInfo().getFailures()).map(failure -> failure.reason()).toArray(String[]::new));
                            IndexTransformHandler.this.actionListener.onFailure((Exception)((Object)new SkyliteStatusException(failureReasons, response.status(), new Object[0])));
                        } else {
                            RestStatus status = IndexTransformHandler.this.request.opType() == DocWriteRequest.OpType.CREATE ? RestStatus.CREATED : RestStatus.OK;
                            Transform responseTransform = new Transform.Builder(transform).seqNo(response.getSeqNo()).primaryTerm(response.getPrimaryTerm()).build();
                            IndexTransformHandler.this.actionListener.onResponse((Object)new IndexTransformResponse(response.getId(), response.getVersion(), response.getSeqNo(), response.getPrimaryTerm(), status, responseTransform));
                        }
                    }

                    public void onFailure(Exception e) {
                        IndexTransformHandler.this.actionListener.onFailure(e);
                    }
                });
            }
            catch (Exception e) {
                this.actionListener.onFailure(e);
            }
        }

        private void validateAndPutTransform() {
            final String[] concreteIndices = TransportIndexTransformAction.this.indexNameExpressionResolver.concreteIndexNames(TransportIndexTransformAction.this.clusterService.state(), IndicesOptions.lenientExpand(), true, new String[]{this.request.getTransform().getSourceIndex()});
            if (concreteIndices.length == 0) {
                this.actionListener.onFailure((Exception)((Object)new SkyliteStatusException("No specified source index exist in the cluster", RestStatus.NOT_FOUND, new Object[0])));
                return;
            }
            GetMappingsRequest mappingRequest = (GetMappingsRequest)new GetMappingsRequest().indices(concreteIndices);
            this.client.execute((ActionType)GetMappingsAction.INSTANCE, (ActionRequest)mappingRequest, (ActionListener)new ActionListener<GetMappingsResponse>(){

                public void onResponse(GetMappingsResponse response) {
                    List<String> issues = IndexTransformHandler.this.validateMappings(Arrays.asList(concreteIndices), response, IndexTransformHandler.this.request.getTransform());
                    if (!issues.isEmpty()) {
                        String errorMessage = String.join((CharSequence)" ", issues);
                        IndexTransformHandler.this.actionListener.onFailure((Exception)((Object)new SkyliteStatusException(errorMessage, RestStatus.BAD_REQUEST, new Object[0])));
                        return;
                    }
                    IndexTransformHandler.this.putTransform();
                }

                public void onFailure(Exception e) {
                    IndexTransformHandler.this.actionListener.onFailure(e);
                }
            });
        }

        private List<String> validateMappings(List<String> indices, GetMappingsResponse response, Transform transform) {
            ArrayList<String> issues = new ArrayList<String>();
            for (String index : indices) {
                issues.addAll(TransformValidator.validateMappingsResponse(index, response, transform));
            }
            return issues;
        }
    }
}

