/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.transform.action.preview;

import io.lucenia.indexmanagement.luceniaapi.IndexManagementSecurityContext;
import io.lucenia.indexmanagement.transform.TargetIndexMappingService;
import io.lucenia.indexmanagement.transform.TransformSearchService;
import io.lucenia.indexmanagement.transform.TransformValidator;
import io.lucenia.indexmanagement.transform.action.preview.PreviewTransformRequest;
import io.lucenia.indexmanagement.transform.action.preview.PreviewTransformResponse;
import io.lucenia.indexmanagement.transform.model.Transform;
import io.lucenia.indexmanagement.transform.model.TransformSearchResult;
import io.lucenia.indexmanagement.util.SecurityUtils;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.indices.mapping.get.GetMappingsAction;
import io.skylite.core.action.admin.indices.mapping.get.GetMappingsRequest;
import io.skylite.core.action.admin.indices.mapping.get.GetMappingsResponse;
import io.skylite.core.action.index.IndexRequest;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.security.auth.User;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportPreviewTransformAction
extends HandledTransportAction<PreviewTransformRequest, PreviewTransformResponse> {
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final Settings settings;
    private final Client client;
    private final ClusterService clusterService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    @Inject
    public TransportPreviewTransformAction(TransportService transportService, ActionFilters actionFilters, Settings settings, Client client, ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/lucenia/transform/preview", transportService, actionFilters, PreviewTransformRequest::new);
        this.settings = settings;
        this.client = client;
        this.clusterService = clusterService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
    }

    protected void doExecute(Task task, PreviewTransformRequest request, final ActionListener<PreviewTransformResponse> listener) {
        this.log.debug("User and roles string from thread context: {}", this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
        final Transform transform = request.getTransform();
        final String[] concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(this.clusterService.state(), IndicesOptions.lenientExpand(), true, new String[]{transform.getSourceIndex()});
        if (concreteIndices.length == 0) {
            listener.onFailure((Exception)((Object)new SkyliteStatusException("No specified source index exist in the cluster", RestStatus.NOT_FOUND, new Object[0])));
            return;
        }
        GetMappingsRequest mappingRequest = (GetMappingsRequest)new GetMappingsRequest().indices(concreteIndices);
        this.client.execute((ActionType)GetMappingsAction.INSTANCE, (ActionRequest)mappingRequest, (ActionListener)new ActionListener<GetMappingsResponse>(){

            public void onResponse(GetMappingsResponse response) {
                List<String> issues = TransportPreviewTransformAction.this.validateMappings(Arrays.asList(concreteIndices), response, transform);
                if (!issues.isEmpty()) {
                    String errorMessage = String.join((CharSequence)" ", issues);
                    listener.onFailure((Exception)((Object)new SkyliteStatusException(errorMessage, RestStatus.BAD_REQUEST, new Object[0])));
                    return;
                }
                User user = SecurityUtils.buildUser(TransportPreviewTransformAction.this.client.threadPool().getThreadContext());
                try (IndexManagementSecurityContext context = new IndexManagementSecurityContext("PreviewTransformHandler", TransportPreviewTransformAction.this.settings, TransportPreviewTransformAction.this.client.threadPool().getThreadContext(), user);){
                    SearchRequest searchRequest = TransformSearchService.getSearchServiceRequest(transform, null, 10, null, null);
                    TransportPreviewTransformAction.this.executeSearch(searchRequest, transform, (ActionListener<PreviewTransformResponse>)listener);
                }
                catch (Exception e) {
                    listener.onFailure(e);
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    public List<String> validateMappings(List<String> indices, GetMappingsResponse response, Transform transform) {
        ArrayList<String> issues = new ArrayList<String>();
        for (String index : indices) {
            issues.addAll(TransformValidator.validateMappingsResponse(index, response, transform));
        }
        return issues;
    }

    public void executeSearch(SearchRequest searchRequest, final Transform transform, final ActionListener<PreviewTransformResponse> listener) {
        this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(this){

            public void onResponse(SearchResponse searchResponse) {
                try {
                    Map<String, Object> targetIndexDateFieldMappings = TargetIndexMappingService.getTargetMappingsForDates(transform).join();
                    TransformSearchResult transformSearchResult = TransformSearchService.convertResponse(transform, searchResponse, false, null, targetIndexDateFieldMappings);
                    List<Map<String, Object>> formattedResult = transformSearchResult.getDocsToIndex().stream().map(IndexRequest::sourceAsMap).collect(Collectors.toList());
                    listener.onResponse((Object)new PreviewTransformResponse(formattedResult, RestStatus.OK));
                }
                catch (Exception e) {
                    listener.onFailure((Exception)((Object)new SkyliteStatusException("Failed to parse the transformed results", RestStatus.INTERNAL_SERVER_ERROR, SkyliteExceptionsHelper.unwrapCause((Throwable)e), new Object[0])));
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }
}

