/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.transform.action.start;

import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.lucenia.indexmanagement.settings.IndexManagementSettings;
import io.lucenia.indexmanagement.transform.action.start.StartTransformRequest;
import io.lucenia.indexmanagement.transform.model.Transform;
import io.lucenia.indexmanagement.transform.model.TransformMetadata;
import io.lucenia.indexmanagement.util.SecurityUtils;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.DocWriteResponse;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.action.get.GetRequest;
import io.skylite.core.action.get.GetResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.action.update.UpdateRequest;
import io.skylite.core.action.update.UpdateResponse;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.security.auth.User;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentHelper;
import java.io.IOException;
import java.time.Instant;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportStartTransformAction
extends HandledTransportAction<StartTransformRequest, AcknowledgedResponse> {
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final Client client;
    private final Settings settings;
    private final ClusterService clusterService;
    private final NamedXContentRegistry xContentRegistry;
    private volatile boolean filterByEnabled;

    @Inject
    public TransportStartTransformAction(TransportService transportService, Client client, Settings settings, ClusterService clusterService, ActionFilters actionFilters, NamedXContentRegistry xContentRegistry) {
        super("cluster:admin/lucenia/transform/start", transportService, actionFilters, StartTransformRequest::new);
        this.client = client;
        this.settings = settings;
        this.clusterService = clusterService;
        this.xContentRegistry = xContentRegistry;
        this.filterByEnabled = (Boolean)IndexManagementSettings.FILTER_BY_BACKEND_ROLES.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(IndexManagementSettings.FILTER_BY_BACKEND_ROLES, it -> {
            this.filterByEnabled = it;
        });
    }

    protected void doExecute(Task task, final StartTransformRequest request, final ActionListener<AcknowledgedResponse> actionListener) {
        this.log.debug("User and roles string from thread context: {}", this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
        GetRequest getRequest = new GetRequest(".opendistro-ism-config", request.getId());
        final User user = SecurityUtils.buildUser(this.client.threadPool().getThreadContext());
        try (ThreadContext.StoredContext ignored = this.client.threadPool().getThreadContext().stashContext();){
            this.client.get(getRequest, (ActionListener)new ActionListener<GetResponse>(){

                public void onResponse(GetResponse response) {
                    Transform transform;
                    if (!response.isExists()) {
                        actionListener.onFailure((Exception)((Object)new SkyliteStatusException("Transform not found", RestStatus.NOT_FOUND, new Object[0])));
                        return;
                    }
                    try {
                        transform = LuceniaExtensions.parseFromGetResponse(response, TransportStartTransformAction.this.xContentRegistry, Transform::parse);
                    }
                    catch (IOException | IllegalArgumentException e) {
                        actionListener.onFailure((Exception)((Object)new SkyliteStatusException("Transform not found", RestStatus.NOT_FOUND, new Object[0])));
                        return;
                    }
                    if (!SecurityUtils.userHasPermissionForResource(user, transform.getUser(), TransportStartTransformAction.this.filterByEnabled, "transform", transform.getId(), actionListener)) {
                        return;
                    }
                    if (transform.isEnabled()) {
                        TransportStartTransformAction.this.log.debug("Transform job is already enabled, checking if metadata needs to be updated");
                        if (transform.getMetadataId() == null) {
                            actionListener.onResponse((Object)new AcknowledgedResponse(true));
                        } else {
                            TransportStartTransformAction.this.retrieveAndUpdateTransformMetadata(transform, (ActionListener<AcknowledgedResponse>)actionListener);
                        }
                        return;
                    }
                    TransportStartTransformAction.this.updateTransformJob(transform, request, (ActionListener<AcknowledgedResponse>)actionListener);
                }

                public void onFailure(Exception e) {
                    actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)e));
                }
            });
        }
    }

    private void updateTransformJob(final Transform transform, StartTransformRequest request, final ActionListener<AcknowledgedResponse> actionListener) {
        long now = Instant.now().toEpochMilli();
        UpdateRequest updateReq = new UpdateRequest(".opendistro-ism-config", request.getId());
        HashMap<String, Comparable<Boolean>> transformMap = new HashMap<String, Comparable<Boolean>>();
        transformMap.put("enabled", Boolean.valueOf(true));
        transformMap.put("enabled_at", Long.valueOf(now));
        transformMap.put("updated_at", Long.valueOf(now));
        HashMap<String, HashMap<String, Comparable<Boolean>>> doc = new HashMap<String, HashMap<String, Comparable<Boolean>>>();
        doc.put("transform", transformMap);
        updateReq.doc(doc);
        this.client.update(updateReq, (ActionListener)new ActionListener<UpdateResponse>(){

            public void onResponse(UpdateResponse response) {
                if (response.getResult() == DocWriteResponse.Result.UPDATED) {
                    if (transform.getMetadataId() != null) {
                        TransportStartTransformAction.this.retrieveAndUpdateTransformMetadata(transform, (ActionListener<AcknowledgedResponse>)actionListener);
                    } else {
                        actionListener.onResponse((Object)new AcknowledgedResponse(true));
                    }
                } else {
                    actionListener.onResponse((Object)new AcknowledgedResponse(false));
                }
            }

            public void onFailure(Exception e) {
                actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)e));
            }
        });
    }

    private void retrieveAndUpdateTransformMetadata(final Transform transform, final ActionListener<AcknowledgedResponse> actionListener) {
        final GetRequest req = new GetRequest(".opendistro-ism-config", transform.getMetadataId()).routing(transform.getId());
        this.client.get(req, (ActionListener)new ActionListener<GetResponse>(){

            public void onResponse(GetResponse response) {
                if (!response.isExists() || response.isSourceEmpty()) {
                    actionListener.onFailure((Exception)((Object)new SkyliteStatusException("Metadata doc missing for transform [" + req.id() + "]", RestStatus.NOT_FOUND, new Object[0])));
                } else {
                    try {
                        TransformMetadata metadata = LuceniaExtensions.parseWithType(XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)response.getSourceAsBytesRef(), (MediaType)MediaTypeRegistry.JSON), response.getId(), response.getSeqNo(), response.getPrimaryTerm(), TransformMetadata::parse);
                        TransportStartTransformAction.this.updateTransformMetadata(transform, metadata, (ActionListener<AcknowledgedResponse>)actionListener);
                    }
                    catch (Exception e) {
                        actionListener.onFailure((Exception)((Object)new SkyliteStatusException("Metadata doc missing for transform [" + req.id() + "]", RestStatus.NOT_FOUND, new Object[0])));
                    }
                }
            }

            public void onFailure(Exception e) {
                actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)e));
            }
        });
    }

    private void updateTransformMetadata(Transform transform, TransformMetadata metadata, final ActionListener<AcknowledgedResponse> actionListener) {
        TransformMetadata.Status updatedStatus;
        long now = Instant.now().toEpochMilli();
        switch (metadata.getStatus()) {
            case FINISHED: 
            case STOPPED: {
                updatedStatus = TransformMetadata.Status.STARTED;
                break;
            }
            case STARTED: 
            case INIT: {
                actionListener.onResponse((Object)new AcknowledgedResponse(true));
                return;
            }
            case FAILED: {
                updatedStatus = TransformMetadata.Status.STARTED;
                break;
            }
            default: {
                updatedStatus = TransformMetadata.Status.STARTED;
            }
        }
        HashMap<String, Object> metadataMap = new HashMap<String, Object>();
        metadataMap.put("status", updatedStatus.getType());
        metadataMap.put("failure_reason", null);
        metadataMap.put("last_updated_at", now);
        HashMap<String, HashMap<String, Object>> doc = new HashMap<String, HashMap<String, Object>>();
        doc.put("transform_metadata", metadataMap);
        UpdateRequest updateRequest = new UpdateRequest(".opendistro-ism-config", transform.getMetadataId()).doc(doc).routing(transform.getId());
        this.client.update(updateRequest, (ActionListener)new ActionListener<UpdateResponse>(){

            public void onResponse(UpdateResponse response) {
                actionListener.onResponse((Object)new AcknowledgedResponse(response.getResult() == DocWriteResponse.Result.UPDATED));
            }

            public void onFailure(Exception e) {
                actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)e));
            }
        });
    }
}

