/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.transform.model;

import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class BucketSearchResult {
    private final Set<Map<String, Object>> modifiedBuckets;
    private final Map<String, Object> afterKey;
    private final long searchTimeInMillis;

    public BucketSearchResult(Set<Map<String, Object>> modifiedBuckets, Map<String, Object> afterKey, long searchTimeInMillis) {
        this.modifiedBuckets = modifiedBuckets;
        this.afterKey = afterKey;
        this.searchTimeInMillis = searchTimeInMillis;
    }

    public BucketSearchResult(Set<Map<String, Object>> modifiedBuckets) {
        this(modifiedBuckets, null, 0L);
    }

    public Set<Map<String, Object>> getModifiedBuckets() {
        return this.modifiedBuckets;
    }

    public Map<String, Object> getAfterKey() {
        return this.afterKey;
    }

    public long getSearchTimeInMillis() {
        return this.searchTimeInMillis;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BucketSearchResult that = (BucketSearchResult)o;
        return this.searchTimeInMillis == that.searchTimeInMillis && Objects.equals(this.modifiedBuckets, that.modifiedBuckets) && Objects.equals(this.afterKey, that.afterKey);
    }

    public int hashCode() {
        return Objects.hash(this.modifiedBuckets, this.afterKey, this.searchTimeInMillis);
    }

    public String toString() {
        return "BucketSearchResult{modifiedBuckets=" + String.valueOf(this.modifiedBuckets) + ", afterKey=" + String.valueOf(this.afterKey) + ", searchTimeInMillis=" + this.searchTimeInMillis + "}";
    }
}

