/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.transform.model;

import io.lucenia.indexmanagement.transform.model.ShardNewDocuments;
import io.lucenia.indexmanagement.transform.model.TransformMetadata;
import io.skylite.core.index.shard.ShardId;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class BucketsToTransform {
    private final Set<Map<String, Object>> modifiedBuckets;
    private final TransformMetadata metadata;
    private final Iterator<ShardNewDocuments> shardsToSearch;
    private final ShardNewDocuments currentShard;

    public BucketsToTransform(Set<Map<String, Object>> modifiedBuckets, TransformMetadata metadata, Iterator<ShardNewDocuments> shardsToSearch, ShardNewDocuments currentShard) {
        this.modifiedBuckets = modifiedBuckets;
        this.metadata = metadata;
        this.shardsToSearch = shardsToSearch;
        this.currentShard = currentShard;
    }

    public BucketsToTransform(Set<Map<String, Object>> modifiedBuckets, TransformMetadata metadata) {
        this(modifiedBuckets, metadata, null, null);
    }

    public BucketsToTransform(Iterator<ShardNewDocuments> shardsToSearch, Set<Map<String, Object>> modifiedBuckets, TransformMetadata metadata) {
        this(modifiedBuckets, metadata, shardsToSearch, null);
    }

    private BucketsToTransform(Builder b) {
        this.modifiedBuckets = b.modifiedBuckets;
        this.metadata = b.metadata;
        this.shardsToSearch = b.shardsToSearch;
        this.currentShard = b.currentShard;
    }

    public Set<Map<String, Object>> getModifiedBuckets() {
        return this.modifiedBuckets;
    }

    public TransformMetadata getMetadata() {
        return this.metadata;
    }

    public Iterator<ShardNewDocuments> getShardsToSearch() {
        return this.shardsToSearch;
    }

    public ShardNewDocuments getCurrentShard() {
        return this.currentShard;
    }

    public BucketsToTransform initializeShardsToSearch(Map<ShardId, Long> originalGlobalCheckpoints, Map<ShardId, Long> currentShardIdToGlobalCheckpoint) {
        Iterator<ShardNewDocuments> shardsToSearch;
        return new BucketsToTransform(this.modifiedBuckets, this.metadata, shardsToSearch, (shardsToSearch = BucketsToTransform.getShardsToSearch(originalGlobalCheckpoints, currentShardIdToGlobalCheckpoint).iterator()).hasNext() ? shardsToSearch.next() : null);
    }

    private static List<ShardNewDocuments> getShardsToSearch(Map<ShardId, Long> oldShardIDToMaxSeqNo, Map<ShardId, Long> newShardIDToMaxSeqNo) {
        ArrayList<ShardNewDocuments> shardsToSearch = new ArrayList<ShardNewDocuments>();
        for (Map.Entry<ShardId, Long> entry : newShardIDToMaxSeqNo.entrySet()) {
            ShardId shardId = entry.getKey();
            Long currentMaxSeqNo = entry.getValue();
            if (oldShardIDToMaxSeqNo != null && oldShardIDToMaxSeqNo.containsKey(shardId) && currentMaxSeqNo <= oldShardIDToMaxSeqNo.get(shardId)) continue;
            Long oldSeqNo = oldShardIDToMaxSeqNo != null ? oldShardIDToMaxSeqNo.get(shardId) : null;
            shardsToSearch.add(new ShardNewDocuments(shardId, oldSeqNo, currentMaxSeqNo));
        }
        return shardsToSearch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BucketsToTransform that = (BucketsToTransform)o;
        return Objects.equals(this.modifiedBuckets, that.modifiedBuckets) && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.shardsToSearch, that.shardsToSearch) && Objects.equals(this.currentShard, that.currentShard);
    }

    public int hashCode() {
        return Objects.hash(this.modifiedBuckets, this.metadata, this.shardsToSearch, this.currentShard);
    }

    public String toString() {
        return "BucketsToTransform{modifiedBuckets=" + String.valueOf(this.modifiedBuckets) + ", metadata=" + String.valueOf(this.metadata) + ", shardsToSearch=" + String.valueOf(this.shardsToSearch) + ", currentShard=" + String.valueOf(this.currentShard) + "}";
    }

    public static class Builder {
        private Set<Map<String, Object>> modifiedBuckets;
        private TransformMetadata metadata;
        private Iterator<ShardNewDocuments> shardsToSearch;
        private ShardNewDocuments currentShard;

        public Builder() {
        }

        public Builder(BucketsToTransform bucketsToTransform) {
            this.modifiedBuckets = bucketsToTransform.modifiedBuckets;
            this.metadata = bucketsToTransform.metadata;
            this.shardsToSearch = bucketsToTransform.shardsToSearch;
            this.currentShard = bucketsToTransform.currentShard;
        }

        public Builder modifiedBuckets(Set<Map<String, Object>> modifiedBuckets) {
            this.modifiedBuckets = modifiedBuckets;
            return this;
        }

        public Builder metadata(TransformMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder shardsToSearch(Iterator<ShardNewDocuments> shardsToSearch) {
            this.shardsToSearch = shardsToSearch;
            return this;
        }

        public Builder currentShard(ShardNewDocuments currentShard) {
            this.currentShard = currentShard;
            return this;
        }

        public BucketsToTransform build() {
            return new BucketsToTransform(this);
        }
    }
}

