/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.transform.model;

import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ContinuousTransformStats
implements ToXContentObject,
Writeable {
    private static final String LAST_TIMESTAMP_FIELD = "last_timestamp";
    private static final String LAST_TIMESTAMP_FIELD_IN_MILLIS = "last_timestamp_in_millis";
    private static final String DOCUMENTS_BEHIND_FIELD = "documents_behind";
    private final Instant lastTimestamp;
    private final Map<String, Long> documentsBehind;

    public ContinuousTransformStats(Instant lastTimestamp, Map<String, Long> documentsBehind) {
        this.lastTimestamp = lastTimestamp;
        this.documentsBehind = documentsBehind;
    }

    public ContinuousTransformStats(StreamInput sin) throws IOException {
        this(sin.readBoolean() ? sin.readInstant() : null, sin.readBoolean() ? sin.readMap(StreamInput::readString, StreamInput::readLong) : null);
    }

    public Instant getLastTimestamp() {
        return this.lastTimestamp;
    }

    public Map<String, Long> getDocumentsBehind() {
        return this.documentsBehind;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.lastTimestamp != null) {
            builder.timeField(LAST_TIMESTAMP_FIELD, LAST_TIMESTAMP_FIELD_IN_MILLIS, this.lastTimestamp.toEpochMilli());
        }
        if (this.documentsBehind != null) {
            builder.field(DOCUMENTS_BEHIND_FIELD, this.documentsBehind);
        }
        return builder.endObject();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.lastTimestamp != null);
        if (this.lastTimestamp != null) {
            out.writeInstant(this.lastTimestamp);
        }
        out.writeBoolean(this.documentsBehind != null);
        if (this.documentsBehind != null) {
            out.writeMap(this.documentsBehind, StreamOutput::writeString, StreamOutput::writeLong);
        }
    }

    public static ContinuousTransformStats parse(XContentParser xcp) throws IOException {
        Instant lastTimestamp = null;
        Map documentsBehind = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "last_timestamp": {
                    lastTimestamp = LuceniaExtensions.instant(xcp);
                    break;
                }
                case "documents_behind": {
                    documentsBehind = xcp.map(HashMap::new, XContentParser::longValue);
                }
            }
        }
        return new ContinuousTransformStats(lastTimestamp, documentsBehind);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContinuousTransformStats that = (ContinuousTransformStats)o;
        return Objects.equals(this.lastTimestamp, that.lastTimestamp) && Objects.equals(this.documentsBehind, that.documentsBehind);
    }

    public int hashCode() {
        return Objects.hash(this.lastTimestamp, this.documentsBehind);
    }

    public String toString() {
        return "ContinuousTransformStats{lastTimestamp=" + String.valueOf(this.lastTimestamp) + ", documentsBehind=" + String.valueOf(this.documentsBehind) + "}";
    }
}

