/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.transform.model;

import io.lucenia.indexmanagement.common.model.dimension.DateHistogram;
import io.lucenia.indexmanagement.common.model.dimension.Dimension;
import io.lucenia.indexmanagement.common.model.dimension.Histogram;
import io.lucenia.indexmanagement.common.model.dimension.Terms;
import io.lucenia.indexmanagement.transform.model.Transform;
import io.skylite.common.xcontent.XContentFactory;
import io.skylite.core.aggregations.AggregationBuilder;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.io.stream.NamedWriteable;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.index.query.MatchAllQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.jobs.schedule.Schedule;
import io.skylite.core.security.auth.User;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.jobs.schedule.IntervalSchedule;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.codec.digest.DigestUtils;

public class ISMTransform
implements ToXContentObject,
Writeable {
    private final String description;
    private final String targetIndex;
    private final int pageSize;
    private final QueryBuilder dataSelectionQuery;
    private final List<Dimension> groups;
    private final AggregatorFactories.Builder aggregations;

    public ISMTransform(String description, String targetIndex, int pageSize, QueryBuilder dataSelectionQuery, List<Dimension> groups, AggregatorFactories.Builder aggregations) {
        if (pageSize < 1 || pageSize > 10000) {
            throw new IllegalArgumentException("Page size must be between 1 and 10000");
        }
        if (description.isEmpty()) {
            throw new IllegalArgumentException("Description cannot be empty");
        }
        if (targetIndex.isEmpty()) {
            throw new IllegalArgumentException("TargetIndex cannot be empty");
        }
        if (groups.isEmpty()) {
            throw new IllegalArgumentException("Groups cannot be empty");
        }
        for (Object factory : aggregations.getAggregatorFactories()) {
            String type;
            if (!(factory instanceof AggregationBuilder) || Transform.supportedAggregations.contains(type = ((AggregationBuilder)factory).getType())) continue;
            throw new IllegalArgumentException("Unsupported aggregation [" + type + "]");
        }
        this.description = description;
        this.targetIndex = targetIndex;
        this.pageSize = pageSize;
        this.dataSelectionQuery = dataSelectionQuery != null ? dataSelectionQuery : new MatchAllQueryBuilder();
        this.groups = groups;
        this.aggregations = aggregations;
    }

    public ISMTransform(String description, String targetIndex, int pageSize, List<Dimension> groups) {
        this(description, targetIndex, pageSize, (QueryBuilder)new MatchAllQueryBuilder(), groups, AggregatorFactories.builder());
    }

    public ISMTransform(StreamInput sin) throws IOException {
        this(sin.readString(), sin.readString(), sin.readInt(), (QueryBuilder)sin.readOptionalNamedWriteable(QueryBuilder.class), ISMTransform.readDimensions(sin), (AggregatorFactories.Builder)sin.readOptionalWriteable(AggregatorFactories.Builder::new));
        if (this.dataSelectionQuery == null) {
            throw new IllegalArgumentException("Query cannot be null");
        }
        if (this.aggregations == null) {
            throw new IllegalArgumentException("Aggregations cannot be null");
        }
    }

    private static List<Dimension> readDimensions(StreamInput sin) throws IOException {
        ArrayList<Dimension> dimensionList = new ArrayList<Dimension>();
        int size = sin.readVInt();
        block5: for (int i = 0; i < size; ++i) {
            Dimension.Type type = (Dimension.Type)sin.readEnum(Dimension.Type.class);
            if (type == null) {
                throw new IllegalArgumentException("Dimension type cannot be null");
            }
            switch (type) {
                case DATE_HISTOGRAM: {
                    dimensionList.add(new DateHistogram(sin));
                    continue block5;
                }
                case TERMS: {
                    dimensionList.add(new Terms(sin));
                    continue block5;
                }
                case HISTOGRAM: {
                    dimensionList.add(new Histogram(sin));
                }
            }
        }
        return dimensionList;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTargetIndex() {
        return this.targetIndex;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public QueryBuilder getDataSelectionQuery() {
        return this.dataSelectionQuery;
    }

    public List<Dimension> getGroups() {
        return this.groups;
    }

    public AggregatorFactories.Builder getAggregations() {
        return this.aggregations;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("description", this.description);
        builder.field("target_index", this.targetIndex);
        builder.field("page_size", this.pageSize);
        builder.field("data_selection_query", (ToXContent)this.dataSelectionQuery);
        builder.field("groups", this.groups);
        builder.field("aggregations", (ToXContent)this.aggregations);
        builder.endObject();
        return builder;
    }

    public Transform toTransform(String sourceIndex, User user) {
        String id = sourceIndex + this.toString();
        Instant currentTime = Instant.now();
        return new Transform(DigestUtils.sha1Hex((String)id), -2L, 0L, 1L, (Schedule)new IntervalSchedule(Instant.now(), 1, ChronoUnit.MINUTES), null, currentTime, true, currentTime, this.description, sourceIndex, this.dataSelectionQuery, this.targetIndex, this.pageSize, this.groups, this.aggregations, false, user);
    }

    public Transform toTransform(String sourceIndex) {
        return this.toTransform(sourceIndex, null);
    }

    public String toString() {
        StringBuilder sbd = new StringBuilder();
        sbd.append(this.targetIndex);
        sbd.append(this.pageSize);
        sbd.append(this.dataSelectionQuery);
        for (Dimension dimension : this.groups) {
            sbd.append((Object)dimension.getType());
            sbd.append(dimension.getSourceField());
        }
        sbd.append(this.aggregations);
        return sbd.toString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.description);
        out.writeString(this.targetIndex);
        out.writeInt(this.pageSize);
        out.writeOptionalNamedWriteable((NamedWriteable)this.dataSelectionQuery);
        out.writeVInt(this.groups.size());
        for (Dimension group : this.groups) {
            out.writeEnum((Enum)group.getType());
            switch (group.getType()) {
                case DATE_HISTOGRAM: {
                    ((DateHistogram)group).writeTo(out);
                    break;
                }
                case TERMS: {
                    ((Terms)group).writeTo(out);
                    break;
                }
                case HISTOGRAM: {
                    ((Histogram)group).writeTo(out);
                }
            }
        }
        out.writeOptionalWriteable((Writeable)this.aggregations);
    }

    public static ISMTransform parse(XContentParser xcp) throws IOException {
        String description = "";
        String targetIndex = "";
        int pageSize = 0;
        MatchAllQueryBuilder dataSelectionQuery = new MatchAllQueryBuilder();
        ArrayList<Dimension> groups = new ArrayList<Dimension>();
        AggregatorFactories.Builder aggregations = AggregatorFactories.builder();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block16: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "description": {
                    description = xcp.text();
                    continue block16;
                }
                case "target_index": {
                    targetIndex = xcp.text();
                    continue block16;
                }
                case "page_size": {
                    pageSize = xcp.intValue();
                    continue block16;
                }
                case "data_selection_query": {
                    NamedXContentRegistry registry = xcp.getXContentRegistry();
                    Map source = xcp.mapOrdered();
                    XContentBuilder xContentBuilder = XContentFactory.jsonBuilder().map(source);
                    XContentParser sourceParser = MediaTypeRegistry.JSON.xContent().createParser(registry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)BytesReference.bytes((XContentBuilder)xContentBuilder).streamInput());
                    dataSelectionQuery = QueryBuilder.parseInnerQueryBuilder((XContentParser)sourceParser);
                    continue block16;
                }
                case "groups": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        groups.add(Dimension.parse(xcp));
                    }
                    continue block16;
                }
                case "aggregations": {
                    aggregations = AggregatorFactories.parseAggregators((XContentParser)xcp);
                    continue block16;
                }
            }
            throw new IllegalArgumentException("Invalid field [" + fieldName + "] found in ISM Transform.");
        }
        return new ISMTransform(description, targetIndex, pageSize, (QueryBuilder)dataSelectionQuery, groups, aggregations);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ISMTransform that = (ISMTransform)o;
        return this.pageSize == that.pageSize && Objects.equals(this.description, that.description) && Objects.equals(this.targetIndex, that.targetIndex) && Objects.equals(this.dataSelectionQuery, that.dataSelectionQuery) && Objects.equals(this.groups, that.groups) && Objects.equals(this.aggregations, that.aggregations);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.targetIndex, this.pageSize, this.dataSelectionQuery, this.groups, this.aggregations);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private String description;
        private String targetIndex;
        private int pageSize;
        private QueryBuilder dataSelectionQuery;
        private List<Dimension> groups;
        private AggregatorFactories.Builder aggregations;

        public Builder(ISMTransform ismTransform) {
            this.description = ismTransform.description;
            this.targetIndex = ismTransform.targetIndex;
            this.pageSize = ismTransform.pageSize;
            this.dataSelectionQuery = ismTransform.dataSelectionQuery;
            this.groups = ismTransform.groups;
            this.aggregations = ismTransform.aggregations;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder targetIndex(String targetIndex) {
            this.targetIndex = targetIndex;
            return this;
        }

        public Builder pageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder dataSelectionQuery(QueryBuilder dataSelectionQuery) {
            this.dataSelectionQuery = dataSelectionQuery;
            return this;
        }

        public Builder groups(List<Dimension> groups) {
            this.groups = groups;
            return this;
        }

        public Builder aggregations(AggregatorFactories.Builder aggregations) {
            this.aggregations = aggregations;
            return this;
        }

        public ISMTransform build() {
            return new ISMTransform(this.description, this.targetIndex, this.pageSize, this.dataSelectionQuery, this.groups, this.aggregations);
        }
    }
}

