/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.transform.model;

import io.lucenia.indexmanagement.common.model.dimension.DateHistogram;
import io.lucenia.indexmanagement.common.model.dimension.Dimension;
import io.lucenia.indexmanagement.common.model.dimension.Histogram;
import io.lucenia.indexmanagement.common.model.dimension.Terms;
import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.lucenia.indexmanagement.transform.TransformSearchService;
import io.lucenia.indexmanagement.transform.model.ContinuousTransformStats;
import io.lucenia.indexmanagement.transform.model.TransformMetadata;
import io.skylite.common.xcontent.XContentFactory;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.indices.stats.IndicesStatsAction;
import io.skylite.core.action.admin.indices.stats.IndicesStatsRequest;
import io.skylite.core.action.admin.indices.stats.IndicesStatsResponse;
import io.skylite.core.aggregations.AggregationBuilder;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.PipelineAggregationBuilder;
import io.skylite.core.client.Client;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.io.stream.NamedWriteable;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.index.query.MatchAllQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.jobs.ScheduledJobParameter;
import io.skylite.core.jobs.schedule.Schedule;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.security.auth.User;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.jobs.schedule.CronSchedule;
import io.skylite.jobs.schedule.IntervalSchedule;
import io.skylite.jobs.schedule.ScheduleParser;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Transform
implements ScheduledJobParameter,
Writeable {
    public static final List<String> supportedAggregations = Arrays.asList("sum", "max", "min", "value_count", "avg", "scripted_metric", "percentiles");
    public static final long LOCK_DURATION_SECONDS = 1800L;
    public static final String TRANSFORM_TYPE = "transform";
    public static final String TRANSFORM_ID_FIELD = "transform_id";
    public static final String ENABLED_FIELD = "enabled";
    public static final String UPDATED_AT_FIELD = "updated_at";
    public static final String ENABLED_AT_FIELD = "enabled_at";
    public static final String SOURCE_INDEX_FIELD = "source_index";
    public static final String TARGET_INDEX_FIELD = "target_index";
    public static final String DESCRIPTION_FIELD = "description";
    public static final String DATA_SELECTION_QUERY_FIELD = "data_selection_query";
    public static final String METADATA_ID_FIELD = "metadata_id";
    public static final String PAGE_SIZE_FIELD = "page_size";
    public static final String ROLES_FIELD = "roles";
    public static final String JOB_SCHEDULE_FIELD = "schedule";
    public static final String GROUPS_FIELD = "groups";
    public static final String AGGREGATIONS_FIELD = "aggregations";
    public static final String SCHEMA_VERSION_FIELD = "schema_version";
    public static final int MINIMUM_PAGE_SIZE = 1;
    public static final int MAXIMUM_PAGE_SIZE = 10000;
    public static final int MAXIMUM_PAGE_SIZE_CONTINUOUS = 1000;
    public static final int MINIMUM_JOB_INTERVAL = 1;
    public static final String TRANSFORM_DOC_ID_FIELD = "transform._id";
    public static final String DOC_COUNT = "_doc_count";
    public static final String TRANSFORM_DOC_COUNT_FIELD = "transform._doc_count";
    public static final String CONTINUOUS_FIELD = "continuous";
    public static final String USER_FIELD = "user";
    private final String id;
    private final long seqNo;
    private final long primaryTerm;
    private final long schemaVersion;
    private final Schedule jobSchedule;
    private final String metadataId;
    private final Instant updatedAt;
    private final boolean enabled;
    private final Instant enabledAt;
    private final String description;
    private final String sourceIndex;
    private final QueryBuilder dataSelectionQuery;
    private final String targetIndex;
    @Deprecated
    private final List<String> roles;
    private final int pageSize;
    private final List<Dimension> groups;
    private final AggregatorFactories.Builder aggregations;
    private final boolean continuous;
    private final User user;

    public Transform(String id, long seqNo, long primaryTerm, long schemaVersion, Schedule jobSchedule, String metadataId, Instant updatedAt, boolean enabled, Instant enabledAt, String description, String sourceIndex, QueryBuilder dataSelectionQuery, String targetIndex, int pageSize, List<Dimension> groups, AggregatorFactories.Builder aggregations, boolean continuous, User user) {
        String type;
        for (Object factory : aggregations.getAggregatorFactories()) {
            if (!(factory instanceof AggregationBuilder) || supportedAggregations.contains(type = ((AggregationBuilder)factory).getType())) continue;
            throw new IllegalArgumentException("Unsupported aggregation [" + type + "]");
        }
        for (Object factory : aggregations.getPipelineAggregatorFactories()) {
            if (!(factory instanceof PipelineAggregationBuilder) || supportedAggregations.contains(type = ((PipelineAggregationBuilder)factory).getType())) continue;
            throw new IllegalArgumentException("Unsupported aggregation [" + type + "]");
        }
        if (!(jobSchedule instanceof CronSchedule) && jobSchedule instanceof IntervalSchedule && ((IntervalSchedule)jobSchedule).getInterval() < 1) {
            throw new IllegalArgumentException("Transform job schedule interval must be greater than 0");
        }
        if (groups.isEmpty()) {
            throw new IllegalArgumentException("Groupings are Empty");
        }
        if (sourceIndex.equals(targetIndex)) {
            throw new IllegalArgumentException("Source and target indices cannot be the same");
        }
        if (continuous) {
            if (pageSize < 1 || pageSize > 1000) {
                throw new IllegalArgumentException("Page size must be between 1 and 1,000");
            }
        } else if (pageSize < 1 || pageSize > 10000) {
            throw new IllegalArgumentException("Page size must be between 1 and 10,000");
        }
        this.id = id;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
        this.schemaVersion = schemaVersion;
        this.jobSchedule = jobSchedule;
        this.metadataId = metadataId;
        this.updatedAt = updatedAt;
        this.enabled = enabled;
        this.enabledAt = enabledAt;
        this.description = description;
        this.sourceIndex = sourceIndex;
        this.dataSelectionQuery = dataSelectionQuery != null ? dataSelectionQuery : new MatchAllQueryBuilder();
        this.targetIndex = targetIndex;
        this.roles = Collections.emptyList();
        this.pageSize = pageSize;
        this.groups = groups;
        this.aggregations = aggregations;
        this.continuous = continuous;
        this.user = user;
    }

    public Transform(StreamInput sin) throws IOException {
        String id = sin.readString();
        long seqNo = sin.readLong();
        long primaryTerm = sin.readLong();
        long schemaVersion = sin.readLong();
        Schedule jobSchedule = Transform.readSchedule(sin);
        String metadataId = sin.readOptionalString();
        Instant updatedAt = sin.readInstant();
        boolean enabled = sin.readBoolean();
        Instant enabledAt = sin.readOptionalInstant();
        String description = sin.readString();
        String sourceIndex = sin.readString();
        QueryBuilder dataSelectionQuery = (QueryBuilder)sin.readOptionalNamedWriteable(QueryBuilder.class);
        String targetIndex = sin.readString();
        sin.readStringArray();
        int pageSize = sin.readInt();
        List<Dimension> groups = Transform.readDimensions(sin);
        AggregatorFactories.Builder aggregations = (AggregatorFactories.Builder)sin.readOptionalWriteable(AggregatorFactories.Builder::new);
        boolean continuous = sin.readBoolean();
        User user = sin.readBoolean() ? new User(sin) : null;
        this.id = id;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
        this.schemaVersion = schemaVersion;
        this.jobSchedule = jobSchedule;
        this.metadataId = metadataId;
        this.updatedAt = updatedAt;
        this.enabled = enabled;
        this.enabledAt = enabledAt;
        this.description = description;
        this.sourceIndex = sourceIndex;
        this.dataSelectionQuery = dataSelectionQuery != null ? dataSelectionQuery : new MatchAllQueryBuilder();
        this.targetIndex = targetIndex;
        this.roles = Collections.emptyList();
        this.pageSize = pageSize;
        this.groups = groups;
        this.aggregations = aggregations;
        this.continuous = continuous;
        this.user = user;
    }

    private static Schedule readSchedule(StreamInput sin) throws IOException {
        ScheduleType scheduleType = (ScheduleType)sin.readEnum(ScheduleType.class);
        if (scheduleType == null) {
            throw new IllegalArgumentException("ScheduleType cannot be null");
        }
        switch (scheduleType.ordinal()) {
            case 0: {
                return new CronSchedule(sin);
            }
            case 1: {
                return new IntervalSchedule(sin);
            }
        }
        throw new IllegalArgumentException("Unknown ScheduleType: " + String.valueOf((Object)scheduleType));
    }

    private static List<Dimension> readDimensions(StreamInput sin) throws IOException {
        ArrayList<Dimension> dimensionList = new ArrayList<Dimension>();
        int size = sin.readVInt();
        block5: for (int i = 0; i < size; ++i) {
            Dimension.Type type = (Dimension.Type)sin.readEnum(Dimension.Type.class);
            if (type == null) {
                throw new IllegalArgumentException("Dimension type cannot be null");
            }
            switch (type) {
                case DATE_HISTOGRAM: {
                    dimensionList.add(new DateHistogram(sin));
                    continue block5;
                }
                case TERMS: {
                    dimensionList.add(new Terms(sin));
                    continue block5;
                }
                case HISTOGRAM: {
                    dimensionList.add(new Histogram(sin));
                }
            }
        }
        return dimensionList;
    }

    public String getId() {
        return this.id;
    }

    public long getSeqNo() {
        return this.seqNo;
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public long getSchemaVersion() {
        return this.schemaVersion;
    }

    public Schedule getJobSchedule() {
        return this.jobSchedule;
    }

    public String getMetadataId() {
        return this.metadataId;
    }

    public Instant getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Instant getEnabledAt() {
        return this.enabledAt;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSourceIndex() {
        return this.sourceIndex;
    }

    public QueryBuilder getDataSelectionQuery() {
        return this.dataSelectionQuery;
    }

    public String getTargetIndex() {
        return this.targetIndex;
    }

    @Deprecated
    public List<String> getRoles() {
        return this.roles;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public List<Dimension> getGroups() {
        return this.groups;
    }

    public AggregatorFactories.Builder getAggregations() {
        return this.aggregations;
    }

    public boolean isContinuous() {
        return this.continuous;
    }

    public User getUser() {
        return this.user;
    }

    public String getName() {
        return this.id;
    }

    public Schedule getSchedule() {
        return this.jobSchedule;
    }

    public Instant getLastUpdateTime() {
        return this.updatedAt;
    }

    public Instant getEnabledTime() {
        return this.enabledAt;
    }

    public Long getLockDurationSeconds() {
        return 1800L;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (params.paramAsBoolean("with_type", true)) {
            builder.startObject(TRANSFORM_TYPE);
        }
        builder.field(TRANSFORM_ID_FIELD, this.id);
        builder.field(SCHEMA_VERSION_FIELD, this.schemaVersion);
        builder.field(JOB_SCHEDULE_FIELD, (ToXContent)this.jobSchedule);
        builder.field(METADATA_ID_FIELD, this.metadataId);
        LuceniaExtensions.optionalTimeField(builder, UPDATED_AT_FIELD, this.updatedAt);
        builder.field(ENABLED_FIELD, this.enabled);
        LuceniaExtensions.optionalTimeField(builder, ENABLED_AT_FIELD, this.enabledAt);
        builder.field(DESCRIPTION_FIELD, this.description);
        builder.field(SOURCE_INDEX_FIELD, this.sourceIndex);
        builder.field(DATA_SELECTION_QUERY_FIELD, (ToXContent)this.dataSelectionQuery);
        builder.field(TARGET_INDEX_FIELD, this.targetIndex);
        builder.field(PAGE_SIZE_FIELD, this.pageSize);
        builder.field(GROUPS_FIELD, (Object)this.groups.toArray(new Dimension[0]));
        builder.field(AGGREGATIONS_FIELD, (ToXContent)this.aggregations);
        builder.field(CONTINUOUS_FIELD, this.continuous);
        if (params.paramAsBoolean("with_user", true)) {
            LuceniaExtensions.optionalUserField(builder, USER_FIELD, this.user);
        }
        if (params.paramAsBoolean("with_type", true)) {
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeLong(this.seqNo);
        out.writeLong(this.primaryTerm);
        out.writeLong(this.schemaVersion);
        if (this.jobSchedule instanceof CronSchedule) {
            out.writeEnum((Enum)ScheduleType.CRON);
        } else {
            out.writeEnum((Enum)ScheduleType.INTERVAL);
        }
        this.jobSchedule.writeTo(out);
        out.writeOptionalString(this.metadataId);
        out.writeInstant(this.updatedAt);
        out.writeBoolean(this.enabled);
        out.writeOptionalInstant(this.enabledAt);
        out.writeString(this.description);
        out.writeString(this.sourceIndex);
        out.writeOptionalNamedWriteable((NamedWriteable)this.dataSelectionQuery);
        out.writeString(this.targetIndex);
        out.writeStringArray(new String[0]);
        out.writeInt(this.pageSize);
        out.writeVInt(this.groups.size());
        for (Dimension group : this.groups) {
            out.writeEnum((Enum)group.getType());
            switch (group.getType()) {
                case DATE_HISTOGRAM: {
                    ((DateHistogram)group).writeTo(out);
                    break;
                }
                case TERMS: {
                    ((Terms)group).writeTo(out);
                    break;
                }
                case HISTOGRAM: {
                    ((Histogram)group).writeTo(out);
                }
            }
        }
        out.writeOptionalWriteable((Writeable)this.aggregations);
        out.writeBoolean(this.continuous);
        out.writeBoolean(this.user != null);
        if (this.user != null) {
            this.user.writeTo(out);
        }
    }

    public Map<String, Object> convertToDoc(long docCount, boolean includeId) {
        HashMap<String, Object> doc = new HashMap<String, Object>();
        if (includeId) {
            doc.put(TRANSFORM_DOC_ID_FIELD, this.id);
        }
        doc.put(DOC_COUNT, docCount);
        doc.put(TRANSFORM_DOC_COUNT_FIELD, docCount);
        return doc;
    }

    public Map<String, Object> convertToDoc(long docCount) {
        return this.convertToDoc(docCount, true);
    }

    public ContinuousTransformStats getContinuousStats(Client client, TransformMetadata metadata) {
        IndicesStatsRequest indicesStatsRequest = ((IndicesStatsRequest)new IndicesStatsRequest().indices(new String[]{this.sourceIndex})).clear();
        IndicesStatsResponse response = (IndicesStatsResponse)LuceniaExtensions.suspendUntil(client, (c, actionListener) -> c.execute((ActionType)IndicesStatsAction.INSTANCE, (ActionRequest)indicesStatsRequest, actionListener)).join();
        if (response.getStatus() != RestStatus.OK) {
            return null;
        }
        Map<ShardId, Long> shardIDsToGlobalCheckpoint = TransformSearchService.convertIndicesStatsResponse(response);
        return new ContinuousTransformStats(metadata.getContinuousStats() != null ? metadata.getContinuousStats().getLastTimestamp() : null, this.getDocumentsBehind(metadata.getShardIDToGlobalCheckpoint(), shardIDsToGlobalCheckpoint));
    }

    private Map<String, Long> getDocumentsBehind(Map<ShardId, Long> oldShardIDsToGlobalCheckpoint, Map<ShardId, Long> newShardIDsToGlobalCheckpoint) {
        HashMap<String, Long> documentsBehind = new HashMap<String, Long>();
        if (newShardIDsToGlobalCheckpoint == null) {
            return documentsBehind;
        }
        for (Map.Entry<ShardId, Long> entry : newShardIDsToGlobalCheckpoint.entrySet()) {
            ShardId shardID = entry.getKey();
            long globalCheckpoint = entry.getValue();
            String indexName = shardID.getIndexName();
            long newGlobalCheckpoint = Math.max(0L, globalCheckpoint);
            long oldGlobalCheckpoint = Math.max(0L, oldShardIDsToGlobalCheckpoint != null && oldShardIDsToGlobalCheckpoint.containsKey(shardID) ? oldShardIDsToGlobalCheckpoint.get(shardID) : 0L);
            long localDocsBehind = newGlobalCheckpoint - oldGlobalCheckpoint;
            documentsBehind.put(indexName, documentsBehind.getOrDefault(indexName, 0L) + localDocsBehind);
        }
        return documentsBehind;
    }

    public static Transform parse(XContentParser xcp, String id, long seqNo, long primaryTerm) throws IOException {
        Schedule schedule = null;
        long schemaVersion = 1L;
        Instant updatedAt = null;
        Instant enabledAt = null;
        boolean enabled = true;
        String description = null;
        String sourceIndex = null;
        MatchAllQueryBuilder dataSelectionQuery = new MatchAllQueryBuilder();
        String targetIndex = null;
        String metadataId = null;
        Integer pageSize = null;
        ArrayList<Dimension> groups = new ArrayList<Dimension>();
        AggregatorFactories.Builder aggregations = AggregatorFactories.builder();
        boolean continuous = false;
        User user = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block38: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "transform_id": {
                    if (xcp.text() != null) continue block38;
                    throw new IllegalArgumentException("The transform_id field is null");
                }
                case "schedule": {
                    schedule = ScheduleParser.parse((XContentParser)xcp);
                    continue block38;
                }
                case "schema_version": {
                    schemaVersion = xcp.longValue();
                    continue block38;
                }
                case "updated_at": {
                    updatedAt = LuceniaExtensions.instant(xcp);
                    continue block38;
                }
                case "enabled_at": {
                    enabledAt = LuceniaExtensions.instant(xcp);
                    continue block38;
                }
                case "enabled": {
                    enabled = xcp.booleanValue();
                    continue block38;
                }
                case "description": {
                    description = xcp.text();
                    continue block38;
                }
                case "source_index": {
                    sourceIndex = xcp.text();
                    continue block38;
                }
                case "data_selection_query": {
                    NamedXContentRegistry registry = xcp.getXContentRegistry();
                    Map source = xcp.mapOrdered();
                    XContentBuilder xContentBuilder = XContentFactory.jsonBuilder().map(source);
                    XContentParser sourceParser = MediaTypeRegistry.JSON.xContent().createParser(registry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)BytesReference.bytes((XContentBuilder)xContentBuilder).streamInput());
                    dataSelectionQuery = QueryBuilder.parseInnerQueryBuilder((XContentParser)sourceParser);
                    continue block38;
                }
                case "target_index": {
                    targetIndex = xcp.text();
                    continue block38;
                }
                case "metadata_id": {
                    metadataId = xcp.textOrNull();
                    continue block38;
                }
                case "roles": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        xcp.text();
                    }
                    continue block38;
                }
                case "page_size": {
                    pageSize = xcp.intValue();
                    continue block38;
                }
                case "groups": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        groups.add(Dimension.parse(xcp));
                    }
                    continue block38;
                }
                case "aggregations": {
                    AggregatorFactories.Builder parsed = AggregatorFactories.parseAggregators((XContentParser)xcp);
                    if (parsed == null) continue block38;
                    aggregations = parsed;
                    continue block38;
                }
                case "continuous": {
                    continuous = xcp.booleanValue();
                    continue block38;
                }
                case "user": {
                    user = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : User.parse((XContentParser)xcp);
                    continue block38;
                }
            }
            throw new IllegalArgumentException("Invalid field [" + fieldName + "] found in Transforms.");
        }
        if (enabled && enabledAt == null) {
            enabledAt = Instant.now();
        } else if (!enabled) {
            enabledAt = null;
        }
        if (seqNo == -2L || primaryTerm == 0L) {
            if (schedule instanceof IntervalSchedule) {
                IntervalSchedule intervalSchedule = (IntervalSchedule)schedule;
                schedule = new IntervalSchedule(intervalSchedule.getStartTime() != null ? intervalSchedule.getStartTime() : Instant.now(), intervalSchedule.getInterval(), intervalSchedule.getUnit());
            }
            metadataId = null;
        }
        if (schedule == null) {
            throw new IllegalArgumentException("Transform schedule is null");
        }
        if (description == null) {
            throw new IllegalArgumentException("Transform description is null");
        }
        if (sourceIndex == null) {
            throw new IllegalArgumentException("Transform source index is null");
        }
        if (targetIndex == null) {
            throw new IllegalArgumentException("Transform target index is null");
        }
        if (pageSize == null) {
            throw new IllegalArgumentException("Transform page size is null");
        }
        return new Transform(id, seqNo, primaryTerm, schemaVersion, schedule, metadataId, updatedAt != null ? updatedAt : Instant.now(), enabled, enabledAt, description, sourceIndex, (QueryBuilder)dataSelectionQuery, targetIndex, pageSize, groups, aggregations, continuous, user);
    }

    public static Transform parse(XContentParser xcp, String id) throws IOException {
        return Transform.parse(xcp, id, -2L, 0L);
    }

    public static Transform parse(XContentParser xcp) throws IOException {
        return Transform.parse(xcp, "", -2L, 0L);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transform transform = (Transform)o;
        return this.seqNo == transform.seqNo && this.primaryTerm == transform.primaryTerm && this.schemaVersion == transform.schemaVersion && this.enabled == transform.enabled && this.pageSize == transform.pageSize && this.continuous == transform.continuous && Objects.equals(this.id, transform.id) && Objects.equals(this.jobSchedule, transform.jobSchedule) && Objects.equals(this.metadataId, transform.metadataId) && Objects.equals(this.updatedAt, transform.updatedAt) && Objects.equals(this.enabledAt, transform.enabledAt) && Objects.equals(this.description, transform.description) && Objects.equals(this.sourceIndex, transform.sourceIndex) && Objects.equals(this.dataSelectionQuery, transform.dataSelectionQuery) && Objects.equals(this.targetIndex, transform.targetIndex) && Objects.equals(this.groups, transform.groups) && Objects.equals(this.aggregations, transform.aggregations) && Objects.equals(this.user, transform.user);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.seqNo, this.primaryTerm, this.schemaVersion, this.jobSchedule, this.metadataId, this.updatedAt, this.enabled, this.enabledAt, this.description, this.sourceIndex, this.dataSelectionQuery, this.targetIndex, this.pageSize, this.groups, this.aggregations, this.continuous, this.user);
    }

    public String toString() {
        return "Transform{id='" + this.id + "', seqNo=" + this.seqNo + ", primaryTerm=" + this.primaryTerm + ", schemaVersion=" + this.schemaVersion + ", jobSchedule=" + String.valueOf(this.jobSchedule) + ", metadataId='" + this.metadataId + "', updatedAt=" + String.valueOf(this.updatedAt) + ", enabled=" + this.enabled + ", enabledAt=" + String.valueOf(this.enabledAt) + ", description='" + this.description + "', sourceIndex='" + this.sourceIndex + "', dataSelectionQuery=" + String.valueOf(this.dataSelectionQuery) + ", targetIndex='" + this.targetIndex + "', pageSize=" + this.pageSize + ", groups=" + String.valueOf(this.groups) + ", aggregations=" + String.valueOf(this.aggregations) + ", continuous=" + this.continuous + ", user=" + String.valueOf(this.user) + "}";
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static enum ScheduleType {
        CRON,
        INTERVAL;

    }

    public static class Builder {
        private String id;
        private long seqNo;
        private long primaryTerm;
        private long schemaVersion;
        private Schedule jobSchedule;
        private String metadataId;
        private Instant updatedAt;
        private boolean enabled;
        private Instant enabledAt;
        private String description;
        private String sourceIndex;
        private QueryBuilder dataSelectionQuery;
        private String targetIndex;
        private int pageSize;
        private List<Dimension> groups;
        private List<String> roles;
        private AggregatorFactories.Builder aggregations;
        private boolean continuous;
        private User user;

        public Builder(Transform transform) {
            this.id = transform.id;
            this.seqNo = transform.seqNo;
            this.primaryTerm = transform.primaryTerm;
            this.schemaVersion = transform.schemaVersion;
            this.jobSchedule = transform.jobSchedule;
            this.metadataId = transform.metadataId;
            this.updatedAt = transform.updatedAt;
            this.enabled = transform.enabled;
            this.enabledAt = transform.enabledAt;
            this.description = transform.description;
            this.sourceIndex = transform.sourceIndex;
            this.dataSelectionQuery = transform.dataSelectionQuery;
            this.targetIndex = transform.targetIndex;
            this.pageSize = transform.pageSize;
            this.groups = transform.groups;
            this.aggregations = transform.aggregations;
            this.continuous = transform.continuous;
            this.user = transform.user;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder user(User user) {
            this.user = user;
            return this;
        }

        public Builder schemaVersion(long schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public Builder seqNo(long seqNo) {
            this.seqNo = seqNo;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder enabledAt(Instant instant) {
            this.enabledAt = instant;
            return this;
        }

        public Builder primaryTerm(long primaryTerm) {
            this.primaryTerm = primaryTerm;
            return this;
        }

        @Deprecated
        public Builder roles(List<String> roles) {
            this.roles = roles;
            return this;
        }

        public Builder metadataId(String metadataId) {
            this.metadataId = metadataId;
            return this;
        }

        public Builder sourceIndex(String sourceIndex) {
            this.sourceIndex = sourceIndex;
            return this;
        }

        public Builder targetIndex(String targetIndex) {
            this.targetIndex = targetIndex;
            return this;
        }

        public Builder groups(List<Dimension> groups) {
            this.groups = groups;
            return this;
        }

        public Builder pageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder aggregations(AggregatorFactories.Builder aggregations) {
            this.aggregations = aggregations;
            return this;
        }

        public Builder continuous(boolean continuous) {
            this.continuous = continuous;
            return this;
        }

        public Builder jobSchedule(Schedule jobSchedule) {
            this.jobSchedule = jobSchedule;
            return this;
        }

        public Transform build() {
            return new Transform(this.id, this.seqNo, this.primaryTerm, this.schemaVersion, this.jobSchedule, this.metadataId, this.updatedAt, this.enabled, this.enabledAt, this.description, this.sourceIndex, this.dataSelectionQuery, this.targetIndex, this.pageSize, this.groups, this.aggregations, this.continuous, this.user);
        }
    }
}

