/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.transform.model;

import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.lucenia.indexmanagement.transform.model.ContinuousTransformStats;
import io.lucenia.indexmanagement.transform.model.TransformStats;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class TransformMetadata
implements ToXContentObject,
Writeable {
    public static final String TRANSFORM_METADATA_TYPE = "transform_metadata";
    public static final String TRANSFORM_ID_FIELD = "transform_id";
    public static final String AFTER_KEY_FIELD = "after_key";
    public static final String LAST_UPDATED_AT_FIELD = "last_updated_at";
    public static final String STATUS_FIELD = "status";
    public static final String STATS_FIELD = "stats";
    public static final String SHARD_ID_TO_GLOBAL_CHECKPOINT_FIELD = "shard_id_to_global_checkpoint";
    public static final String CONTINUOUS_STATS_FIELD = "continuous_stats";
    public static final String FAILURE_REASON = "failure_reason";
    private final String id;
    private final long seqNo;
    private final long primaryTerm;
    private final String transformId;
    private final Map<String, Object> afterKey;
    private final Instant lastUpdatedAt;
    private final Status status;
    private final String failureReason;
    private final TransformStats stats;
    private final Map<ShardId, Long> shardIDToGlobalCheckpoint;
    private final ContinuousTransformStats continuousStats;

    public TransformMetadata(String id, long seqNo, long primaryTerm, String transformId, Map<String, Object> afterKey, Instant lastUpdatedAt, Status status, String failureReason, TransformStats stats, Map<ShardId, Long> shardIDToGlobalCheckpoint, ContinuousTransformStats continuousStats) {
        this.id = id;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
        this.transformId = transformId;
        this.afterKey = afterKey;
        this.lastUpdatedAt = lastUpdatedAt;
        this.status = status;
        this.failureReason = failureReason;
        this.stats = stats;
        this.shardIDToGlobalCheckpoint = shardIDToGlobalCheckpoint;
        this.continuousStats = continuousStats;
    }

    public TransformMetadata(StreamInput sin) throws IOException {
        this(sin.readString(), sin.readLong(), sin.readLong(), sin.readString(), sin.readBoolean() ? sin.readMap() : null, sin.readInstant(), (Status)sin.readEnum(Status.class), sin.readOptionalString(), new TransformStats(sin), sin.readBoolean() ? sin.readMap(ShardId::new, StreamInput::readLong) : null, sin.readBoolean() ? new ContinuousTransformStats(sin) : null);
    }

    private TransformMetadata(Builder b) {
        this.id = b.id;
        this.seqNo = b.seqNo;
        this.primaryTerm = b.primaryTerm;
        this.transformId = b.transformId;
        this.afterKey = b.afterKey;
        this.lastUpdatedAt = b.lastUpdatedAt;
        this.status = b.status;
        this.failureReason = b.failureReason;
        this.stats = b.stats;
        this.shardIDToGlobalCheckpoint = b.shardIDToGlobalCheckpoint;
        this.continuousStats = b.continuousStats;
    }

    public String getId() {
        return this.id;
    }

    public long getSeqNo() {
        return this.seqNo;
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public String getTransformId() {
        return this.transformId;
    }

    public Map<String, Object> getAfterKey() {
        return this.afterKey;
    }

    public Instant getLastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public TransformStats getStats() {
        return this.stats;
    }

    public Map<ShardId, Long> getShardIDToGlobalCheckpoint() {
        return this.shardIDToGlobalCheckpoint;
    }

    public ContinuousTransformStats getContinuousStats() {
        return this.continuousStats;
    }

    public Builder toBuilder() {
        return new Builder().id(this.id).seqNo(this.seqNo).primaryTerm(this.primaryTerm).transformId(this.transformId).afterKey(this.afterKey).lastUpdatedAt(this.lastUpdatedAt).status(this.status).failureReason(this.failureReason).stats(this.stats).shardIDToGlobalCheckpoint(this.shardIDToGlobalCheckpoint).continuousStats(this.continuousStats);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (params.paramAsBoolean("with_type", true)) {
            builder.startObject(TRANSFORM_METADATA_TYPE);
        }
        builder.field(TRANSFORM_ID_FIELD, this.transformId);
        if (this.afterKey != null) {
            builder.field(AFTER_KEY_FIELD, this.afterKey);
        }
        LuceniaExtensions.optionalTimeField(builder, LAST_UPDATED_AT_FIELD, this.lastUpdatedAt);
        builder.field(STATUS_FIELD, this.status.type);
        builder.field(FAILURE_REASON, this.failureReason);
        builder.field(STATS_FIELD, (ToXContent)this.stats);
        if (this.shardIDToGlobalCheckpoint != null) {
            HashMap<String, Long> shardIdStrings = new HashMap<String, Long>();
            for (Map.Entry<ShardId, Long> entry : this.shardIDToGlobalCheckpoint.entrySet()) {
                shardIdStrings.put(entry.getKey().toString(), entry.getValue());
            }
            builder.field(SHARD_ID_TO_GLOBAL_CHECKPOINT_FIELD, shardIdStrings);
        }
        if (this.continuousStats != null) {
            builder.field(CONTINUOUS_STATS_FIELD, (ToXContent)this.continuousStats);
        }
        if (params.paramAsBoolean("with_type", true)) {
            builder.endObject();
        }
        return builder.endObject();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeLong(this.seqNo);
        out.writeLong(this.primaryTerm);
        out.writeString(this.transformId);
        out.writeBoolean(this.afterKey != null);
        if (this.afterKey != null) {
            out.writeMap(this.afterKey);
        }
        out.writeInstant(this.lastUpdatedAt);
        out.writeEnum((Enum)this.status);
        out.writeOptionalString(this.failureReason);
        this.stats.writeTo(out);
        out.writeBoolean(this.shardIDToGlobalCheckpoint != null);
        if (this.shardIDToGlobalCheckpoint != null) {
            out.writeMap(this.shardIDToGlobalCheckpoint, (writer, k) -> k.writeTo(writer), StreamOutput::writeLong);
        }
        out.writeBoolean(this.continuousStats != null);
        if (this.continuousStats != null) {
            this.continuousStats.writeTo(out);
        }
    }

    public TransformMetadata mergeStats(TransformStats stats) {
        TransformStats mergedStats = new TransformStats(this.stats.getPagesProcessed() + stats.getPagesProcessed(), this.stats.getDocumentsProcessed() + stats.getDocumentsProcessed(), this.stats.getDocumentsIndexed() + stats.getDocumentsIndexed(), this.stats.getIndexTimeInMillis() + stats.getIndexTimeInMillis(), this.stats.getSearchTimeInMillis() + stats.getSearchTimeInMillis());
        return new TransformMetadata(this.id, this.seqNo, this.primaryTerm, this.transformId, this.afterKey, this.lastUpdatedAt, this.status, this.failureReason, mergedStats, this.shardIDToGlobalCheckpoint, this.continuousStats);
    }

    public static TransformMetadata parse(XContentParser xcp, String id, long seqNo, long primaryTerm) throws IOException {
        String transformId = null;
        Map afterKey = null;
        Instant lastUpdatedAt = null;
        Status status = null;
        String failureReason = null;
        TransformStats stats = null;
        HashMap<ShardId, Long> shardIDToGlobalCheckpoint = null;
        ContinuousTransformStats continuousStats = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block20: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "transform_id": {
                    transformId = xcp.text();
                    break;
                }
                case "after_key": {
                    afterKey = xcp.map();
                    break;
                }
                case "last_updated_at": {
                    lastUpdatedAt = LuceniaExtensions.instant(xcp);
                    break;
                }
                case "status": {
                    status = Status.valueOf(xcp.text().toUpperCase(Locale.ROOT));
                    break;
                }
                case "failure_reason": {
                    failureReason = xcp.textOrNull();
                    break;
                }
                case "stats": {
                    stats = TransformStats.parse(xcp);
                    break;
                }
                case "shard_id_to_global_checkpoint": {
                    Map tempMap = xcp.map(HashMap::new, XContentParser::longValue);
                    shardIDToGlobalCheckpoint = new HashMap<ShardId, Long>();
                    for (Map.Entry entry : tempMap.entrySet()) {
                        shardIDToGlobalCheckpoint.put(ShardId.fromString((String)((String)entry.getKey())), (Long)entry.getValue());
                    }
                    continue block20;
                }
                case "continuous_stats": {
                    continuousStats = ContinuousTransformStats.parse(xcp);
                }
            }
        }
        if (transformId == null) {
            throw new IllegalArgumentException("TransformId must not be null");
        }
        if (lastUpdatedAt == null) {
            throw new IllegalArgumentException("Last updated time must not be null");
        }
        if (status == null) {
            throw new IllegalArgumentException("Status must not be null");
        }
        if (stats == null) {
            throw new IllegalArgumentException("Stats must not be null");
        }
        return new TransformMetadata(id, seqNo, primaryTerm, transformId, afterKey, lastUpdatedAt, status, failureReason, stats, shardIDToGlobalCheckpoint, continuousStats);
    }

    public static TransformMetadata parse(XContentParser xcp, String id) throws IOException {
        return TransformMetadata.parse(xcp, id, -2L, 0L);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransformMetadata that = (TransformMetadata)o;
        return this.seqNo == that.seqNo && this.primaryTerm == that.primaryTerm && Objects.equals(this.id, that.id) && Objects.equals(this.transformId, that.transformId) && Objects.equals(this.afterKey, that.afterKey) && Objects.equals(this.lastUpdatedAt, that.lastUpdatedAt) && this.status == that.status && Objects.equals(this.failureReason, that.failureReason) && Objects.equals(this.stats, that.stats) && Objects.equals(this.shardIDToGlobalCheckpoint, that.shardIDToGlobalCheckpoint) && Objects.equals(this.continuousStats, that.continuousStats);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.seqNo, this.primaryTerm, this.transformId, this.afterKey, this.lastUpdatedAt, this.status, this.failureReason, this.stats, this.shardIDToGlobalCheckpoint, this.continuousStats});
    }

    public String toString() {
        return "TransformMetadata{id='" + this.id + "', seqNo=" + this.seqNo + ", primaryTerm=" + this.primaryTerm + ", transformId='" + this.transformId + "', afterKey=" + String.valueOf(this.afterKey) + ", lastUpdatedAt=" + String.valueOf(this.lastUpdatedAt) + ", status=" + String.valueOf((Object)this.status) + ", failureReason='" + this.failureReason + "', stats=" + String.valueOf(this.stats) + ", shardIDToGlobalCheckpoint=" + String.valueOf(this.shardIDToGlobalCheckpoint) + ", continuousStats=" + String.valueOf(this.continuousStats) + "}";
    }

    public static enum Status {
        INIT("init"),
        STARTED("started"),
        STOPPED("stopped"),
        FINISHED("finished"),
        FAILED("failed");

        private final String type;

        private Status(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public String toString() {
            return this.type;
        }
    }

    public static class Builder {
        private String id;
        private long seqNo;
        private long primaryTerm;
        private String transformId;
        private Map<String, Object> afterKey;
        private Instant lastUpdatedAt;
        private Status status;
        private String failureReason;
        private TransformStats stats;
        private Map<ShardId, Long> shardIDToGlobalCheckpoint;
        private ContinuousTransformStats continuousStats;

        public Builder() {
        }

        public Builder(TransformMetadata metadata) {
            this.id = metadata.id;
            this.seqNo = metadata.seqNo;
            this.primaryTerm = metadata.primaryTerm;
            this.transformId = metadata.transformId;
            this.afterKey = metadata.afterKey;
            this.lastUpdatedAt = metadata.lastUpdatedAt;
            this.status = metadata.status;
            this.failureReason = metadata.failureReason;
            this.stats = metadata.stats;
            this.shardIDToGlobalCheckpoint = metadata.shardIDToGlobalCheckpoint;
            this.continuousStats = metadata.continuousStats;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder seqNo(long seqNo) {
            this.seqNo = seqNo;
            return this;
        }

        public Builder primaryTerm(long primaryTerm) {
            this.primaryTerm = primaryTerm;
            return this;
        }

        public Builder transformId(String transformId) {
            this.transformId = transformId;
            return this;
        }

        public Builder afterKey(Map<String, Object> afterKey) {
            this.afterKey = afterKey;
            return this;
        }

        public Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            return this;
        }

        public Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public Builder stats(TransformStats stats) {
            this.stats = stats;
            return this;
        }

        public Builder shardIDToGlobalCheckpoint(Map<ShardId, Long> shardIDToGlobalCheckpoint) {
            this.shardIDToGlobalCheckpoint = shardIDToGlobalCheckpoint;
            return this;
        }

        public Builder continuousStats(ContinuousTransformStats continuousStats) {
            this.continuousStats = continuousStats;
            return this;
        }

        public TransformMetadata build() {
            return new TransformMetadata(this);
        }
    }
}

