/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.transform.model;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.Objects;

public class TransformStats
implements ToXContentObject,
Writeable {
    private static final String PAGES_PROCESSED_FIELD = "pages_processed";
    private static final String DOCUMENTS_PROCESSED_FIELD = "documents_processed";
    private static final String DOCUMENTS_INDEXED_FIELD = "documents_indexed";
    private static final String INDEX_TIME_IN_MILLIS_FIELD = "index_time_in_millis";
    private static final String SEARCH_TIME_IN_MILLIS_FIELD = "search_time_in_millis";
    private final long pagesProcessed;
    private final long documentsProcessed;
    private final long documentsIndexed;
    private final long indexTimeInMillis;
    private final long searchTimeInMillis;

    public TransformStats(long pagesProcessed, long documentsProcessed, long documentsIndexed, long indexTimeInMillis, long searchTimeInMillis) {
        this.pagesProcessed = pagesProcessed;
        this.documentsProcessed = documentsProcessed;
        this.documentsIndexed = documentsIndexed;
        this.indexTimeInMillis = indexTimeInMillis;
        this.searchTimeInMillis = searchTimeInMillis;
    }

    public TransformStats(StreamInput sin) throws IOException {
        this(sin.readLong(), sin.readLong(), sin.readLong(), sin.readLong(), sin.readLong());
    }

    private TransformStats(Builder b) {
        this.pagesProcessed = b.pagesProcessed;
        this.documentsProcessed = b.documentsProcessed;
        this.documentsIndexed = b.documentsIndexed;
        this.indexTimeInMillis = b.indexTimeInMillis;
        this.searchTimeInMillis = b.searchTimeInMillis;
    }

    public long getPagesProcessed() {
        return this.pagesProcessed;
    }

    public long getDocumentsProcessed() {
        return this.documentsProcessed;
    }

    public long getDocumentsIndexed() {
        return this.documentsIndexed;
    }

    public long getIndexTimeInMillis() {
        return this.indexTimeInMillis;
    }

    public long getSearchTimeInMillis() {
        return this.searchTimeInMillis;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field(PAGES_PROCESSED_FIELD, this.pagesProcessed).field(DOCUMENTS_PROCESSED_FIELD, this.documentsProcessed).field(DOCUMENTS_INDEXED_FIELD, this.documentsIndexed).field(INDEX_TIME_IN_MILLIS_FIELD, this.indexTimeInMillis).field(SEARCH_TIME_IN_MILLIS_FIELD, this.searchTimeInMillis).endObject();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.pagesProcessed);
        out.writeLong(this.documentsProcessed);
        out.writeLong(this.documentsIndexed);
        out.writeLong(this.indexTimeInMillis);
        out.writeLong(this.searchTimeInMillis);
    }

    public static TransformStats parse(XContentParser xcp) throws IOException {
        Long pagesProcessed = null;
        Long documentsProcessed = null;
        Long documentsIndexed = null;
        Long indexTimeInMillis = null;
        Long searchTimeInMillis = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "pages_processed": {
                    pagesProcessed = xcp.longValue();
                    break;
                }
                case "documents_processed": {
                    documentsProcessed = xcp.longValue();
                    break;
                }
                case "documents_indexed": {
                    documentsIndexed = xcp.longValue();
                    break;
                }
                case "index_time_in_millis": {
                    indexTimeInMillis = xcp.longValue();
                    break;
                }
                case "search_time_in_millis": {
                    searchTimeInMillis = xcp.longValue();
                }
            }
        }
        if (pagesProcessed == null) {
            throw new IllegalArgumentException("Pages processed must not be null");
        }
        if (documentsProcessed == null) {
            throw new IllegalArgumentException("Documents processed must not be null");
        }
        if (documentsIndexed == null) {
            throw new IllegalArgumentException("Documents indexed must not be null");
        }
        if (indexTimeInMillis == null) {
            throw new IllegalArgumentException("Index time in millis must not be null");
        }
        if (searchTimeInMillis == null) {
            throw new IllegalArgumentException("Search time in millis must not be null");
        }
        return new TransformStats(pagesProcessed, documentsProcessed, documentsIndexed, indexTimeInMillis, searchTimeInMillis);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransformStats that = (TransformStats)o;
        return this.pagesProcessed == that.pagesProcessed && this.documentsProcessed == that.documentsProcessed && this.documentsIndexed == that.documentsIndexed && this.indexTimeInMillis == that.indexTimeInMillis && this.searchTimeInMillis == that.searchTimeInMillis;
    }

    public int hashCode() {
        return Objects.hash(this.pagesProcessed, this.documentsProcessed, this.documentsIndexed, this.indexTimeInMillis, this.searchTimeInMillis);
    }

    public String toString() {
        return "TransformStats{pagesProcessed=" + this.pagesProcessed + ", documentsProcessed=" + this.documentsProcessed + ", documentsIndexed=" + this.documentsIndexed + ", indexTimeInMillis=" + this.indexTimeInMillis + ", searchTimeInMillis=" + this.searchTimeInMillis + "}";
    }

    public static class Builder {
        private long pagesProcessed;
        private long documentsProcessed;
        private long documentsIndexed;
        private long indexTimeInMillis;
        private long searchTimeInMillis;

        public Builder() {
        }

        public Builder(TransformStats stats) {
            this.pagesProcessed = stats.pagesProcessed;
            this.documentsProcessed = stats.documentsProcessed;
            this.documentsIndexed = stats.documentsIndexed;
            this.indexTimeInMillis = stats.indexTimeInMillis;
            this.searchTimeInMillis = stats.searchTimeInMillis;
        }

        public Builder pagesProcessed(long pagesProcessed) {
            this.pagesProcessed = pagesProcessed;
            return this;
        }

        public Builder documentsProcessed(long documentsProcessed) {
            this.documentsProcessed = documentsProcessed;
            return this;
        }

        public Builder documentsIndexed(long documentsIndexed) {
            this.documentsIndexed = documentsIndexed;
            return this;
        }

        public Builder indexTimeInMillis(long indexTimeInMillis) {
            this.indexTimeInMillis = indexTimeInMillis;
            return this;
        }

        public Builder searchTimeInMillis(long searchTimeInMillis) {
            this.searchTimeInMillis = searchTimeInMillis;
            return this;
        }

        public TransformStats build() {
            return new TransformStats(this);
        }
    }
}

