/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.transform.resthandler;

import io.lucenia.indexmanagement.transform.action.explain.ExplainTransformAction;
import io.lucenia.indexmanagement.transform.action.explain.ExplainTransformRequest;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.Strings;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import java.util.Arrays;
import java.util.List;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestExplainTransformAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_transform/{transformID}/_explain"));
    }

    public String getName() {
        return "opendistro_explain_transform_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        List<String> transformIDs = Arrays.asList(Strings.splitStringByCommaToArray((String)request.param("transformID")));
        if (transformIDs.isEmpty()) {
            throw new IllegalArgumentException("Missing transformID");
        }
        ExplainTransformRequest explainRequest = new ExplainTransformRequest(transformIDs);
        return channel -> client.execute((ActionType)ExplainTransformAction.INSTANCE, (ActionRequest)explainRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

