/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.transform.resthandler;

import io.lucenia.indexmanagement.transform.action.get.GetTransformAction;
import io.lucenia.indexmanagement.transform.action.get.GetTransformRequest;
import io.lucenia.indexmanagement.transform.action.get.GetTransformsAction;
import io.lucenia.indexmanagement.transform.action.get.GetTransformsRequest;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.search.fetch.subphase.FetchSourceContext;
import java.util.List;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestGetTransformAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_transform"), new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_transform/{transformID}"), new RestHandler.Route(RestRequest.Method.HEAD, "/_plugins/_transform/{transformID}"));
    }

    public String getName() {
        return "opendistro_get_transform_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        String transformID = request.param("transformID");
        String searchString = request.param("search", "");
        int from = request.paramAsInt("from", 0);
        int size = request.paramAsInt("size", 20);
        String sortField = request.param("sortField", "transform.transform_id.keyword");
        String sortDirection = request.param("sortDirection", "asc");
        return channel -> {
            if (transformID == null || transformID.isEmpty()) {
                GetTransformsRequest req = new GetTransformsRequest(searchString, from, size, sortField, sortDirection);
                client.execute((ActionType)GetTransformsAction.INSTANCE, (ActionRequest)req, (ActionListener)new RestToXContentListener(channel));
            } else {
                GetTransformRequest req = new GetTransformRequest(transformID, (FetchSourceContext)(request.method() == RestRequest.Method.HEAD ? FetchSourceContext.DO_NOT_FETCH_SOURCE : null), null);
                client.execute((ActionType)GetTransformAction.INSTANCE, (ActionRequest)req, (ActionListener)new RestToXContentListener(channel));
            }
        };
    }
}

