/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.transform.resthandler;

import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.lucenia.indexmanagement.transform.action.index.IndexTransformAction;
import io.lucenia.indexmanagement.transform.action.index.IndexTransformRequest;
import io.lucenia.indexmanagement.transform.action.index.IndexTransformResponse;
import io.lucenia.indexmanagement.transform.model.Transform;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.WriteRequest;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.xcontent.ToXContent;
import java.io.IOException;
import java.time.Instant;
import java.util.List;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.action.RestResponseListener;

public class RestIndexTransformAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.PUT, "/_plugins/_transform"), new RestHandler.Route(RestRequest.Method.PUT, "/_plugins/_transform/{transformID}"));
    }

    public String getName() {
        return "opendistro_index_transform_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String id = request.param("transformID", "");
        if ("".equals(id)) {
            throw new IllegalArgumentException("Missing transform ID");
        }
        long seqNo = request.paramAsLong("if_seq_no", -2L);
        long primaryTerm = request.paramAsLong("if_primary_term", 0L);
        Transform parsedTransform = LuceniaExtensions.parseWithType(request.contentParser(), id, seqNo, primaryTerm, Transform::parse);
        Transform transform = new Transform.Builder(parsedTransform).updatedAt(Instant.now()).build();
        WriteRequest.RefreshPolicy refreshPolicy = request.hasParam("refresh") ? WriteRequest.RefreshPolicy.parse((String)request.param("refresh")) : WriteRequest.RefreshPolicy.IMMEDIATE;
        IndexTransformRequest indexTransformRequest = new IndexTransformRequest(transform, refreshPolicy);
        return channel -> client.execute((ActionType)IndexTransformAction.INSTANCE, (ActionRequest)indexTransformRequest, this.indexTransformResponse((RestChannel)channel));
    }

    private RestResponseListener<IndexTransformResponse> indexTransformResponse(RestChannel channel) {
        return new RestResponseListener<IndexTransformResponse>(this, channel){

            public RestResponse buildResponse(IndexTransformResponse response) throws Exception {
                BytesRestResponse restResponse = new BytesRestResponse(response.getStatus(), response.toXContent(this.channel.newBuilder(), ToXContent.EMPTY_PARAMS));
                if (response.getStatus() == RestStatus.CREATED) {
                    String location = "/_plugins/_transform/" + response.getId();
                    restResponse.addHeader("Location", location);
                }
                return restResponse;
            }
        };
    }
}

