/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.transform.util;

import io.lucenia.indexmanagement.transform.util.TransformLockManager;
import java.util.Map;

public class TransformContext {
    private static final long LOCK_BUFFER_SECONDS = 60L;
    private final TransformLockManager transformLockManager;
    private Integer lastSuccessfulPageSize;
    private Map<String, Object> targetDateFieldMappings;

    public TransformContext(TransformLockManager transformLockManager) {
        this(transformLockManager, null);
    }

    public TransformContext(TransformLockManager transformLockManager, Integer lastSuccessfulPageSize) {
        this.transformLockManager = transformLockManager;
        this.lastSuccessfulPageSize = lastSuccessfulPageSize;
    }

    public TransformLockManager getTransformLockManager() {
        return this.transformLockManager;
    }

    public Integer getLastSuccessfulPageSize() {
        return this.lastSuccessfulPageSize;
    }

    public void setLastSuccessfulPageSize(Integer lastSuccessfulPageSize) {
        this.lastSuccessfulPageSize = lastSuccessfulPageSize;
    }

    public Long getMaxRequestTimeoutInSeconds() {
        Long lockExpiration = this.transformLockManager.lockExpirationInSeconds();
        if (lockExpiration == null) {
            return null;
        }
        long maxRequestTimeout = lockExpiration - 60L;
        if (maxRequestTimeout < 0L) {
            return null;
        }
        return maxRequestTimeout;
    }

    public Map<String, Object> getTargetIndexDateFieldMappings() {
        return this.targetDateFieldMappings;
    }

    public void setTargetDateFieldMappings(Map<String, Object> dateFieldMappings) {
        this.targetDateFieldMappings = dateFieldMappings;
    }

    public void renewLockForLongSearch(long timeSpentOnSearch) throws Exception {
        this.transformLockManager.renewLockForLongSearch(timeSpentOnSearch);
    }
}

