/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.transform.util;

import io.lucenia.indexmanagement.common.retry.RetryUtils;
import io.lucenia.indexmanagement.transform.model.Transform;
import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.bulk.BackoffPolicy;
import io.skylite.core.jobs.JobExecutionContext;
import io.skylite.core.jobs.LockModel;
import io.skylite.core.jobs.ScheduledJobParameter;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransformLockManager {
    private static final Logger logger = LogManager.getLogger(TransformLockManager.class);
    private static final long TIMEOUT_UPPER_BOUND_IN_SECONDS = 600L;
    private static final long MAXIMUM_LOCK_EXPIRATION_IN_SECONDS = 1200L;
    private final Transform transformJob;
    private final JobExecutionContext context;
    private final BackoffPolicy exponentialBackoffPolicy;
    protected LockModel lock;

    public TransformLockManager(Transform transformJob, JobExecutionContext context) {
        this.transformJob = transformJob;
        this.context = context;
        this.lock = null;
        this.exponentialBackoffPolicy = BackoffPolicy.exponentialBackoff((TimeValue)TimeValue.timeValueMillis((long)1000L), (int)3);
    }

    public LockModel getLock() {
        return this.lock;
    }

    public JobExecutionContext getContext() {
        return this.context;
    }

    public Long lockExpirationInSeconds() {
        if (this.lock == null) {
            return null;
        }
        return this.lock.getLockTime().getEpochSecond() + this.lock.getLockDurationSeconds() - Instant.now().getEpochSecond();
    }

    public void acquireLockForScheduledJob() {
        try {
            RetryUtils.retry(logger, this.exponentialBackoffPolicy, () -> {
                final CompletableFuture future = new CompletableFuture();
                this.context.getLockService().acquireLock((ScheduledJobParameter)this.transformJob, this.context, (ActionListener)new ActionListener<LockModel>(this){

                    public void onResponse(LockModel lockModel) {
                        future.complete(lockModel);
                    }

                    public void onFailure(Exception e) {
                        future.completeExceptionally(e);
                    }
                });
                try {
                    this.lock = (LockModel)future.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    throw new RuntimeException(e);
                }
                return null;
            });
        }
        catch (Exception e) {
            logger.error("Failed to acquireLock for job " + this.transformJob.getName(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockModel renewLockForScheduledJob() {
        LockModel updatedLock = null;
        try {
            RetryUtils.retry(logger, this.exponentialBackoffPolicy, () -> {
                final CompletableFuture future = new CompletableFuture();
                this.context.getLockService().renewLock(this.lock, (ActionListener)new ActionListener<LockModel>(this){

                    public void onResponse(LockModel lockModel) {
                        future.complete(lockModel);
                    }

                    public void onFailure(Exception e) {
                        future.completeExceptionally(e);
                    }
                });
                try {
                    LockModel renewed = (LockModel)future.get();
                    TransformLockManager transformLockManager = this;
                    synchronized (transformLockManager) {
                        this.lock = renewed;
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    throw new RuntimeException(e);
                }
                return null;
            });
            TransformLockManager transformLockManager = this;
            synchronized (transformLockManager) {
                updatedLock = this.lock;
            }
        }
        catch (Exception e) {
            logger.warn("Failed trying to renew lock on " + String.valueOf(this.lock) + ", releasing the existing lock", (Throwable)e);
        }
        if (updatedLock == null) {
            this.releaseLockForScheduledJob();
        }
        this.lock = updatedLock;
        return this.lock;
    }

    public boolean releaseLockForScheduledJob() {
        boolean released = false;
        try {
            final CompletableFuture future = new CompletableFuture();
            this.context.getLockService().release(this.lock, (ActionListener)new ActionListener<Boolean>(){

                public void onResponse(Boolean result) {
                    future.complete(result);
                }

                public void onFailure(Exception e) {
                    future.completeExceptionally(e);
                }
            });
            released = (Boolean)future.get();
            if (!released) {
                logger.warn("Could not release lock for job " + this.lock.getJobId());
            }
        }
        catch (InterruptedException | ExecutionException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            logger.error("Failed to release lock for job " + this.lock.getJobId(), (Throwable)e);
        }
        return released;
    }

    public void renewLockForLongSearch(long timeSpentOnSearch) {
        long expiration;
        Long lockExpiration = this.lockExpirationInSeconds();
        long l = expiration = lockExpiration != null ? lockExpiration : 0L;
        if (timeSpentOnSearch > 600L && expiration < 1200L) {
            this.renewLockForScheduledJob();
        }
    }
}

