/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.transform.util;

import io.lucenia.indexmanagement.common.retry.RetryUtils;
import io.lucenia.indexmanagement.transform.util.TransformLockManager;
import io.skylite.SkyliteException;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.bulk.BackoffPolicy;
import io.skylite.core.common.time.DateFormatter;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.tasks.TaskCancelledException;
import java.time.ZoneId;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Logger;

public final class TransformUtils {
    public static final String DEFAULT_DATE_FORMAT = "strict_date_optional_time||epoch_millis";
    private static final String DATE_FORMAT = "uuuu-MM-dd'T'HH:mm:ss.SSSZZ";
    private static final ZoneId TIMEZONE = ZoneId.of("UTC");
    private static final DateFormatter DATE_FORMATTER = DateFormatter.forPattern((String)"uuuu-MM-dd'T'HH:mm:ss.SSSZZ").withZone(TIMEZONE);
    private static final Pattern TIMEOUT_MESSAGE_PATTERN = Pattern.compile("cancelled task with reason: Cancellation timeout of (.*) is expired");

    private TransformUtils() {
    }

    public static String formatMillis(long dateTimeInMillis) {
        return DATE_FORMATTER.formatMillis(dateTimeInMillis);
    }

    public static <T> T retryTransformSearch(BackoffPolicy backoffPolicy, Logger logger, TransformLockManager transformLockManager, List<RestStatus> retryOn, TransformSearchBlock<T> block) throws Exception {
        Iterator iter = backoffPolicy.iterator();
        TimeValue backoff = TimeValue.ZERO;
        while (true) {
            try {
                return block.execute(backoff);
            }
            catch (SkyliteException e) {
                if (!iter.hasNext() || !TransformUtils.isTransformRetryable(e, retryOn)) {
                    throw e;
                }
                backoff = (TimeValue)iter.next();
                logger.warn("Operation failed. Retrying in " + String.valueOf(backoff) + ".", (Throwable)e);
                try {
                    Thread.sleep(backoff.millis());
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("Retry interrupted", ie);
                }
                if (!TransformUtils.isTransformOperationTimedOut(e)) continue;
                transformLockManager.renewLockForScheduledJob();
                continue;
            }
            break;
        }
    }

    public static boolean isTransformRetryable(SkyliteException ex, List<RestStatus> retryOn) {
        return RetryUtils.isRetryable(ex) || TransformUtils.isTransformOperationTimedOut(ex) || retryOn.contains(ex.status());
    }

    public static boolean isTransformOperationTimedOut(SkyliteException ex) {
        if (RestStatus.REQUEST_TIMEOUT == ex.status()) {
            return true;
        }
        if (ex.getCause() != null && ex.getCause() instanceof TaskCancelledException) {
            TaskCancelledException tce = (TaskCancelledException)ex.getCause();
            return TIMEOUT_MESSAGE_PATTERN.matcher(tce.getMessage()).matches();
        }
        return false;
    }

    @FunctionalInterface
    public static interface TransformSearchBlock<T> {
        public T execute(TimeValue var1) throws Exception;
    }
}

