/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.util;

import io.skylite.SkyliteException;
import io.skylite.SkyliteStatusException;
import io.skylite.common.ValidationException;
import io.skylite.core.common.Strings;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.rest.RestStatus;

public class IndexManagementException
extends SkyliteException {
    private final RestStatus status;

    public IndexManagementException(String message, RestStatus status, Exception ex) {
        super(message, (Throwable)ex, new Object[0]);
        this.status = status;
    }

    public RestStatus status() {
        return this.status;
    }

    public static SkyliteException wrap(Exception ex) {
        String friendlyMsg = ex.getMessage();
        RestStatus status = RestStatus.INTERNAL_SERVER_ERROR;
        if (ex instanceof IndexNotFoundException) {
            status = ((IndexNotFoundException)((Object)ex)).status();
            friendlyMsg = "Configuration index not found";
        } else if (ex instanceof IllegalArgumentException) {
            status = RestStatus.BAD_REQUEST;
            friendlyMsg = ex.getMessage();
        } else if (ex instanceof ValidationException) {
            status = RestStatus.BAD_REQUEST;
            friendlyMsg = ex.getMessage();
        } else if (ex instanceof SkyliteStatusException) {
            status = ((SkyliteStatusException)((Object)ex)).status();
            friendlyMsg = ex.getMessage();
        } else if (!Strings.isNullOrEmpty((String)ex.getMessage())) {
            friendlyMsg = ex.getMessage();
        }
        return new IndexManagementException(friendlyMsg, status, new Exception(ex.getClass().getName() + ": " + ex.getMessage()));
    }
}

