/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.util;

import io.lucenia.indexmanagement.IndexManagementIndices;
import io.skylite.common.action.ActionListener;
import io.skylite.common.hash.MurmurHash3;
import io.skylite.core.action.admin.indices.mapping.put.PutMappingRequest;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.client.IndicesAdminClient;
import io.skylite.core.cluster.metadata.IndexAbstraction;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.MappingMetadata;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IndexUtils {
    public static final String _META = "_meta";
    public static final String PROPERTIES = "properties";
    public static final String FIELDS = "fields";
    public static final String SCHEMA_VERSION = "schema_version";
    public static final long DEFAULT_SCHEMA_VERSION = 1L;
    public static final String ODFE_MAGIC_NULL = "#ODFE-MAGIC-NULL-MAGIC-ODFE#";
    public static final int LUCENE_MAX_CLAUSES = 1024;
    private static final int BYTE_ARRAY_SIZE = 16;
    private static final long DOCUMENT_ID_SEED = 72390L;
    private static final Logger logger = LogManager.getLogger(IndexUtils.class);
    private static long indexManagementConfigSchemaVersion;
    private static long indexStateManagementHistorySchemaVersion;

    public static long getIndexManagementConfigSchemaVersion() {
        return indexManagementConfigSchemaVersion;
    }

    public static long getIndexStateManagementHistorySchemaVersion() {
        return indexStateManagementHistorySchemaVersion;
    }

    public static long getSchemaVersion(String mapping) throws IOException {
        XContentParser xcp = MediaTypeRegistry.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, mapping);
        while (!xcp.isClosed()) {
            XContentParser.Token token = xcp.currentToken();
            if (token != null && token != XContentParser.Token.END_OBJECT && token != XContentParser.Token.START_OBJECT) {
                if (!_META.equals(xcp.currentName())) {
                    xcp.nextToken();
                    xcp.skipChildren();
                } else {
                    while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                        if (SCHEMA_VERSION.equals(xcp.currentName())) {
                            long version = xcp.longValue();
                            if (version < 0L) {
                                throw new IllegalArgumentException("Schema version must be non-negative");
                            }
                            return version;
                        }
                        xcp.nextToken();
                    }
                }
            }
            xcp.nextToken();
        }
        return 1L;
    }

    public static boolean shouldUpdateIndex(IndexMetadata index, long newVersion) {
        HashMap metaData;
        Map indexMapping;
        long oldVersion = 1L;
        MappingMetadata mappingMetadata = index != null ? index.mapping() : null;
        Map map = indexMapping = mappingMetadata != null ? mappingMetadata.sourceAsMap() : null;
        if (indexMapping != null && indexMapping.containsKey(_META) && indexMapping.get(_META) instanceof HashMap && (metaData = (HashMap)indexMapping.get(_META)).containsKey(SCHEMA_VERSION)) {
            Object versionObj = metaData.get(SCHEMA_VERSION);
            if (versionObj instanceof Integer) {
                oldVersion = ((Integer)versionObj).longValue();
            } else if (versionObj instanceof Long) {
                oldVersion = (Long)versionObj;
            }
        }
        return newVersion > oldVersion;
    }

    public static void checkAndUpdateConfigIndexMapping(ClusterState clusterState, IndicesAdminClient client, ActionListener<AcknowledgedResponse> actionListener) {
        IndexUtils.checkAndUpdateIndexMapping(".opendistro-ism-config", indexManagementConfigSchemaVersion, IndexManagementIndices.indexManagementMappings, clusterState, client, actionListener);
    }

    public static void checkAndUpdateHistoryIndexMapping(ClusterState clusterState, IndicesAdminClient client, ActionListener<AcknowledgedResponse> actionListener) {
        IndexUtils.checkAndUpdateAliasMapping(".opendistro-ism-managed-index-history-write", indexStateManagementHistorySchemaVersion, IndexManagementIndices.indexStateManagementHistoryMappings, clusterState, client, actionListener);
    }

    public static void checkAndUpdateIndexMapping(String index, long schemaVersion, String mapping, ClusterState clusterState, IndicesAdminClient client, ActionListener<AcknowledgedResponse> actionListener) {
        if (clusterState.metadata().indices().containsKey(index)) {
            if (IndexUtils.shouldUpdateIndex((IndexMetadata)clusterState.metadata().indices().get(index), schemaVersion)) {
                PutMappingRequest putMappingRequest = new PutMappingRequest(new String[]{index}).source(mapping, MediaTypeRegistry.JSON);
                client.putMapping(putMappingRequest, actionListener);
            } else {
                actionListener.onResponse((Object)new AcknowledgedResponse(true));
            }
        } else {
            logger.error("IndexMetaData does not exist for " + index);
            actionListener.onResponse((Object)new AcknowledgedResponse(false));
        }
    }

    public static void checkAndUpdateAliasMapping(String alias, long schemaVersion, String mapping, ClusterState clusterState, IndicesAdminClient client, ActionListener<AcknowledgedResponse> actionListener) {
        IndexAbstraction result = (IndexAbstraction)clusterState.metadata().getIndicesLookup().get(alias);
        if (result == null || result.getType() != IndexAbstraction.Type.ALIAS) {
            logger.error("There are no indices for alias " + alias);
            actionListener.onResponse((Object)new AcknowledgedResponse(false));
        } else {
            IndexMetadata writeIndex = result.getWriteIndex();
            if (writeIndex == null) {
                logger.error("Concrete write index does not exist for alias " + alias);
                actionListener.onResponse((Object)new AcknowledgedResponse(false));
            } else if (IndexUtils.shouldUpdateIndex(writeIndex, schemaVersion)) {
                PutMappingRequest putMappingRequest = new PutMappingRequest(new String[]{writeIndex.getIndex().getName()}).source(mapping, MediaTypeRegistry.JSON);
                client.putMapping(putMappingRequest, actionListener);
            } else {
                actionListener.onResponse((Object)new AcknowledgedResponse(true));
            }
        }
    }

    public static Map<?, ?> getFieldFromMappings(String fieldName, Map<?, ?> mappings) {
        String[] fields;
        Map currMap = mappings;
        for (String field : fields = fieldName.split("\\.")) {
            Map nextMap;
            Map propertiesMap = (Map)currMap.get(PROPERTIES);
            Map fieldsMap = (Map)currMap.get(FIELDS);
            Map map = propertiesMap != null ? (Map)propertiesMap.get(field) : (nextMap = fieldsMap != null ? (Map)fieldsMap.get(field) : null);
            if (nextMap == null) {
                return null;
            }
            currMap = nextMap;
        }
        return currMap;
    }

    public static String hashToFixedSize(String id) {
        byte[] docByteArray = id.getBytes(StandardCharsets.UTF_8);
        MurmurHash3.Hash128 hash = MurmurHash3.hash128((byte[])docByteArray, (int)0, (int)docByteArray.length, (long)72390L, (MurmurHash3.Hash128)new MurmurHash3.Hash128());
        byte[] byteArray = ByteBuffer.allocate(16).putLong(hash.h1).putLong(hash.h2).array();
        return Base64.getUrlEncoder().withoutPadding().encodeToString(byteArray);
    }

    public static boolean isDataStream(String name, ClusterState clusterState) {
        return clusterState.metadata().dataStreams().containsKey(name);
    }

    public static boolean isAlias(String indexName, ClusterState clusterState) {
        return clusterState.metadata().hasAlias(indexName);
    }

    public static String getWriteIndex(String indexName, ClusterState clusterState) {
        IndexMetadata writeIndexMetadata;
        IndexAbstraction indexAbstraction;
        if ((IndexUtils.isAlias(indexName, clusterState) || IndexUtils.isDataStream(indexName, clusterState)) && (indexAbstraction = (IndexAbstraction)clusterState.metadata().getIndicesLookup().get(indexName)) != null && (writeIndexMetadata = indexAbstraction.getWriteIndex()) != null) {
            return writeIndexMetadata.getIndex().getName();
        }
        return null;
    }

    public static String getNewestIndexByCreationDate(String[] concreteIndices, ClusterState clusterState) {
        SortedMap lookup = clusterState.metadata().getIndicesLookup();
        long maxCreationDate = Long.MIN_VALUE;
        String newestIndex = concreteIndices[0];
        for (String indexName : concreteIndices) {
            IndexAbstraction index = (IndexAbstraction)lookup.get(indexName);
            IndexMetadata indexMetadata = clusterState.metadata().index(indexName);
            if (index == null || index.getType() != IndexAbstraction.Type.CONCRETE_INDEX || indexMetadata.getCreationDate() <= maxCreationDate) continue;
            maxCreationDate = indexMetadata.getCreationDate();
            newestIndex = indexName;
        }
        return newestIndex;
    }

    public static boolean isConcreteIndex(String indexName, ClusterState clusterState) {
        IndexAbstraction indexAbstraction = (IndexAbstraction)clusterState.metadata().getIndicesLookup().get(indexName);
        return indexAbstraction != null && indexAbstraction.getType() == IndexAbstraction.Type.CONCRETE_INDEX;
    }

    private IndexUtils() {
    }

    static {
        try {
            indexManagementConfigSchemaVersion = IndexUtils.getSchemaVersion(IndexManagementIndices.indexManagementMappings);
            indexStateManagementHistorySchemaVersion = IndexUtils.getSchemaVersion(IndexManagementIndices.indexStateManagementHistoryMappings);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to initialize schema versions", e);
        }
    }
}

