/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.util;

import io.lucenia.indexmanagement.common.retry.RetryUtils;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.bulk.BackoffPolicy;
import io.skylite.core.jobs.JobExecutionContext;
import io.skylite.core.jobs.LockModel;
import io.skylite.core.jobs.ScheduledJobParameter;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class JobSchedulerUtils {
    private static final Logger logger = LogManager.getLogger((String)"o.o.i.u.JobSchedulerUtils");

    private JobSchedulerUtils() {
    }

    public static LockModel acquireLockForScheduledJob(ScheduledJobParameter scheduledJob, JobExecutionContext context, BackoffPolicy backoffPolicy) {
        final CompletableFuture lockFuture = new CompletableFuture();
        try {
            RetryUtils.retry(logger, backoffPolicy, listener -> {
                try {
                    context.getLockService().acquireLock(scheduledJob, context, listener);
                }
                catch (Exception e) {
                    listener.onFailure(e);
                }
            }, new ActionListener<LockModel>(){

                public void onResponse(LockModel lockModel) {
                    lockFuture.complete(lockModel);
                }

                public void onFailure(Exception e) {
                    lockFuture.completeExceptionally(e);
                }
            });
        }
        catch (Exception e) {
            logger.error("Failed to acquireLock for job " + scheduledJob.getName(), (Throwable)e);
            return null;
        }
        try {
            return (LockModel)lockFuture.get();
        }
        catch (Exception e) {
            logger.error("Failed to get lock for job " + scheduledJob.getName(), (Throwable)e);
            return null;
        }
    }

    public static boolean releaseLockForScheduledJob(JobExecutionContext context, LockModel lock) {
        final CompletableFuture future = new CompletableFuture();
        boolean released = false;
        try {
            context.getLockService().release(lock, (ActionListener)new ActionListener<Boolean>(){

                public void onResponse(Boolean response) {
                    future.complete(response);
                }

                public void onFailure(Exception e) {
                    future.completeExceptionally(e);
                }
            });
            released = (Boolean)future.get();
            if (!released) {
                logger.warn("Could not release lock for job " + lock.getJobId());
            }
        }
        catch (Exception e) {
            logger.error("Failed to release lock for job " + lock.getJobId(), (Throwable)e);
        }
        return released;
    }

    public static LockModel renewLockForScheduledJob(JobExecutionContext context, LockModel lock, BackoffPolicy backoffPolicy) {
        final CompletableFuture lockFuture = new CompletableFuture();
        try {
            RetryUtils.retry(logger, backoffPolicy, listener -> {
                try {
                    context.getLockService().renewLock(lock, listener);
                }
                catch (Exception e) {
                    listener.onFailure(e);
                }
            }, new ActionListener<LockModel>(){

                public void onResponse(LockModel lockModel) {
                    lockFuture.complete(lockModel);
                }

                public void onFailure(Exception e) {
                    lockFuture.completeExceptionally(e);
                }
            });
        }
        catch (Exception e) {
            logger.warn("Failed trying to renew lock on " + String.valueOf(lock) + ", releasing the existing lock", (Throwable)e);
            return null;
        }
        try {
            return (LockModel)lockFuture.get();
        }
        catch (Exception e) {
            logger.warn("Failed to get renewed lock for " + String.valueOf(lock), (Throwable)e);
            return null;
        }
    }
}

