/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.util;

import io.lucenia.indexmanagement.common.retry.RetryUtils;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.bulk.BackoffPolicy;
import io.skylite.core.jobs.JobExecutionContext;
import io.skylite.core.jobs.LockModel;
import io.skylite.core.jobs.ScheduledJobParameter;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class LockUtils {
    private static final Logger logger = LogManager.getLogger(LockUtils.class);

    private LockUtils() {
    }

    public static LockModel acquireLockForScheduledJob(ScheduledJobParameter scheduledJob, JobExecutionContext context, BackoffPolicy backoffPolicy) {
        try {
            final CompletableFuture lockFuture = new CompletableFuture();
            RetryUtils.retry(logger, backoffPolicy, listener -> {
                try {
                    context.getLockService().acquireLock(scheduledJob, context, listener);
                }
                catch (Exception e) {
                    listener.onFailure(e);
                }
            }, new ActionListener<LockModel>(){

                public void onResponse(LockModel lockModel) {
                    lockFuture.complete(lockModel);
                }

                public void onFailure(Exception e) {
                    lockFuture.completeExceptionally(e);
                }
            });
            return (LockModel)lockFuture.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error("Interrupted while acquiring lock for job {} {}", (Object)scheduledJob.getName(), (Object)e);
            return null;
        }
        catch (ExecutionException e) {
            logger.error("Failed to acquire lock for job {} {}", (Object)scheduledJob.getName(), (Object)e);
            return null;
        }
        catch (Exception e) {
            logger.error("Failed to acquire lock for job {} {}", (Object)scheduledJob.getName(), (Object)e);
            return null;
        }
    }

    public static boolean releaseLockForScheduledJob(JobExecutionContext context, final LockModel lock) {
        try {
            final CompletableFuture releaseFuture = new CompletableFuture();
            context.getLockService().release(lock, (ActionListener)new ActionListener<Boolean>(){

                public void onResponse(Boolean released) {
                    if (!released.booleanValue()) {
                        logger.warn("Could not release lock for job {}", (Object)lock.getJobId());
                    }
                    releaseFuture.complete(released);
                }

                public void onFailure(Exception e) {
                    logger.error("Failed to release lock for job {} {}", (Object)lock.getJobId(), (Object)e);
                    releaseFuture.complete(false);
                }
            });
            return (Boolean)releaseFuture.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error("Interrupted while releasing lock for job {} {}", (Object)lock.getJobId(), (Object)e);
            return false;
        }
        catch (ExecutionException e) {
            logger.error("Failed to release lock for job {} {}", (Object)lock.getJobId(), (Object)e);
            return false;
        }
    }

    public static LockModel renewLockForScheduledJob(JobExecutionContext context, LockModel lock, BackoffPolicy backoffPolicy) {
        try {
            final CompletableFuture renewFuture = new CompletableFuture();
            RetryUtils.retry(logger, backoffPolicy, listener -> {
                try {
                    context.getLockService().renewLock(lock, listener);
                }
                catch (Exception e) {
                    listener.onFailure(e);
                }
            }, new ActionListener<LockModel>(){

                public void onResponse(LockModel lockModel) {
                    renewFuture.complete(lockModel);
                }

                public void onFailure(Exception e) {
                    renewFuture.completeExceptionally(e);
                }
            });
            return (LockModel)renewFuture.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.warn("Interrupted while trying to renew lock on {}, releasing the existing lock {}", (Object)lock, (Object)e);
            return null;
        }
        catch (ExecutionException e) {
            logger.warn("Failed trying to renew lock on {}, releasing the existing lock {}", (Object)lock, (Object)e);
            return null;
        }
        catch (Exception e) {
            logger.warn("Failed trying to renew lock on {}, releasing the existing lock {}", (Object)lock, (Object)e);
            return null;
        }
    }
}

