/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.util;

import io.lucenia.indexmanagement.luceniaapi.ParseUtils;
import io.lucenia.indexmanagement.rollup.action.get.GetRollupsResponse;
import io.lucenia.indexmanagement.rollup.model.Rollup;
import io.lucenia.indexmanagement.transform.action.get.GetTransformsResponse;
import io.lucenia.indexmanagement.transform.model.Transform;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.action.search.ShardSearchFailure;
import io.skylite.core.client.Client;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.search.SearchHit;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentHelper;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;

public final class ScheduledJobUtils {
    private ScheduledJobUtils() {
    }

    public static void getJobs(Client client, SearchSourceBuilder searchSourceBuilder, ActionListener<ActionResponse> listener, String scheduledJobType) {
        ScheduledJobUtils.getJobs(client, searchSourceBuilder, listener, scheduledJobType, ScheduledJobUtils::contentParser);
    }

    public static void getJobs(Client client, SearchSourceBuilder searchSourceBuilder, final ActionListener<ActionResponse> listener, final String scheduledJobType, final BiFunction<BytesReference, Void, XContentParser> contentParserFunc) {
        SearchRequest searchRequest = new SearchRequest(new String[]{".opendistro-ism-config"}).source(searchSourceBuilder);
        client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse response) {
                long totalJobs;
                long l = totalJobs = response.getHits().getTotalHits() != null ? response.getHits().getTotalHits().value() : 0L;
                if (response.getShardFailures() != null && response.getShardFailures().length > 0) {
                    ShardSearchFailure[] failures = response.getShardFailures();
                    ShardSearchFailure failure = failures[0];
                    for (ShardSearchFailure f : failures) {
                        if (f.status().getStatus() <= failure.status().getStatus()) continue;
                        failure = f;
                    }
                    listener.onFailure((Exception)((Object)new SkyliteStatusException("Get " + scheduledJobType + " failed on some shards", failure.status(), failure.getCause(), new Object[0])));
                } else {
                    try {
                        ArrayList<Object> jobs = new ArrayList<Object>();
                        ParseUtils.QuadFunction<XContentParser, String, Long, Long, ?> parser = ScheduledJobUtils.getParser(scheduledJobType);
                        for (SearchHit hit : response.getHits().getHits()) {
                            XContentParser xcp = (XContentParser)contentParserFunc.apply(hit.getSourceRef(), null);
                            Object job = ParseUtils.parseWithType(xcp, hit.getId(), hit.getSeqNo(), hit.getPrimaryTerm(), parser);
                            jobs.add(job);
                        }
                        listener.onResponse((Object)ScheduledJobUtils.populateResponse(scheduledJobType, jobs, RestStatus.OK, (int)totalJobs));
                    }
                    catch (Exception e) {
                        listener.onFailure((Exception)((Object)new SkyliteStatusException("Failed to parse " + scheduledJobType, RestStatus.INTERNAL_SERVER_ERROR, SkyliteExceptionsHelper.unwrapCause((Throwable)e), new Object[0])));
                    }
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    private static ActionResponse populateResponse(String jobType, List<Object> jobs, RestStatus status, int totalJobs) {
        if ("rollup".equals(jobType)) {
            return new GetRollupsResponse(jobs, totalJobs, status);
        }
        if ("transform".equals(jobType)) {
            return new GetTransformsResponse(jobs, totalJobs, status);
        }
        throw new SkyliteStatusException("Unknown scheduled job type", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
    }

    private static ParseUtils.QuadFunction<XContentParser, String, Long, Long, ?> getParser(String jobType) {
        if ("transform".equals(jobType)) {
            return (xcp, id, seqNo, primaryTerm) -> {
                try {
                    return Transform.parse(xcp, id, seqNo, primaryTerm);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            };
        }
        if ("rollup".equals(jobType)) {
            return (xcp, id, seqNo, primaryTerm) -> {
                try {
                    return Rollup.parse(xcp, id, seqNo, primaryTerm);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            };
        }
        throw new SkyliteStatusException("Unknown scheduled job type", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
    }

    private static XContentParser contentParser(BytesReference bytesReference, Void unused) {
        try {
            return XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)bytesReference, (MediaType)MediaTypeRegistry.JSON);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create XContent parser", e);
        }
    }
}

