/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.util;

import io.lucenia.indexmanagement.util.IndexManagementException;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.index.query.BoolQueryBuilder;
import io.skylite.core.index.query.ExistsQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.security.auth.User;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.index.query.TermsQueryBuilder;

public final class SecurityUtils {
    public static final String INTERNAL_REQUEST = "index_management_plugin_internal_user";
    public static final String ADMIN_ROLE = "all_access";
    public static final List<String> DEFAULT_INJECT_ROLES = Collections.unmodifiableList(Arrays.asList("all_access", "AmazonES_all_access"));

    private SecurityUtils() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static User buildUser(ThreadContext threadContext, User requestedUser) {
        Boolean internalRequest = (Boolean)threadContext.getTransient(INTERNAL_REQUEST);
        if (internalRequest != null && internalRequest.booleanValue()) {
            return requestedUser;
        }
        String userInfoString = (String)threadContext.getTransient("_opendistro_security_user_info");
        User injectedUser = User.parse((String)userInfoString);
        if (injectedUser == null) {
            return null;
        }
        return new User(injectedUser.getName(), injectedUser.getBackendRoles(), injectedUser.getRoles(), injectedUser.getCustomAttNames());
    }

    public static User buildUser(ThreadContext threadContext) {
        return SecurityUtils.buildUser(threadContext, null);
    }

    public static void validateUserConfiguration(User user, boolean filterEnabled) {
        if (filterEnabled) {
            if (user == null) {
                throw IndexManagementException.wrap((Exception)((Object)new SkyliteStatusException("Filter by user backend roles in IndexManagement is not supported with security disabled", RestStatus.FORBIDDEN, new Object[0])));
            }
            if (user.getBackendRoles().isEmpty()) {
                throw IndexManagementException.wrap((Exception)((Object)new SkyliteStatusException("User doesn't have backend roles configured. Contact administrator", RestStatus.FORBIDDEN, new Object[0])));
            }
        }
    }

    public static <T> boolean validateUserConfiguration(User user, boolean filterEnabled, ActionListener<T> actionListener) {
        if (filterEnabled) {
            if (user == null) {
                actionListener.onFailure((Exception)((Object)IndexManagementException.wrap((Exception)((Object)new SkyliteStatusException("Filter by user backend roles in IndexManagement is not supported with security disabled", RestStatus.FORBIDDEN, new Object[0])))));
                return false;
            }
            if (user.getBackendRoles().isEmpty()) {
                actionListener.onFailure((Exception)((Object)IndexManagementException.wrap((Exception)((Object)new SkyliteStatusException("User doesn't have backend roles configured. Contact administrator", RestStatus.FORBIDDEN, new Object[0])))));
                return false;
            }
        }
        return true;
    }

    public static <T> boolean userHasPermissionForResource(User requestedUser, User resourceUser, boolean filterEnabled, String resourceName, String resourceId, ActionListener<T> actionListener) {
        if (!SecurityUtils.userHasPermissionForResource(requestedUser, resourceUser, filterEnabled)) {
            actionListener.onFailure((Exception)((Object)IndexManagementException.wrap((Exception)((Object)new SkyliteStatusException("Do not have permission for " + resourceName + " [" + resourceId + "]", RestStatus.FORBIDDEN, new Object[0])))));
            return false;
        }
        return true;
    }

    public static void verifyUserHasPermissionForResource(User requestedUser, User resourceUser, boolean filterEnabled, String resourceName, String resourceId) {
        if (!SecurityUtils.userHasPermissionForResource(requestedUser, resourceUser, filterEnabled)) {
            throw IndexManagementException.wrap((Exception)((Object)new SkyliteStatusException("Do not have permission for " + resourceName + " [" + resourceId + "]", RestStatus.FORBIDDEN, new Object[0])));
        }
    }

    public static boolean userHasPermissionForResource(User requestedUser, User resourceUser, boolean filterEnabled) {
        if (!filterEnabled || resourceUser == null || requestedUser == null || requestedUser.getRoles().contains(ADMIN_ROLE)) {
            return true;
        }
        List resourceBackendRoles = resourceUser.getBackendRoles();
        List requestedBackendRoles = requestedUser.getBackendRoles();
        if (resourceBackendRoles == null || requestedBackendRoles == null) {
            return false;
        }
        Set resourceRolesSet = resourceBackendRoles.stream().collect(Collectors.toSet());
        boolean hasCommonRole = requestedBackendRoles.stream().anyMatch(resourceRolesSet::contains);
        return hasCommonRole;
    }

    public static void addUserFilter(User user, BoolQueryBuilder queryBuilder, boolean filterEnabled, String filterPathPrefix) {
        if (!filterEnabled || user == null || user.getRoles().contains(ADMIN_ROLE)) {
            return;
        }
        BoolQueryBuilder filterQuery = new BoolQueryBuilder().should((QueryBuilder)new TermsQueryBuilder(filterPathPrefix + ".backend_roles.keyword", (Iterable)user.getBackendRoles())).should((QueryBuilder)new BoolQueryBuilder().mustNot((QueryBuilder)new ExistsQueryBuilder(filterPathPrefix)));
        queryBuilder.filter((QueryBuilder)filterQuery);
    }

    public static String generateUserString(User user) {
        if (user == null) {
            return "";
        }
        String backendRoles = String.join((CharSequence)",", user.getBackendRoles());
        String roles = String.join((CharSequence)",", user.getRoles());
        String requestedTenant = user.getRequestedTenant();
        String userName = user.getName();
        return userName + "|" + backendRoles + "|" + roles + "|" + requestedTenant;
    }
}

