/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.search.pipeline.common;

import io.skylite.common.collect.Tuple;
import io.skylite.common.processor.AbstractProcessor;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.document.DocumentField;
import io.skylite.core.ingest.ConfigurationUtils;
import io.skylite.core.search.SearchHit;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.pipeline.SearchProcessor;
import io.skylite.core.search.pipeline.SearchResponseProcessor;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.XContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentHelper;
import java.util.Map;

public class RenameFieldResponseProcessor
extends AbstractProcessor
implements SearchResponseProcessor {
    private final String oldField;
    private final String newField;
    private final boolean ignoreMissing;
    public static final String TYPE = "rename_field";

    public RenameFieldResponseProcessor(String tag, String description, boolean ignoreFailure, String oldField, String newField, boolean ignoreMissing) {
        super(tag, description, ignoreFailure);
        this.oldField = oldField;
        this.newField = newField;
        this.ignoreMissing = ignoreMissing;
    }

    public String getType() {
        return TYPE;
    }

    public String getOldField() {
        return this.oldField;
    }

    public String getNewField() {
        return this.newField;
    }

    public boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    public SearchResponse processResponse(SearchRequest request, SearchResponse response) throws Exception {
        SearchHit[] hits;
        boolean foundField = false;
        for (SearchHit hit : hits = response.getHits().getHits()) {
            BytesReference sourceRef;
            Tuple typeAndSourceMap;
            Map sourceAsMap;
            Map fields = hit.getFields();
            if (fields.containsKey(this.oldField)) {
                foundField = true;
                DocumentField old = hit.removeDocumentField(this.oldField);
                DocumentField newDocField = new DocumentField(this.newField, old.getValues());
                hit.setDocumentField(this.newField, newDocField);
            }
            if (hit.hasSource() && (sourceAsMap = (Map)(typeAndSourceMap = XContentHelper.convertToMap((BytesReference)(sourceRef = hit.getSourceRef()), (boolean)false, (MediaType)null)).v2()).containsKey(this.oldField)) {
                foundField = true;
                Object val = sourceAsMap.remove(this.oldField);
                sourceAsMap.put(this.newField, val);
                XContentBuilder builder = XContentBuilder.builder((XContent)((MediaType)typeAndSourceMap.v1()).xContent());
                builder.map(sourceAsMap);
                hit.sourceRef(BytesReference.bytes((XContentBuilder)builder));
            }
            if (foundField || this.ignoreMissing) continue;
            throw new IllegalArgumentException("Document with id " + hit.getId() + " is missing field " + this.oldField);
        }
        return response;
    }

    public static final class Factory
    implements SearchProcessor.Factory<SearchResponseProcessor> {
        Factory() {
        }

        public RenameFieldResponseProcessor create(Map<String, SearchProcessor.Factory<SearchResponseProcessor>> processorFactories, String tag, String description, boolean ignoreFailure, Map<String, Object> config, SearchProcessor.PipelineContext pipelineContext) throws Exception {
            String oldField = ConfigurationUtils.readStringProperty((String)RenameFieldResponseProcessor.TYPE, (String)tag, config, (String)"field");
            String newField = ConfigurationUtils.readStringProperty((String)RenameFieldResponseProcessor.TYPE, (String)tag, config, (String)"target_field");
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)RenameFieldResponseProcessor.TYPE, (String)tag, config, (String)"ignore_missing", (boolean)false);
            return new RenameFieldResponseProcessor(tag, description, ignoreFailure, oldField, newField, ignoreMissing);
        }
    }
}

