/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.identification;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.sis.metadata.internal.Dependencies;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.identification.DefaultAggregateInformation;
import org.apache.sis.metadata.iso.identification.DefaultAssociatedResource;
import org.apache.sis.metadata.iso.identification.DefaultDataIdentification;
import org.apache.sis.metadata.iso.identification.DefaultServiceIdentification;
import org.apache.sis.metadata.iso.legacy.LegacyPropertyAdapter;
import org.apache.sis.util.iso.Types;
import org.apache.sis.xml.bind.FilterByVersion;
import org.apache.sis.xml.bind.metadata.MD_Identifier;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.constraint.Constraints;
import org.opengis.metadata.distribution.Format;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.identification.AggregateInformation;
import org.opengis.metadata.identification.BrowseGraphic;
import org.opengis.metadata.identification.DataIdentification;
import org.opengis.metadata.identification.Identification;
import org.opengis.metadata.identification.Keywords;
import org.opengis.metadata.identification.Progress;
import org.opengis.metadata.identification.Resolution;
import org.opengis.metadata.identification.ServiceIdentification;
import org.opengis.metadata.identification.TopicCategory;
import org.opengis.metadata.identification.Usage;
import org.opengis.metadata.maintenance.MaintenanceInformation;
import org.opengis.metadata.spatial.SpatialRepresentationType;
import org.opengis.util.InternationalString;

@XmlType(name="AbstractMD_Identification_Type", propOrder={"citation", "abstract", "purpose", "credits", "status", "pointOfContacts", "spatialRepresentationTypes", "spatialResolutions", "topicCategories", "extents", "additionalDocumentation", "processingLevel", "resourceMaintenances", "graphicOverviews", "resourceFormats", "descriptiveKeywords", "resourceSpecificUsages", "resourceConstraints", "associatedResource", "aggregationInfo"})
@XmlRootElement(name="AbstractMD_Identification")
@XmlSeeAlso(value={DefaultDataIdentification.class, DefaultServiceIdentification.class})
public class AbstractIdentification
extends ISOMetadata
implements Identification {
    private static final long serialVersionUID = 157053637951213015L;
    private Citation citation;
    private InternationalString abstracts;
    private InternationalString purpose;
    private Collection<String> credits;
    private Collection<Progress> status;
    private Collection<ResponsibleParty> pointOfContacts;
    private Collection<SpatialRepresentationType> spatialRepresentationTypes;
    private Collection<Resolution> spatialResolutions;
    private Collection<TopicCategory> topicCategories;
    private Collection<Extent> extents;
    private Collection<Citation> additionalDocumentations;
    private Identifier processingLevel;
    private Collection<MaintenanceInformation> resourceMaintenances;
    private Collection<BrowseGraphic> graphicOverviews;
    private Collection<Format> resourceFormats;
    private Collection<Keywords> descriptiveKeywords;
    private Collection<Usage> resourceSpecificUsages;
    private Collection<Constraints> resourceConstraints;
    private Collection<DefaultAssociatedResource> associatedResources;

    public AbstractIdentification() {
    }

    public AbstractIdentification(Citation citation, CharSequence abstracts) {
        this.citation = citation;
        this.abstracts = Types.toInternationalString(abstracts);
    }

    public AbstractIdentification(Identification object) {
        super(object);
        if (object != null) {
            this.citation = object.getCitation();
            this.abstracts = object.getAbstract();
            this.purpose = object.getPurpose();
            this.credits = this.copyCollection(object.getCredits(), String.class);
            this.status = this.copyCollection(object.getStatus(), Progress.class);
            this.pointOfContacts = this.copyCollection(object.getPointOfContacts(), ResponsibleParty.class);
            this.resourceMaintenances = this.copyCollection(object.getResourceMaintenances(), MaintenanceInformation.class);
            this.graphicOverviews = this.copyCollection(object.getGraphicOverviews(), BrowseGraphic.class);
            this.resourceFormats = this.copyCollection(object.getResourceFormats(), Format.class);
            this.descriptiveKeywords = this.copyCollection(object.getDescriptiveKeywords(), Keywords.class);
            this.resourceSpecificUsages = this.copyCollection(object.getResourceSpecificUsages(), Usage.class);
            this.resourceConstraints = this.copyCollection(object.getResourceConstraints(), Constraints.class);
            if (object instanceof AbstractIdentification) {
                AbstractIdentification c = (AbstractIdentification)object;
                this.spatialRepresentationTypes = this.copyCollection(c.getSpatialRepresentationTypes(), SpatialRepresentationType.class);
                this.spatialResolutions = this.copyCollection(c.getSpatialResolutions(), Resolution.class);
                this.topicCategories = this.copyCollection(c.getTopicCategories(), TopicCategory.class);
                this.extents = this.copyCollection(c.getExtents(), Extent.class);
                this.additionalDocumentations = this.copyCollection(c.getAdditionalDocumentations(), Citation.class);
                this.processingLevel = c.getProcessingLevel();
                this.associatedResources = this.copyCollection(c.getAssociatedResources(), DefaultAssociatedResource.class);
            } else {
                this.setAggregationInfo(object.getAggregationInfo());
            }
        }
    }

    public static AbstractIdentification castOrCopy(Identification object) {
        if (object instanceof DataIdentification) {
            return DefaultDataIdentification.castOrCopy((DataIdentification)object);
        }
        if (object instanceof ServiceIdentification) {
            return DefaultServiceIdentification.castOrCopy((ServiceIdentification)object);
        }
        if (object == null || object instanceof AbstractIdentification) {
            return (AbstractIdentification)object;
        }
        return new AbstractIdentification(object);
    }

    @XmlElement(name="citation", required=true)
    public Citation getCitation() {
        return this.citation;
    }

    public void setCitation(Citation newValue) {
        this.checkWritePermission(this.citation);
        this.citation = newValue;
    }

    @XmlElement(name="abstract", required=true)
    public InternationalString getAbstract() {
        return this.abstracts;
    }

    public void setAbstract(InternationalString newValue) {
        this.checkWritePermission(this.abstracts);
        this.abstracts = newValue;
    }

    @XmlElement(name="purpose")
    public InternationalString getPurpose() {
        return this.purpose;
    }

    public void setPurpose(InternationalString newValue) {
        this.checkWritePermission(this.purpose);
        this.purpose = newValue;
    }

    @XmlElement(name="credit")
    public Collection<String> getCredits() {
        this.credits = this.nonNullCollection(this.credits, String.class);
        return this.credits;
    }

    public void setCredits(Collection<? extends String> newValues) {
        this.credits = this.writeCollection(newValues, this.credits, String.class);
    }

    @XmlElement(name="status")
    public Collection<Progress> getStatus() {
        this.status = this.nonNullCollection(this.status, Progress.class);
        return this.status;
    }

    public void setStatus(Collection<? extends Progress> newValues) {
        this.status = this.writeCollection(newValues, this.status, Progress.class);
    }

    @XmlElement(name="pointOfContact")
    public Collection<ResponsibleParty> getPointOfContacts() {
        this.pointOfContacts = this.nonNullCollection(this.pointOfContacts, ResponsibleParty.class);
        return this.pointOfContacts;
    }

    public void setPointOfContacts(Collection<? extends ResponsibleParty> newValues) {
        this.pointOfContacts = this.writeCollection(newValues, this.pointOfContacts, ResponsibleParty.class);
    }

    @XmlElement(name="spatialRepresentationType")
    @UML(identifier="spatialRepresentationType", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<SpatialRepresentationType> getSpatialRepresentationTypes() {
        this.spatialRepresentationTypes = this.nonNullCollection(this.spatialRepresentationTypes, SpatialRepresentationType.class);
        return this.spatialRepresentationTypes;
    }

    public void setSpatialRepresentationTypes(Collection<? extends SpatialRepresentationType> newValues) {
        this.spatialRepresentationTypes = this.writeCollection(newValues, this.spatialRepresentationTypes, SpatialRepresentationType.class);
    }

    @XmlElement(name="spatialResolution")
    @UML(identifier="spatialResolution", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Resolution> getSpatialResolutions() {
        this.spatialResolutions = this.nonNullCollection(this.spatialResolutions, Resolution.class);
        return this.spatialResolutions;
    }

    public void setSpatialResolutions(Collection<? extends Resolution> newValues) {
        this.spatialResolutions = this.writeCollection(newValues, this.spatialResolutions, Resolution.class);
    }

    @XmlElement(name="topicCategory")
    @UML(identifier="topicCategory", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public Collection<TopicCategory> getTopicCategories() {
        this.topicCategories = this.nonNullCollection(this.topicCategories, TopicCategory.class);
        return this.topicCategories;
    }

    public void setTopicCategories(Collection<? extends TopicCategory> newValues) {
        this.topicCategories = this.writeCollection(newValues, this.topicCategories, TopicCategory.class);
    }

    @XmlElement(name="extent")
    @UML(identifier="extent", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public Collection<Extent> getExtents() {
        this.extents = this.nonNullCollection(this.extents, Extent.class);
        return this.extents;
    }

    public void setExtents(Collection<? extends Extent> newValues) {
        this.extents = this.writeCollection(newValues, this.extents, Extent.class);
    }

    @UML(identifier="additionalDocumentation", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Citation> getAdditionalDocumentations() {
        this.additionalDocumentations = this.nonNullCollection(this.additionalDocumentations, Citation.class);
        return this.additionalDocumentations;
    }

    public void setAdditionalDocumentations(Collection<? extends Citation> newValues) {
        this.additionalDocumentations = this.writeCollection(newValues, this.additionalDocumentations, Citation.class);
    }

    @XmlElement(name="processingLevel")
    @XmlJavaTypeAdapter(value=MD_Identifier.Since2014.class)
    @UML(identifier="processingLevel", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Identifier getProcessingLevel() {
        return this.processingLevel;
    }

    public void setProcessingLevel(Identifier newValue) {
        this.checkWritePermission(this.processingLevel);
        this.processingLevel = newValue;
    }

    @XmlElement(name="resourceMaintenance")
    public Collection<MaintenanceInformation> getResourceMaintenances() {
        this.resourceMaintenances = this.nonNullCollection(this.resourceMaintenances, MaintenanceInformation.class);
        return this.resourceMaintenances;
    }

    public void setResourceMaintenances(Collection<? extends MaintenanceInformation> newValues) {
        this.resourceMaintenances = this.writeCollection(newValues, this.resourceMaintenances, MaintenanceInformation.class);
    }

    @XmlElement(name="graphicOverview")
    public Collection<BrowseGraphic> getGraphicOverviews() {
        this.graphicOverviews = this.nonNullCollection(this.graphicOverviews, BrowseGraphic.class);
        return this.graphicOverviews;
    }

    public void setGraphicOverviews(Collection<? extends BrowseGraphic> newValues) {
        this.graphicOverviews = this.writeCollection(newValues, this.graphicOverviews, BrowseGraphic.class);
    }

    @XmlElement(name="resourceFormat")
    public Collection<Format> getResourceFormats() {
        this.resourceFormats = this.nonNullCollection(this.resourceFormats, Format.class);
        return this.resourceFormats;
    }

    public void setResourceFormats(Collection<? extends Format> newValues) {
        this.resourceFormats = this.writeCollection(newValues, this.resourceFormats, Format.class);
    }

    @XmlElement(name="descriptiveKeywords")
    public Collection<Keywords> getDescriptiveKeywords() {
        this.descriptiveKeywords = this.nonNullCollection(this.descriptiveKeywords, Keywords.class);
        return this.descriptiveKeywords;
    }

    public void setDescriptiveKeywords(Collection<? extends Keywords> newValues) {
        this.descriptiveKeywords = this.writeCollection(newValues, this.descriptiveKeywords, Keywords.class);
    }

    @XmlElement(name="resourceSpecificUsage")
    public Collection<Usage> getResourceSpecificUsages() {
        this.resourceSpecificUsages = this.nonNullCollection(this.resourceSpecificUsages, Usage.class);
        return this.resourceSpecificUsages;
    }

    public void setResourceSpecificUsages(Collection<? extends Usage> newValues) {
        this.resourceSpecificUsages = this.writeCollection(newValues, this.resourceSpecificUsages, Usage.class);
    }

    @XmlElement(name="resourceConstraints")
    public Collection<Constraints> getResourceConstraints() {
        this.resourceConstraints = this.nonNullCollection(this.resourceConstraints, Constraints.class);
        return this.resourceConstraints;
    }

    public void setResourceConstraints(Collection<? extends Constraints> newValues) {
        this.resourceConstraints = this.writeCollection(newValues, this.resourceConstraints, Constraints.class);
    }

    @UML(identifier="associatedResource", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<DefaultAssociatedResource> getAssociatedResources() {
        this.associatedResources = this.nonNullCollection(this.associatedResources, DefaultAssociatedResource.class);
        return this.associatedResources;
    }

    public void setAssociatedResources(Collection<? extends DefaultAssociatedResource> newValues) {
        this.associatedResources = this.writeCollection(newValues, this.associatedResources, DefaultAssociatedResource.class);
    }

    @Deprecated(since="1.0")
    @Dependencies(value={"getAssociatedResources"})
    @XmlElement(name="aggregationInfo", namespace="http://www.isotc211.org/2005/gmd")
    public Collection<AggregateInformation> getAggregationInfo() {
        if (!FilterByVersion.LEGACY_METADATA.accept()) {
            return null;
        }
        return new LegacyPropertyAdapter<AggregateInformation, DefaultAssociatedResource>(this.getAssociatedResources()){

            @Override
            protected DefaultAssociatedResource wrap(AggregateInformation value) {
                return DefaultAssociatedResource.castOrCopy(value);
            }

            @Override
            protected AggregateInformation unwrap(DefaultAssociatedResource container) {
                if (container instanceof AggregateInformation) {
                    return (AggregateInformation)container;
                }
                return new DefaultAggregateInformation(container);
            }

            @Override
            protected boolean update(DefaultAssociatedResource container, AggregateInformation value) {
                return container == value;
            }
        }.validOrNull();
    }

    @Deprecated(since="1.0")
    public void setAggregationInfo(Collection<? extends AggregateInformation> newValues) {
        this.checkWritePermission(this.associatedResources);
        ArrayList<DefaultAssociatedResource> r = null;
        if (newValues != null) {
            r = new ArrayList<DefaultAssociatedResource>(newValues.size());
            for (AggregateInformation aggregateInformation : newValues) {
                r.add(DefaultAssociatedResource.castOrCopy(aggregateInformation));
            }
        }
        this.setAssociatedResources(r);
    }

    @XmlElement(name="additionalDocumentation")
    private Collection<Citation> getAdditionalDocumentation() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getAdditionalDocumentations() : null;
    }

    @XmlElement(name="associatedResource")
    private Collection<DefaultAssociatedResource> getAssociatedResource() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getAssociatedResources() : null;
    }
}

