/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.client;

import io.lucenia.client.Cancellable;
import io.lucenia.client.ClusterRequestConverters;
import io.lucenia.client.RequestOptions;
import io.lucenia.client.RestHighLevelClient;
import io.lucenia.client.cluster.RemoteInfoRequest;
import io.lucenia.client.cluster.RemoteInfoResponse;
import io.lucenia.client.indices.ComponentTemplatesExistRequest;
import io.lucenia.client.indices.DeleteComponentTemplateRequest;
import io.lucenia.client.indices.GetComponentTemplatesRequest;
import io.lucenia.client.indices.GetComponentTemplatesResponse;
import io.lucenia.client.indices.PutComponentTemplateRequest;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.admin.cluster.health.ClusterHealthRequest;
import io.skylite.core.action.admin.cluster.health.ClusterHealthResponse;
import io.skylite.core.action.admin.cluster.settings.ClusterGetSettingsRequest;
import io.skylite.core.action.admin.cluster.settings.ClusterGetSettingsResponse;
import io.skylite.core.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import io.skylite.core.action.admin.cluster.settings.ClusterUpdateSettingsResponse;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.rest.RestStatus;
import java.io.IOException;
import java.util.Collections;

public final class ClusterClient {
    private final RestHighLevelClient restHighLevelClient;

    ClusterClient(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    public ClusterUpdateSettingsResponse putSettings(ClusterUpdateSettingsRequest clusterUpdateSettingsRequest, RequestOptions options) throws IOException {
        return (ClusterUpdateSettingsResponse)this.restHighLevelClient.performRequestAndParseEntity(clusterUpdateSettingsRequest, ClusterRequestConverters::clusterPutSettings, options, ClusterUpdateSettingsResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable putSettingsAsync(ClusterUpdateSettingsRequest clusterUpdateSettingsRequest, RequestOptions options, ActionListener<ClusterUpdateSettingsResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(clusterUpdateSettingsRequest, ClusterRequestConverters::clusterPutSettings, options, ClusterUpdateSettingsResponse::fromXContent, listener, Collections.emptySet());
    }

    public ClusterGetSettingsResponse getSettings(ClusterGetSettingsRequest clusterGetSettingsRequest, RequestOptions options) throws IOException {
        return (ClusterGetSettingsResponse)this.restHighLevelClient.performRequestAndParseEntity(clusterGetSettingsRequest, ClusterRequestConverters::clusterGetSettings, options, ClusterGetSettingsResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable getSettingsAsync(ClusterGetSettingsRequest clusterGetSettingsRequest, RequestOptions options, ActionListener<ClusterGetSettingsResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(clusterGetSettingsRequest, ClusterRequestConverters::clusterGetSettings, options, ClusterGetSettingsResponse::fromXContent, listener, Collections.emptySet());
    }

    public ClusterHealthResponse health(ClusterHealthRequest healthRequest, RequestOptions options) throws IOException {
        return (ClusterHealthResponse)this.restHighLevelClient.performRequestAndParseEntity(healthRequest, ClusterRequestConverters::clusterHealth, options, ClusterHealthResponse::fromXContent, Collections.singleton(RestStatus.REQUEST_TIMEOUT.getStatus()));
    }

    public Cancellable healthAsync(ClusterHealthRequest healthRequest, RequestOptions options, ActionListener<ClusterHealthResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(healthRequest, ClusterRequestConverters::clusterHealth, options, ClusterHealthResponse::fromXContent, listener, Collections.singleton(RestStatus.REQUEST_TIMEOUT.getStatus()));
    }

    public RemoteInfoResponse remoteInfo(RemoteInfoRequest request, RequestOptions options) throws IOException {
        return (RemoteInfoResponse)this.restHighLevelClient.performRequestAndParseEntity(request, ClusterRequestConverters::remoteInfo, options, RemoteInfoResponse::fromXContent, Collections.singleton(RestStatus.REQUEST_TIMEOUT.getStatus()));
    }

    public Cancellable remoteInfoAsync(RemoteInfoRequest request, RequestOptions options, ActionListener<RemoteInfoResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, ClusterRequestConverters::remoteInfo, options, RemoteInfoResponse::fromXContent, listener, Collections.singleton(RestStatus.REQUEST_TIMEOUT.getStatus()));
    }

    public AcknowledgedResponse deleteComponentTemplate(DeleteComponentTemplateRequest req, RequestOptions options) throws IOException {
        return (AcknowledgedResponse)this.restHighLevelClient.performRequestAndParseEntity(req, ClusterRequestConverters::deleteComponentTemplate, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable deleteComponentTemplateAsync(DeleteComponentTemplateRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, ClusterRequestConverters::deleteComponentTemplate, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public AcknowledgedResponse putComponentTemplate(PutComponentTemplateRequest putComponentTemplateRequest, RequestOptions options) throws IOException {
        return (AcknowledgedResponse)this.restHighLevelClient.performRequestAndParseEntity(putComponentTemplateRequest, ClusterRequestConverters::putComponentTemplate, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable putComponentTemplateAsync(PutComponentTemplateRequest putComponentTemplateRequest, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(putComponentTemplateRequest, ClusterRequestConverters::putComponentTemplate, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetComponentTemplatesResponse getComponentTemplate(GetComponentTemplatesRequest getComponentTemplatesRequest, RequestOptions options) throws IOException {
        return (GetComponentTemplatesResponse)this.restHighLevelClient.performRequestAndParseEntity(getComponentTemplatesRequest, ClusterRequestConverters::getComponentTemplates, options, GetComponentTemplatesResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable getComponentTemplateAsync(GetComponentTemplatesRequest getComponentTemplatesRequest, RequestOptions options, ActionListener<GetComponentTemplatesResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(getComponentTemplatesRequest, ClusterRequestConverters::getComponentTemplates, options, GetComponentTemplatesResponse::fromXContent, listener, Collections.emptySet());
    }

    public boolean existsComponentTemplate(ComponentTemplatesExistRequest componentTemplatesRequest, RequestOptions options) throws IOException {
        return (Boolean)this.restHighLevelClient.performRequest(componentTemplatesRequest, ClusterRequestConverters::componentTemplatesExist, options, RestHighLevelClient::convertExistsResponse, Collections.emptySet());
    }

    public Cancellable existsComponentTemplateAsync(ComponentTemplatesExistRequest componentTemplatesRequest, RequestOptions options, ActionListener<Boolean> listener) {
        return this.restHighLevelClient.performRequestAsync(componentTemplatesRequest, ClusterRequestConverters::componentTemplatesExist, options, RestHighLevelClient::convertExistsResponse, listener, Collections.emptySet());
    }
}

