/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.client;

import io.lucenia.client.Cancellable;
import io.lucenia.client.IngestRequestConverters;
import io.lucenia.client.RequestOptions;
import io.lucenia.client.RestHighLevelClient;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.action.ingest.DeletePipelineRequest;
import io.skylite.core.action.ingest.GetPipelineRequest;
import io.skylite.core.action.ingest.GetPipelineResponse;
import io.skylite.core.action.ingest.PutPipelineRequest;
import io.skylite.core.action.ingest.SimulatePipelineRequest;
import io.skylite.core.action.ingest.SimulatePipelineResponse;
import java.io.IOException;
import java.util.Collections;

public final class IngestClient {
    private final RestHighLevelClient restHighLevelClient;

    IngestClient(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    public AcknowledgedResponse putPipeline(PutPipelineRequest request, RequestOptions options) throws IOException {
        return (AcknowledgedResponse)this.restHighLevelClient.performRequestAndParseEntity(request, IngestRequestConverters::putPipeline, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable putPipelineAsync(PutPipelineRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, IngestRequestConverters::putPipeline, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetPipelineResponse getPipeline(GetPipelineRequest request, RequestOptions options) throws IOException {
        return (GetPipelineResponse)this.restHighLevelClient.performRequestAndParseEntity(request, IngestRequestConverters::getPipeline, options, GetPipelineResponse::fromXContent, Collections.singleton(404));
    }

    public Cancellable getPipelineAsync(GetPipelineRequest request, RequestOptions options, ActionListener<GetPipelineResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, IngestRequestConverters::getPipeline, options, GetPipelineResponse::fromXContent, listener, Collections.singleton(404));
    }

    public AcknowledgedResponse deletePipeline(DeletePipelineRequest request, RequestOptions options) throws IOException {
        return (AcknowledgedResponse)this.restHighLevelClient.performRequestAndParseEntity(request, IngestRequestConverters::deletePipeline, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable deletePipelineAsync(DeletePipelineRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, IngestRequestConverters::deletePipeline, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public SimulatePipelineResponse simulate(SimulatePipelineRequest request, RequestOptions options) throws IOException {
        return (SimulatePipelineResponse)this.restHighLevelClient.performRequestAndParseEntity(request, IngestRequestConverters::simulatePipeline, options, SimulatePipelineResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable simulateAsync(SimulatePipelineRequest request, RequestOptions options, ActionListener<SimulatePipelineResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, IngestRequestConverters::simulatePipeline, options, SimulatePipelineResponse::fromXContent, listener, Collections.emptySet());
    }
}

