/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.client;

import io.lucenia.client.Cancellable;
import io.lucenia.client.ClusterClient;
import io.lucenia.client.IndicesClient;
import io.lucenia.client.IngestClient;
import io.lucenia.client.Request;
import io.lucenia.client.RequestConverters;
import io.lucenia.client.RequestOptions;
import io.lucenia.client.Response;
import io.lucenia.client.ResponseException;
import io.lucenia.client.ResponseListener;
import io.lucenia.client.RestClient;
import io.lucenia.client.RestClientBuilder;
import io.lucenia.client.RethrottleRequest;
import io.lucenia.client.SearchPipelineClient;
import io.lucenia.client.SnapshotClient;
import io.lucenia.client.TasksClient;
import io.lucenia.client.Validatable;
import io.lucenia.client.ValidationException;
import io.lucenia.client.core.CountRequest;
import io.lucenia.client.core.CountResponse;
import io.lucenia.client.core.GetSourceRequest;
import io.lucenia.client.core.GetSourceResponse;
import io.lucenia.client.core.MainRequest;
import io.lucenia.client.core.MainResponse;
import io.lucenia.client.core.MultiTermVectorsRequest;
import io.lucenia.client.core.MultiTermVectorsResponse;
import io.lucenia.client.core.TermVectorsRequest;
import io.lucenia.client.core.TermVectorsResponse;
import io.lucenia.client.secure.SecureRestClientBuilder;
import io.lucenia.client.tasks.TaskSubmissionResponse;
import io.lucenia.index.rankeval.RankEvalRequest;
import io.lucenia.index.rankeval.RankEvalResponse;
import io.lucenia.script.mustache.MultiSearchTemplateRequest;
import io.lucenia.script.mustache.MultiSearchTemplateResponse;
import io.lucenia.script.mustache.SearchTemplateRequest;
import io.lucenia.script.mustache.SearchTemplateResponse;
import io.skylite.SkyliteStatusException;
import io.skylite.common.CheckedConsumer;
import io.skylite.common.CheckedFunction;
import io.skylite.common.action.ActionListener;
import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.core.ParseField;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.admin.cluster.node.tasks.list.ListTasksResponse;
import io.skylite.core.action.admin.cluster.storedscripts.DeleteStoredScriptRequest;
import io.skylite.core.action.admin.cluster.storedscripts.GetStoredScriptRequest;
import io.skylite.core.action.admin.cluster.storedscripts.GetStoredScriptResponse;
import io.skylite.core.action.admin.cluster.storedscripts.PutStoredScriptRequest;
import io.skylite.core.action.bulk.BulkRequest;
import io.skylite.core.action.bulk.BulkResponse;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.action.delete.DeleteRequest;
import io.skylite.core.action.delete.DeleteResponse;
import io.skylite.core.action.explain.ExplainRequest;
import io.skylite.core.action.explain.ExplainResponse;
import io.skylite.core.action.fieldcaps.FieldCapabilitiesRequest;
import io.skylite.core.action.fieldcaps.FieldCapabilitiesResponse;
import io.skylite.core.action.get.GetRequest;
import io.skylite.core.action.get.GetResponse;
import io.skylite.core.action.get.MultiGetRequest;
import io.skylite.core.action.get.MultiGetResponse;
import io.skylite.core.action.index.IndexRequest;
import io.skylite.core.action.index.IndexResponse;
import io.skylite.core.action.search.ClearScrollRequest;
import io.skylite.core.action.search.ClearScrollResponse;
import io.skylite.core.action.search.CreatePitRequest;
import io.skylite.core.action.search.CreatePitResponse;
import io.skylite.core.action.search.DeletePitRequest;
import io.skylite.core.action.search.DeletePitResponse;
import io.skylite.core.action.search.GetAllPitNodesResponse;
import io.skylite.core.action.search.MultiSearchRequest;
import io.skylite.core.action.search.MultiSearchResponse;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.action.search.SearchScrollRequest;
import io.skylite.core.action.update.UpdateRequest;
import io.skylite.core.action.update.UpdateResponse;
import io.skylite.core.aggregations.Aggregation;
import io.skylite.core.plugins.spi.NamedXContentProvider;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.suggest.Suggest;
import io.skylite.core.search.suggest.completion.CompletionSuggestion;
import io.skylite.core.search.suggest.phrase.PhraseSuggestion;
import io.skylite.core.search.suggest.term.TermSuggestion;
import io.skylite.core.xcontent.ContextParser;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentParser;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hc.core5.http.HttpEntity;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.index.reindex.DeleteByQueryRequest;
import org.opensearch.index.reindex.ReindexRequest;
import org.opensearch.index.reindex.UpdateByQueryRequest;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.search.aggregations.bucket.adjacency.ParsedAdjacencyMatrix;
import org.opensearch.search.aggregations.bucket.composite.ParsedComposite;
import org.opensearch.search.aggregations.bucket.filter.ParsedFilter;
import org.opensearch.search.aggregations.bucket.filter.ParsedFilters;
import org.opensearch.search.aggregations.bucket.global.ParsedGlobal;
import org.opensearch.search.aggregations.bucket.histogram.ParsedAutoDateHistogram;
import org.opensearch.search.aggregations.bucket.histogram.ParsedDateHistogram;
import org.opensearch.search.aggregations.bucket.histogram.ParsedHistogram;
import org.opensearch.search.aggregations.bucket.histogram.ParsedVariableWidthHistogram;
import org.opensearch.search.aggregations.bucket.missing.ParsedMissing;
import org.opensearch.search.aggregations.bucket.nested.ParsedNested;
import org.opensearch.search.aggregations.bucket.nested.ParsedReverseNested;
import org.opensearch.search.aggregations.bucket.range.ParsedBinaryRange;
import org.opensearch.search.aggregations.bucket.range.ParsedDateRange;
import org.opensearch.search.aggregations.bucket.range.ParsedGeoDistance;
import org.opensearch.search.aggregations.bucket.range.ParsedRange;
import org.opensearch.search.aggregations.bucket.sampler.ParsedSampler;
import org.opensearch.search.aggregations.bucket.terms.ParsedDoubleTerms;
import org.opensearch.search.aggregations.bucket.terms.ParsedLongRareTerms;
import org.opensearch.search.aggregations.bucket.terms.ParsedLongTerms;
import org.opensearch.search.aggregations.bucket.terms.ParsedMultiTerms;
import org.opensearch.search.aggregations.bucket.terms.ParsedSignificantLongTerms;
import org.opensearch.search.aggregations.bucket.terms.ParsedSignificantStringTerms;
import org.opensearch.search.aggregations.bucket.terms.ParsedUnsignedLongTerms;
import org.opensearch.search.aggregations.metrics.ParsedAvg;
import org.opensearch.search.aggregations.metrics.ParsedCardinality;
import org.opensearch.search.aggregations.metrics.ParsedExtendedStats;
import org.opensearch.search.aggregations.metrics.ParsedGeoCentroid;
import org.opensearch.search.aggregations.metrics.ParsedHDRPercentileRanks;
import org.opensearch.search.aggregations.metrics.ParsedHDRPercentiles;
import org.opensearch.search.aggregations.metrics.ParsedMax;
import org.opensearch.search.aggregations.metrics.ParsedMedianAbsoluteDeviation;
import org.opensearch.search.aggregations.metrics.ParsedMin;
import org.opensearch.search.aggregations.metrics.ParsedScriptedMetric;
import org.opensearch.search.aggregations.metrics.ParsedStats;
import org.opensearch.search.aggregations.metrics.ParsedSum;
import org.opensearch.search.aggregations.metrics.ParsedTDigestPercentileRanks;
import org.opensearch.search.aggregations.metrics.ParsedTDigestPercentiles;
import org.opensearch.search.aggregations.metrics.ParsedTopHits;
import org.opensearch.search.aggregations.metrics.ParsedValueCount;
import org.opensearch.search.aggregations.metrics.ParsedWeightedAvg;
import org.opensearch.search.aggregations.pipeline.ParsedBucketMetricValue;
import org.opensearch.search.aggregations.pipeline.ParsedDerivative;
import org.opensearch.search.aggregations.pipeline.ParsedExtendedStatsBucket;
import org.opensearch.search.aggregations.pipeline.ParsedPercentilesBucket;
import org.opensearch.search.aggregations.pipeline.ParsedSimpleValue;
import org.opensearch.search.aggregations.pipeline.ParsedStatsBucket;

public class RestHighLevelClient
implements Closeable {
    private final RestClient client;
    private final NamedXContentRegistry registry;
    private final CheckedConsumer<RestClient, IOException> doClose;
    private final IndicesClient indicesClient = new IndicesClient(this);
    private final ClusterClient clusterClient = new ClusterClient(this);
    private final IngestClient ingestClient = new IngestClient(this);
    private final SnapshotClient snapshotClient = new SnapshotClient(this);
    private final TasksClient tasksClient = new TasksClient(this);
    private final SearchPipelineClient searchPipelineClient = new SearchPipelineClient(this);
    private static final DeprecationHandler DEPRECATION_HANDLER = DeprecationHandler.IGNORE_DEPRECATIONS;

    public RestHighLevelClient(RestClientBuilder restClientBuilder) {
        this(restClientBuilder, Collections.emptyList());
    }

    public RestHighLevelClient(SecureRestClientBuilder secureRestClientBuilder) throws IOException {
        this(secureRestClientBuilder, Collections.emptyList());
    }

    protected RestHighLevelClient(RestClientBuilder restClientBuilder, List<NamedXContentRegistry.Entry> namedXContentEntries) {
        this(restClientBuilder.build(), (CheckedConsumer<RestClient, IOException>)((CheckedConsumer)RestClient::close), namedXContentEntries);
    }

    public RestHighLevelClient(SecureRestClientBuilder secureRestClientBuilder, List<NamedXContentRegistry.Entry> namedXContentEntries) throws IOException {
        this(secureRestClientBuilder.build(), (CheckedConsumer<RestClient, IOException>)((CheckedConsumer)RestClient::close), namedXContentEntries);
    }

    protected RestHighLevelClient(RestClient restClient, CheckedConsumer<RestClient, IOException> doClose, List<NamedXContentRegistry.Entry> namedXContentEntries) {
        this.client = Objects.requireNonNull(restClient, "restClient must not be null");
        this.doClose = Objects.requireNonNull(doClose, "doClose consumer must not be null");
        this.registry = new NamedXContentRegistry(Stream.of(RestHighLevelClient.getDefaultNamedXContents().stream(), RestHighLevelClient.getProvidedNamedXContents().stream(), namedXContentEntries.stream()).flatMap(Function.identity()).collect(Collectors.toList()));
    }

    public final RestClient getLowLevelClient() {
        return this.client;
    }

    @Override
    public final void close() throws IOException {
        this.doClose.accept((Object)this.client);
    }

    public final IndicesClient indices() {
        return this.indicesClient;
    }

    public final ClusterClient cluster() {
        return this.clusterClient;
    }

    public final IngestClient ingest() {
        return this.ingestClient;
    }

    public final SnapshotClient snapshot() {
        return this.snapshotClient;
    }

    public final TasksClient tasks() {
        return this.tasksClient;
    }

    public final SearchPipelineClient searchPipeline() {
        return this.searchPipelineClient;
    }

    public final BulkResponse bulk(BulkRequest bulkRequest, RequestOptions options) throws IOException {
        return (BulkResponse)this.performRequestAndParseEntity(bulkRequest, RequestConverters::bulk, options, BulkResponse::fromXContent, Collections.emptySet());
    }

    public final Cancellable bulkAsync(BulkRequest bulkRequest, RequestOptions options, ActionListener<BulkResponse> listener) {
        return this.performRequestAsyncAndParseEntity(bulkRequest, RequestConverters::bulk, options, BulkResponse::fromXContent, listener, Collections.emptySet());
    }

    public final BulkByScrollResponse reindex(ReindexRequest reindexRequest, RequestOptions options) throws IOException {
        return (BulkByScrollResponse)this.performRequestAndParseEntity(reindexRequest, RequestConverters::reindex, options, BulkByScrollResponse::fromXContent, Collections.singleton(409));
    }

    public final TaskSubmissionResponse submitReindexTask(ReindexRequest reindexRequest, RequestOptions options) throws IOException {
        return (TaskSubmissionResponse)this.performRequestAndParseEntity(reindexRequest, RequestConverters::submitReindex, options, TaskSubmissionResponse::fromXContent, Collections.emptySet());
    }

    public final Cancellable reindexAsync(ReindexRequest reindexRequest, RequestOptions options, ActionListener<BulkByScrollResponse> listener) {
        return this.performRequestAsyncAndParseEntity(reindexRequest, RequestConverters::reindex, options, BulkByScrollResponse::fromXContent, listener, Collections.singleton(409));
    }

    public final BulkByScrollResponse updateByQuery(UpdateByQueryRequest updateByQueryRequest, RequestOptions options) throws IOException {
        return (BulkByScrollResponse)this.performRequestAndParseEntity(updateByQueryRequest, RequestConverters::updateByQuery, options, BulkByScrollResponse::fromXContent, Collections.singleton(409));
    }

    public final TaskSubmissionResponse submitUpdateByQueryTask(UpdateByQueryRequest updateByQueryRequest, RequestOptions options) throws IOException {
        return (TaskSubmissionResponse)this.performRequestAndParseEntity(updateByQueryRequest, RequestConverters::submitUpdateByQuery, options, TaskSubmissionResponse::fromXContent, Collections.emptySet());
    }

    public final Cancellable updateByQueryAsync(UpdateByQueryRequest updateByQueryRequest, RequestOptions options, ActionListener<BulkByScrollResponse> listener) {
        return this.performRequestAsyncAndParseEntity(updateByQueryRequest, RequestConverters::updateByQuery, options, BulkByScrollResponse::fromXContent, listener, Collections.singleton(409));
    }

    public final BulkByScrollResponse deleteByQuery(DeleteByQueryRequest deleteByQueryRequest, RequestOptions options) throws IOException {
        return (BulkByScrollResponse)this.performRequestAndParseEntity(deleteByQueryRequest, RequestConverters::deleteByQuery, options, BulkByScrollResponse::fromXContent, Collections.singleton(409));
    }

    public final TaskSubmissionResponse submitDeleteByQueryTask(DeleteByQueryRequest deleteByQueryRequest, RequestOptions options) throws IOException {
        return (TaskSubmissionResponse)this.performRequestAndParseEntity(deleteByQueryRequest, RequestConverters::submitDeleteByQuery, options, TaskSubmissionResponse::fromXContent, Collections.emptySet());
    }

    public final Cancellable deleteByQueryAsync(DeleteByQueryRequest deleteByQueryRequest, RequestOptions options, ActionListener<BulkByScrollResponse> listener) {
        return this.performRequestAsyncAndParseEntity(deleteByQueryRequest, RequestConverters::deleteByQuery, options, BulkByScrollResponse::fromXContent, listener, Collections.singleton(409));
    }

    public final ListTasksResponse deleteByQueryRethrottle(RethrottleRequest rethrottleRequest, RequestOptions options) throws IOException {
        return (ListTasksResponse)this.performRequestAndParseEntity(rethrottleRequest, RequestConverters::rethrottleDeleteByQuery, options, ListTasksResponse::fromXContent, Collections.emptySet());
    }

    public final Cancellable deleteByQueryRethrottleAsync(RethrottleRequest rethrottleRequest, RequestOptions options, ActionListener<ListTasksResponse> listener) {
        return this.performRequestAsyncAndParseEntity(rethrottleRequest, RequestConverters::rethrottleDeleteByQuery, options, ListTasksResponse::fromXContent, listener, Collections.emptySet());
    }

    public final ListTasksResponse updateByQueryRethrottle(RethrottleRequest rethrottleRequest, RequestOptions options) throws IOException {
        return (ListTasksResponse)this.performRequestAndParseEntity(rethrottleRequest, RequestConverters::rethrottleUpdateByQuery, options, ListTasksResponse::fromXContent, Collections.emptySet());
    }

    public final Cancellable updateByQueryRethrottleAsync(RethrottleRequest rethrottleRequest, RequestOptions options, ActionListener<ListTasksResponse> listener) {
        return this.performRequestAsyncAndParseEntity(rethrottleRequest, RequestConverters::rethrottleUpdateByQuery, options, ListTasksResponse::fromXContent, listener, Collections.emptySet());
    }

    public final ListTasksResponse reindexRethrottle(RethrottleRequest rethrottleRequest, RequestOptions options) throws IOException {
        return (ListTasksResponse)this.performRequestAndParseEntity(rethrottleRequest, RequestConverters::rethrottleReindex, options, ListTasksResponse::fromXContent, Collections.emptySet());
    }

    public final Cancellable reindexRethrottleAsync(RethrottleRequest rethrottleRequest, RequestOptions options, ActionListener<ListTasksResponse> listener) {
        return this.performRequestAsyncAndParseEntity(rethrottleRequest, RequestConverters::rethrottleReindex, options, ListTasksResponse::fromXContent, listener, Collections.emptySet());
    }

    public final boolean ping(RequestOptions options) throws IOException {
        return (Boolean)this.performRequest(new MainRequest(), request -> RequestConverters.ping(), options, RestHighLevelClient::convertExistsResponse, Collections.emptySet());
    }

    public final MainResponse info(RequestOptions options) throws IOException {
        return (MainResponse)this.performRequestAndParseEntity(new MainRequest(), request -> RequestConverters.info(), options, MainResponse::fromXContent, Collections.emptySet());
    }

    public final GetResponse get(GetRequest getRequest, RequestOptions options) throws IOException {
        return (GetResponse)this.performRequestAndParseEntity(getRequest, RequestConverters::get, options, GetResponse::fromXContent, Collections.singleton(404));
    }

    public final Cancellable getAsync(GetRequest getRequest, RequestOptions options, ActionListener<GetResponse> listener) {
        return this.performRequestAsyncAndParseEntity(getRequest, RequestConverters::get, options, GetResponse::fromXContent, listener, Collections.singleton(404));
    }

    @Deprecated
    public final MultiGetResponse multiGet(MultiGetRequest multiGetRequest, RequestOptions options) throws IOException {
        return this.mget(multiGetRequest, options);
    }

    public final MultiGetResponse mget(MultiGetRequest multiGetRequest, RequestOptions options) throws IOException {
        return (MultiGetResponse)this.performRequestAndParseEntity(multiGetRequest, RequestConverters::multiGet, options, MultiGetResponse::fromXContent, Collections.singleton(404));
    }

    @Deprecated
    public final Cancellable multiGetAsync(MultiGetRequest multiGetRequest, RequestOptions options, ActionListener<MultiGetResponse> listener) {
        return this.mgetAsync(multiGetRequest, options, listener);
    }

    public final Cancellable mgetAsync(MultiGetRequest multiGetRequest, RequestOptions options, ActionListener<MultiGetResponse> listener) {
        return this.performRequestAsyncAndParseEntity(multiGetRequest, RequestConverters::multiGet, options, MultiGetResponse::fromXContent, listener, Collections.singleton(404));
    }

    public final boolean exists(GetRequest getRequest, RequestOptions options) throws IOException {
        return (Boolean)this.performRequest(getRequest, RequestConverters::exists, options, RestHighLevelClient::convertExistsResponse, Collections.emptySet());
    }

    public final Cancellable existsAsync(GetRequest getRequest, RequestOptions options, ActionListener<Boolean> listener) {
        return this.performRequestAsync(getRequest, RequestConverters::exists, options, RestHighLevelClient::convertExistsResponse, listener, Collections.emptySet());
    }

    @Deprecated
    public boolean existsSource(GetRequest getRequest, RequestOptions options) throws IOException {
        GetSourceRequest getSourceRequest = GetSourceRequest.from(getRequest);
        return (Boolean)this.performRequest(getSourceRequest, RequestConverters::sourceExists, options, RestHighLevelClient::convertExistsResponse, Collections.emptySet());
    }

    @Deprecated
    public final Cancellable existsSourceAsync(GetRequest getRequest, RequestOptions options, ActionListener<Boolean> listener) {
        GetSourceRequest getSourceRequest = GetSourceRequest.from(getRequest);
        return this.performRequestAsync(getSourceRequest, RequestConverters::sourceExists, options, RestHighLevelClient::convertExistsResponse, listener, Collections.emptySet());
    }

    public boolean existsSource(GetSourceRequest getSourceRequest, RequestOptions options) throws IOException {
        return (Boolean)this.performRequest(getSourceRequest, RequestConverters::sourceExists, options, RestHighLevelClient::convertExistsResponse, Collections.emptySet());
    }

    public final Cancellable existsSourceAsync(GetSourceRequest getSourceRequest, RequestOptions options, ActionListener<Boolean> listener) {
        return this.performRequestAsync(getSourceRequest, RequestConverters::sourceExists, options, RestHighLevelClient::convertExistsResponse, listener, Collections.emptySet());
    }

    public GetSourceResponse getSource(GetSourceRequest getSourceRequest, RequestOptions options) throws IOException {
        return (GetSourceResponse)this.performRequestAndParseEntity(getSourceRequest, RequestConverters::getSource, options, GetSourceResponse::fromXContent, Collections.emptySet());
    }

    public final Cancellable getSourceAsync(GetSourceRequest getSourceRequest, RequestOptions options, ActionListener<GetSourceResponse> listener) {
        return this.performRequestAsyncAndParseEntity(getSourceRequest, RequestConverters::getSource, options, GetSourceResponse::fromXContent, listener, Collections.emptySet());
    }

    public final IndexResponse index(IndexRequest indexRequest, RequestOptions options) throws IOException {
        return (IndexResponse)this.performRequestAndParseEntity(indexRequest, RequestConverters::index, options, IndexResponse::fromXContent, Collections.emptySet());
    }

    public final Cancellable indexAsync(IndexRequest indexRequest, RequestOptions options, ActionListener<IndexResponse> listener) {
        return this.performRequestAsyncAndParseEntity(indexRequest, RequestConverters::index, options, IndexResponse::fromXContent, listener, Collections.emptySet());
    }

    public final CountResponse count(CountRequest countRequest, RequestOptions options) throws IOException {
        return (CountResponse)this.performRequestAndParseEntity(countRequest, RequestConverters::count, options, CountResponse::fromXContent, Collections.emptySet());
    }

    public final Cancellable countAsync(CountRequest countRequest, RequestOptions options, ActionListener<CountResponse> listener) {
        return this.performRequestAsyncAndParseEntity(countRequest, RequestConverters::count, options, CountResponse::fromXContent, listener, Collections.emptySet());
    }

    public final UpdateResponse update(UpdateRequest updateRequest, RequestOptions options) throws IOException {
        return (UpdateResponse)this.performRequestAndParseEntity(updateRequest, RequestConverters::update, options, UpdateResponse::fromXContent, Collections.emptySet());
    }

    public final Cancellable updateAsync(UpdateRequest updateRequest, RequestOptions options, ActionListener<UpdateResponse> listener) {
        return this.performRequestAsyncAndParseEntity(updateRequest, RequestConverters::update, options, UpdateResponse::fromXContent, listener, Collections.emptySet());
    }

    public final DeleteResponse delete(DeleteRequest deleteRequest, RequestOptions options) throws IOException {
        return (DeleteResponse)this.performRequestAndParseEntity(deleteRequest, RequestConverters::delete, options, DeleteResponse::fromXContent, Collections.singleton(404));
    }

    public final Cancellable deleteAsync(DeleteRequest deleteRequest, RequestOptions options, ActionListener<DeleteResponse> listener) {
        return this.performRequestAsyncAndParseEntity(deleteRequest, RequestConverters::delete, options, DeleteResponse::fromXContent, listener, Collections.singleton(404));
    }

    public final SearchResponse search(SearchRequest searchRequest, RequestOptions options) throws IOException {
        return (SearchResponse)this.performRequestAndParseEntity(searchRequest, r -> RequestConverters.search(r, "_search"), options, SearchResponse::fromXContent, Collections.emptySet());
    }

    public final Cancellable searchAsync(SearchRequest searchRequest, RequestOptions options, ActionListener<SearchResponse> listener) {
        return this.performRequestAsyncAndParseEntity(searchRequest, r -> RequestConverters.search(r, "_search"), options, SearchResponse::fromXContent, listener, Collections.emptySet());
    }

    @Deprecated
    public final MultiSearchResponse multiSearch(MultiSearchRequest multiSearchRequest, RequestOptions options) throws IOException {
        return this.msearch(multiSearchRequest, options);
    }

    public final MultiSearchResponse msearch(MultiSearchRequest multiSearchRequest, RequestOptions options) throws IOException {
        return (MultiSearchResponse)this.performRequestAndParseEntity(multiSearchRequest, RequestConverters::multiSearch, options, MultiSearchResponse::fromXContext, Collections.emptySet());
    }

    @Deprecated
    public final Cancellable multiSearchAsync(MultiSearchRequest searchRequest, RequestOptions options, ActionListener<MultiSearchResponse> listener) {
        return this.msearchAsync(searchRequest, options, listener);
    }

    public final Cancellable msearchAsync(MultiSearchRequest searchRequest, RequestOptions options, ActionListener<MultiSearchResponse> listener) {
        return this.performRequestAsyncAndParseEntity(searchRequest, RequestConverters::multiSearch, options, MultiSearchResponse::fromXContext, listener, Collections.emptySet());
    }

    @Deprecated
    public final SearchResponse searchScroll(SearchScrollRequest searchScrollRequest, RequestOptions options) throws IOException {
        return this.scroll(searchScrollRequest, options);
    }

    public final SearchResponse scroll(SearchScrollRequest searchScrollRequest, RequestOptions options) throws IOException {
        return (SearchResponse)this.performRequestAndParseEntity(searchScrollRequest, RequestConverters::searchScroll, options, SearchResponse::fromXContent, Collections.emptySet());
    }

    @Deprecated
    public final Cancellable searchScrollAsync(SearchScrollRequest searchScrollRequest, RequestOptions options, ActionListener<SearchResponse> listener) {
        return this.scrollAsync(searchScrollRequest, options, listener);
    }

    public final Cancellable scrollAsync(SearchScrollRequest searchScrollRequest, RequestOptions options, ActionListener<SearchResponse> listener) {
        return this.performRequestAsyncAndParseEntity(searchScrollRequest, RequestConverters::searchScroll, options, SearchResponse::fromXContent, listener, Collections.emptySet());
    }

    public final CreatePitResponse createPit(CreatePitRequest createPitRequest, RequestOptions options) throws IOException {
        return (CreatePitResponse)this.performRequestAndParseEntity(createPitRequest, RequestConverters::createPit, options, CreatePitResponse::fromXContent, Collections.emptySet());
    }

    public final Cancellable createPitAsync(CreatePitRequest createPitRequest, RequestOptions options, ActionListener<CreatePitResponse> listener) {
        return this.performRequestAsyncAndParseEntity(createPitRequest, RequestConverters::createPit, options, CreatePitResponse::fromXContent, listener, Collections.emptySet());
    }

    public final DeletePitResponse deletePit(DeletePitRequest deletePitRequest, RequestOptions options) throws IOException {
        return (DeletePitResponse)this.performRequestAndParseEntity(deletePitRequest, RequestConverters::deletePit, options, DeletePitResponse::fromXContent, Collections.emptySet());
    }

    public final Cancellable deletePitAsync(DeletePitRequest deletePitRequest, RequestOptions options, ActionListener<DeletePitResponse> listener) {
        return this.performRequestAsyncAndParseEntity(deletePitRequest, RequestConverters::deletePit, options, DeletePitResponse::fromXContent, listener, Collections.emptySet());
    }

    public final DeletePitResponse deleteAllPits(RequestOptions options) throws IOException {
        return (DeletePitResponse)this.performRequestAndParseEntity(new MainRequest(), request -> RequestConverters.deleteAllPits(), options, DeletePitResponse::fromXContent, Collections.emptySet());
    }

    public final Cancellable deleteAllPitsAsync(RequestOptions options, ActionListener<DeletePitResponse> listener) {
        return this.performRequestAsyncAndParseEntity(new MainRequest(), request -> RequestConverters.deleteAllPits(), options, DeletePitResponse::fromXContent, listener, Collections.emptySet());
    }

    public final GetAllPitNodesResponse getAllPits(RequestOptions options) throws IOException {
        return (GetAllPitNodesResponse)this.performRequestAndParseEntity(new MainRequest(), request -> RequestConverters.getAllPits(), options, GetAllPitNodesResponse::fromXContent, Collections.emptySet());
    }

    public final Cancellable getAllPitsAsync(RequestOptions options, ActionListener<GetAllPitNodesResponse> listener) {
        return this.performRequestAsyncAndParseEntity(new MainRequest(), request -> RequestConverters.getAllPits(), options, GetAllPitNodesResponse::fromXContent, listener, Collections.emptySet());
    }

    public final ClearScrollResponse clearScroll(ClearScrollRequest clearScrollRequest, RequestOptions options) throws IOException {
        return (ClearScrollResponse)this.performRequestAndParseEntity(clearScrollRequest, RequestConverters::clearScroll, options, ClearScrollResponse::fromXContent, Collections.emptySet());
    }

    public final Cancellable clearScrollAsync(ClearScrollRequest clearScrollRequest, RequestOptions options, ActionListener<ClearScrollResponse> listener) {
        return this.performRequestAsyncAndParseEntity(clearScrollRequest, RequestConverters::clearScroll, options, ClearScrollResponse::fromXContent, listener, Collections.emptySet());
    }

    public final SearchTemplateResponse searchTemplate(SearchTemplateRequest searchTemplateRequest, RequestOptions options) throws IOException {
        return (SearchTemplateResponse)this.performRequestAndParseEntity(searchTemplateRequest, RequestConverters::searchTemplate, options, SearchTemplateResponse::fromXContent, Collections.emptySet());
    }

    public final Cancellable searchTemplateAsync(SearchTemplateRequest searchTemplateRequest, RequestOptions options, ActionListener<SearchTemplateResponse> listener) {
        return this.performRequestAsyncAndParseEntity(searchTemplateRequest, RequestConverters::searchTemplate, options, SearchTemplateResponse::fromXContent, listener, Collections.emptySet());
    }

    public final ExplainResponse explain(ExplainRequest explainRequest, RequestOptions options) throws IOException {
        return (ExplainResponse)this.performRequest(explainRequest, RequestConverters::explain, options, response -> {
            CheckedFunction entityParser = parser -> ExplainResponse.fromXContent((XContentParser)parser, (boolean)RestHighLevelClient.convertExistsResponse(response));
            return (ExplainResponse)this.parseEntity(response.getEntity(), entityParser);
        }, Collections.singleton(404));
    }

    public final Cancellable explainAsync(ExplainRequest explainRequest, RequestOptions options, ActionListener<ExplainResponse> listener) {
        return this.performRequestAsync(explainRequest, RequestConverters::explain, options, response -> {
            CheckedFunction entityParser = parser -> ExplainResponse.fromXContent((XContentParser)parser, (boolean)RestHighLevelClient.convertExistsResponse(response));
            return (ExplainResponse)this.parseEntity(response.getEntity(), entityParser);
        }, listener, Collections.singleton(404));
    }

    public final TermVectorsResponse termvectors(TermVectorsRequest request, RequestOptions options) throws IOException {
        return (TermVectorsResponse)this.performRequestAndParseEntity(request, RequestConverters::termVectors, options, TermVectorsResponse::fromXContent, Collections.emptySet());
    }

    public final Cancellable termvectorsAsync(TermVectorsRequest request, RequestOptions options, ActionListener<TermVectorsResponse> listener) {
        return this.performRequestAsyncAndParseEntity(request, RequestConverters::termVectors, options, TermVectorsResponse::fromXContent, listener, Collections.emptySet());
    }

    public final MultiTermVectorsResponse mtermvectors(MultiTermVectorsRequest request, RequestOptions options) throws IOException {
        return (MultiTermVectorsResponse)this.performRequestAndParseEntity(request, RequestConverters::mtermVectors, options, MultiTermVectorsResponse::fromXContent, Collections.emptySet());
    }

    public final Cancellable mtermvectorsAsync(MultiTermVectorsRequest request, RequestOptions options, ActionListener<MultiTermVectorsResponse> listener) {
        return this.performRequestAsyncAndParseEntity(request, RequestConverters::mtermVectors, options, MultiTermVectorsResponse::fromXContent, listener, Collections.emptySet());
    }

    public final RankEvalResponse rankEval(RankEvalRequest rankEvalRequest, RequestOptions options) throws IOException {
        return (RankEvalResponse)this.performRequestAndParseEntity(rankEvalRequest, RequestConverters::rankEval, options, RankEvalResponse::fromXContent, Collections.emptySet());
    }

    public final MultiSearchTemplateResponse msearchTemplate(MultiSearchTemplateRequest multiSearchTemplateRequest, RequestOptions options) throws IOException {
        return (MultiSearchTemplateResponse)this.performRequestAndParseEntity(multiSearchTemplateRequest, RequestConverters::multiSearchTemplate, options, MultiSearchTemplateResponse::fromXContext, Collections.emptySet());
    }

    public final Cancellable msearchTemplateAsync(MultiSearchTemplateRequest multiSearchTemplateRequest, RequestOptions options, ActionListener<MultiSearchTemplateResponse> listener) {
        return this.performRequestAsyncAndParseEntity(multiSearchTemplateRequest, RequestConverters::multiSearchTemplate, options, MultiSearchTemplateResponse::fromXContext, listener, Collections.emptySet());
    }

    public final Cancellable rankEvalAsync(RankEvalRequest rankEvalRequest, RequestOptions options, ActionListener<RankEvalResponse> listener) {
        return this.performRequestAsyncAndParseEntity(rankEvalRequest, RequestConverters::rankEval, options, RankEvalResponse::fromXContent, listener, Collections.emptySet());
    }

    public final FieldCapabilitiesResponse fieldCaps(FieldCapabilitiesRequest fieldCapabilitiesRequest, RequestOptions options) throws IOException {
        return (FieldCapabilitiesResponse)this.performRequestAndParseEntity(fieldCapabilitiesRequest, RequestConverters::fieldCaps, options, FieldCapabilitiesResponse::fromXContent, Collections.emptySet());
    }

    public GetStoredScriptResponse getScript(GetStoredScriptRequest request, RequestOptions options) throws IOException {
        return (GetStoredScriptResponse)this.performRequestAndParseEntity(request, RequestConverters::getScript, options, GetStoredScriptResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable getScriptAsync(GetStoredScriptRequest request, RequestOptions options, ActionListener<GetStoredScriptResponse> listener) {
        return this.performRequestAsyncAndParseEntity(request, RequestConverters::getScript, options, GetStoredScriptResponse::fromXContent, listener, Collections.emptySet());
    }

    public AcknowledgedResponse deleteScript(DeleteStoredScriptRequest request, RequestOptions options) throws IOException {
        return (AcknowledgedResponse)this.performRequestAndParseEntity(request, RequestConverters::deleteScript, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable deleteScriptAsync(DeleteStoredScriptRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        return this.performRequestAsyncAndParseEntity(request, RequestConverters::deleteScript, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public AcknowledgedResponse putScript(PutStoredScriptRequest putStoredScriptRequest, RequestOptions options) throws IOException {
        return (AcknowledgedResponse)this.performRequestAndParseEntity(putStoredScriptRequest, RequestConverters::putScript, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable putScriptAsync(PutStoredScriptRequest putStoredScriptRequest, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        return this.performRequestAsyncAndParseEntity(putStoredScriptRequest, RequestConverters::putScript, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public final Cancellable fieldCapsAsync(FieldCapabilitiesRequest fieldCapabilitiesRequest, RequestOptions options, ActionListener<FieldCapabilitiesResponse> listener) {
        return this.performRequestAsyncAndParseEntity(fieldCapabilitiesRequest, RequestConverters::fieldCaps, options, FieldCapabilitiesResponse::fromXContent, listener, Collections.emptySet());
    }

    @Deprecated
    protected final <Req extends ActionRequest, Resp> Resp performRequestAndParseEntity(Req request, CheckedFunction<Req, Request, IOException> requestConverter, RequestOptions options, CheckedFunction<XContentParser, Resp, IOException> entityParser, Set<Integer> ignores) throws IOException {
        return this.performRequest(request, requestConverter, options, (CheckedFunction<Response, Resp, IOException>)((CheckedFunction)response -> this.parseEntity(response.getEntity(), entityParser)), ignores);
    }

    protected final <Req extends Validatable, Resp> Resp performRequestAndParseEntity(Req request, CheckedFunction<Req, Request, IOException> requestConverter, RequestOptions options, CheckedFunction<XContentParser, Resp, IOException> entityParser, Set<Integer> ignores) throws IOException {
        return this.performRequest(request, requestConverter, options, response -> this.parseEntity(response.getEntity(), entityParser), ignores);
    }

    @Deprecated
    protected final <Req extends ActionRequest, Resp> Resp performRequest(Req request, CheckedFunction<Req, Request, IOException> requestConverter, RequestOptions options, CheckedFunction<Response, Resp, IOException> responseConverter, Set<Integer> ignores) throws IOException {
        ActionRequestValidationException validationException = request.validate();
        if (validationException != null && !validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return this.internalPerformRequest(request, requestConverter, options, responseConverter, ignores);
    }

    protected final <Req extends Validatable, Resp> Resp performRequest(Req request, CheckedFunction<Req, Request, IOException> requestConverter, RequestOptions options, CheckedFunction<Response, Resp, IOException> responseConverter, Set<Integer> ignores) throws IOException {
        Optional<ValidationException> validationException = request.validate();
        if (validationException != null && validationException.isPresent()) {
            throw validationException.get();
        }
        return this.internalPerformRequest(request, requestConverter, options, responseConverter, ignores);
    }

    private <Req, Resp> Resp internalPerformRequest(Req request, CheckedFunction<Req, Request, IOException> requestConverter, RequestOptions options, CheckedFunction<Response, Resp, IOException> responseConverter, Set<Integer> ignores) throws IOException {
        Response response;
        Request req = (Request)requestConverter.apply(request);
        req.setOptions(options);
        try {
            response = this.client.performRequest(req);
        }
        catch (ResponseException e) {
            if (ignores.contains(e.getResponse().getStatusLine().getStatusCode())) {
                try {
                    return (Resp)responseConverter.apply((Object)e.getResponse());
                }
                catch (Exception innerException) {
                    throw this.parseResponseException(e);
                }
            }
            throw this.parseResponseException(e);
        }
        try {
            return (Resp)responseConverter.apply((Object)response);
        }
        catch (Exception e) {
            throw new IOException("Unable to parse response body for " + String.valueOf(response), e);
        }
    }

    protected final <Req extends Validatable, Resp> Optional<Resp> performRequestAndParseOptionalEntity(Req request, CheckedFunction<Req, Request, IOException> requestConverter, RequestOptions options, CheckedFunction<XContentParser, Resp, IOException> entityParser) throws IOException {
        Response response;
        Optional<ValidationException> validationException = request.validate();
        if (validationException != null && validationException.isPresent()) {
            throw validationException.get();
        }
        Request req = (Request)requestConverter.apply(request);
        req.setOptions(options);
        try {
            response = this.client.performRequest(req);
        }
        catch (ResponseException e) {
            if (RestStatus.NOT_FOUND.getStatus() == e.getResponse().getStatusLine().getStatusCode()) {
                return Optional.empty();
            }
            throw this.parseResponseException(e);
        }
        try {
            return Optional.of(this.parseEntity(response.getEntity(), entityParser));
        }
        catch (Exception e) {
            throw new IOException("Unable to parse response body for " + String.valueOf(response), e);
        }
    }

    @Deprecated
    protected final <Req extends ActionRequest, Resp> Cancellable performRequestAsyncAndParseEntity(Req request, CheckedFunction<Req, Request, IOException> requestConverter, RequestOptions options, CheckedFunction<XContentParser, Resp, IOException> entityParser, ActionListener<Resp> listener, Set<Integer> ignores) {
        return this.performRequestAsync(request, requestConverter, options, (CheckedFunction<Response, Resp, IOException>)((CheckedFunction)response -> this.parseEntity(response.getEntity(), entityParser)), listener, ignores);
    }

    protected final <Req extends Validatable, Resp> Cancellable performRequestAsyncAndParseEntity(Req request, CheckedFunction<Req, Request, IOException> requestConverter, RequestOptions options, CheckedFunction<XContentParser, Resp, IOException> entityParser, ActionListener<Resp> listener, Set<Integer> ignores) {
        return this.performRequestAsync(request, requestConverter, options, response -> this.parseEntity(response.getEntity(), entityParser), listener, ignores);
    }

    @Deprecated
    protected final <Req extends ActionRequest, Resp> Cancellable performRequestAsync(Req request, CheckedFunction<Req, Request, IOException> requestConverter, RequestOptions options, CheckedFunction<Response, Resp, IOException> responseConverter, ActionListener<Resp> listener, Set<Integer> ignores) {
        ActionRequestValidationException validationException = request.validate();
        if (validationException != null && !validationException.validationErrors().isEmpty()) {
            listener.onFailure((Exception)validationException);
            return Cancellable.NO_OP;
        }
        return this.internalPerformRequestAsync(request, requestConverter, options, responseConverter, listener, ignores);
    }

    protected final <Req extends Validatable, Resp> Cancellable performRequestAsync(Req request, CheckedFunction<Req, Request, IOException> requestConverter, RequestOptions options, CheckedFunction<Response, Resp, IOException> responseConverter, ActionListener<Resp> listener, Set<Integer> ignores) {
        Optional<ValidationException> validationException = request.validate();
        if (validationException != null && validationException.isPresent()) {
            listener.onFailure((Exception)validationException.get());
            return Cancellable.NO_OP;
        }
        return this.internalPerformRequestAsync(request, requestConverter, options, responseConverter, listener, ignores);
    }

    private <Req, Resp> Cancellable internalPerformRequestAsync(Req request, CheckedFunction<Req, Request, IOException> requestConverter, RequestOptions options, CheckedFunction<Response, Resp, IOException> responseConverter, ActionListener<Resp> listener, Set<Integer> ignores) {
        Request req;
        if (listener == null) {
            throw new IllegalArgumentException("The listener is required and cannot be null");
        }
        try {
            req = (Request)requestConverter.apply(request);
        }
        catch (Exception e) {
            listener.onFailure(e);
            return Cancellable.NO_OP;
        }
        req.setOptions(options);
        ResponseListener responseListener = this.wrapResponseListener(responseConverter, listener, ignores);
        return this.client.performRequestAsync(req, responseListener);
    }

    final <Resp> ResponseListener wrapResponseListener(final CheckedFunction<Response, Resp, IOException> responseConverter, final ActionListener<Resp> actionListener, final Set<Integer> ignores) {
        return new ResponseListener(){

            public void onSuccess(Response response) {
                try {
                    actionListener.onResponse(responseConverter.apply((Object)response));
                }
                catch (Exception e) {
                    IOException ioe = new IOException("Unable to parse response body for " + String.valueOf(response), e);
                    this.onFailure(ioe);
                }
            }

            public void onFailure(Exception exception) {
                if (exception instanceof ResponseException) {
                    ResponseException responseException = (ResponseException)exception;
                    Response response = responseException.getResponse();
                    if (ignores.contains(response.getStatusLine().getStatusCode())) {
                        try {
                            actionListener.onResponse(responseConverter.apply((Object)response));
                        }
                        catch (Exception innerException) {
                            actionListener.onFailure((Exception)RestHighLevelClient.this.parseResponseException(responseException));
                        }
                    } else {
                        actionListener.onFailure((Exception)RestHighLevelClient.this.parseResponseException(responseException));
                    }
                } else {
                    actionListener.onFailure(exception);
                }
            }
        };
    }

    protected final <Req extends Validatable, Resp> Cancellable performRequestAsyncAndParseOptionalEntity(Req request, CheckedFunction<Req, Request, IOException> requestConverter, RequestOptions options, CheckedFunction<XContentParser, Resp, IOException> entityParser, ActionListener<Optional<Resp>> listener) {
        Request req;
        Optional<ValidationException> validationException = request.validate();
        if (validationException != null && validationException.isPresent()) {
            listener.onFailure((Exception)validationException.get());
            return Cancellable.NO_OP;
        }
        try {
            req = (Request)requestConverter.apply(request);
        }
        catch (Exception e) {
            listener.onFailure(e);
            return Cancellable.NO_OP;
        }
        req.setOptions(options);
        ResponseListener responseListener = this.wrapResponseListener404sOptional(response -> this.parseEntity(response.getEntity(), entityParser), listener);
        return this.client.performRequestAsync(req, responseListener);
    }

    final <Resp> ResponseListener wrapResponseListener404sOptional(final CheckedFunction<Response, Resp, IOException> responseConverter, final ActionListener<Optional<Resp>> actionListener) {
        return new ResponseListener(){

            public void onSuccess(Response response) {
                try {
                    actionListener.onResponse(Optional.of(responseConverter.apply((Object)response)));
                }
                catch (Exception e) {
                    IOException ioe = new IOException("Unable to parse response body for " + String.valueOf(response), e);
                    this.onFailure(ioe);
                }
            }

            public void onFailure(Exception exception) {
                if (exception instanceof ResponseException) {
                    ResponseException responseException = (ResponseException)exception;
                    Response response = responseException.getResponse();
                    if (RestStatus.NOT_FOUND.getStatus() == response.getStatusLine().getStatusCode()) {
                        actionListener.onResponse(Optional.empty());
                    } else {
                        actionListener.onFailure((Exception)RestHighLevelClient.this.parseResponseException(responseException));
                    }
                } else {
                    actionListener.onFailure(exception);
                }
            }
        };
    }

    protected final SkyliteStatusException parseResponseException(ResponseException responseException) {
        SkyliteStatusException opensearchException;
        Response response = responseException.getResponse();
        HttpEntity entity = response.getEntity();
        RestStatus restStatus = RestStatus.fromCode((int)response.getStatusLine().getStatusCode());
        if (entity == null) {
            opensearchException = new SkyliteStatusException(responseException.getMessage(), restStatus, (Throwable)responseException, new Object[0]);
        } else {
            try {
                opensearchException = (SkyliteStatusException)this.parseEntity(entity, BytesRestResponse::errorFromXContent);
                opensearchException.addSuppressed((Throwable)responseException);
            }
            catch (Exception e) {
                opensearchException = new SkyliteStatusException("Unable to parse response body", restStatus, (Throwable)responseException, new Object[0]);
                opensearchException.addSuppressed((Throwable)e);
            }
        }
        return opensearchException;
    }

    protected final <Resp> Resp parseEntity(HttpEntity entity, CheckedFunction<XContentParser, Resp, IOException> entityParser) throws IOException {
        if (entity == null) {
            throw new IllegalStateException("Response body expected but not returned");
        }
        if (entity.getContentType() == null) {
            throw new IllegalStateException("Lucenia didn't return the [Content-Type] header, unable to parse response body");
        }
        MediaType mediaType = MediaType.fromMediaType((String)entity.getContentType());
        if (mediaType == null) {
            throw new IllegalStateException("Unsupported Content-Type: " + entity.getContentType());
        }
        try (XContentParser parser = mediaType.xContent().createParser(this.registry, DEPRECATION_HANDLER, entity.getContent());){
            Object object = entityParser.apply((Object)parser);
            return (Resp)object;
        }
    }

    protected static boolean convertExistsResponse(Response response) {
        return response.getStatusLine().getStatusCode() == 200;
    }

    static List<NamedXContentRegistry.Entry> getDefaultNamedXContents() {
        HashMap<String, ContextParser> map = new HashMap<String, ContextParser>();
        map.put("cardinality", (p, c) -> ParsedCardinality.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("hdr_percentiles", (p, c) -> ParsedHDRPercentiles.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("hdr_percentile_ranks", (p, c) -> ParsedHDRPercentileRanks.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("tdigest_percentiles", (p, c) -> ParsedTDigestPercentiles.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("tdigest_percentile_ranks", (p, c) -> ParsedTDigestPercentileRanks.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("percentiles_bucket", (p, c) -> ParsedPercentilesBucket.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("median_absolute_deviation", (p, c) -> ParsedMedianAbsoluteDeviation.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("min", (p, c) -> ParsedMin.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("max", (p, c) -> ParsedMax.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("sum", (p, c) -> ParsedSum.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("avg", (p, c) -> ParsedAvg.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("weighted_avg", (p, c) -> ParsedWeightedAvg.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("value_count", (p, c) -> ParsedValueCount.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("simple_value", (p, c) -> ParsedSimpleValue.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("derivative", (p, c) -> ParsedDerivative.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("bucket_metric_value", (p, c) -> ParsedBucketMetricValue.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("stats", (p, c) -> ParsedStats.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("stats_bucket", (p, c) -> ParsedStatsBucket.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("extended_stats", (p, c) -> ParsedExtendedStats.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("extended_stats_bucket", (p, c) -> ParsedExtendedStatsBucket.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("geo_centroid", (p, c) -> ParsedGeoCentroid.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("histogram", (p, c) -> ParsedHistogram.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("date_histogram", (p, c) -> ParsedDateHistogram.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("auto_date_histogram", (p, c) -> ParsedAutoDateHistogram.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("variable_width_histogram", (p, c) -> ParsedVariableWidthHistogram.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("ulterms", (p, c) -> ParsedUnsignedLongTerms.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("lterms", (p, c) -> ParsedLongTerms.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("dterms", (p, c) -> ParsedDoubleTerms.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("lrareterms", (p, c) -> ParsedLongRareTerms.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("missing", (p, c) -> ParsedMissing.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("nested", (p, c) -> ParsedNested.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("reverse_nested", (p, c) -> ParsedReverseNested.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("global", (p, c) -> ParsedGlobal.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("filter", (p, c) -> ParsedFilter.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("sampler", (p, c) -> ParsedSampler.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("range", (p, c) -> ParsedRange.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("date_range", (p, c) -> ParsedDateRange.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("geo_distance", (p, c) -> ParsedGeoDistance.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("filters", (p, c) -> ParsedFilters.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("adjacency_matrix", (p, c) -> ParsedAdjacencyMatrix.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("siglterms", (p, c) -> ParsedSignificantLongTerms.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("sigsterms", (p, c) -> ParsedSignificantStringTerms.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("scripted_metric", (p, c) -> ParsedScriptedMetric.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("ip_range", (p, c) -> ParsedBinaryRange.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("top_hits", (p, c) -> ParsedTopHits.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("composite", (p, c) -> ParsedComposite.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("multi_terms", (p, c) -> ParsedMultiTerms.fromXContent((XContentParser)p, (String)((String)c)));
        List<NamedXContentRegistry.Entry> entries = map.entrySet().stream().map(entry -> new NamedXContentRegistry.Entry(Aggregation.class, new ParseField((String)entry.getKey(), new String[0]), (ContextParser)entry.getValue())).collect(Collectors.toList());
        entries.add(new NamedXContentRegistry.Entry(Suggest.Suggestion.class, new ParseField("term", new String[0]), (parser, context) -> TermSuggestion.fromXContent((XContentParser)parser, (String)((String)context))));
        entries.add(new NamedXContentRegistry.Entry(Suggest.Suggestion.class, new ParseField("phrase", new String[0]), (parser, context) -> PhraseSuggestion.fromXContent((XContentParser)parser, (String)((String)context))));
        entries.add(new NamedXContentRegistry.Entry(Suggest.Suggestion.class, new ParseField("completion", new String[0]), (parser, context) -> CompletionSuggestion.fromXContent((XContentParser)parser, (String)((String)context))));
        return entries;
    }

    static List<NamedXContentRegistry.Entry> getProvidedNamedXContents() {
        ArrayList<NamedXContentRegistry.Entry> entries = new ArrayList<NamedXContentRegistry.Entry>();
        for (NamedXContentProvider service : ServiceLoader.load(NamedXContentProvider.class)) {
            entries.addAll(service.getNamedXContentParsers());
        }
        return entries;
    }
}

