/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.client;

import io.lucenia.client.Request;
import io.lucenia.client.RequestConverters;
import io.skylite.core.action.search.DeleteSearchPipelineRequest;
import io.skylite.core.action.search.GetSearchPipelineRequest;
import io.skylite.core.action.search.PutSearchPipelineRequest;
import io.skylite.core.xcontent.ToXContent;
import java.io.IOException;

final class SearchPipelineRequestConverters {
    private SearchPipelineRequestConverters() {
    }

    static Request putPipeline(PutSearchPipelineRequest putPipelineRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_search/pipeline").addPathPart(putPipelineRequest.getId()).build();
        Request request = new Request("PUT", endpoint);
        RequestConverters.Params params = new RequestConverters.Params();
        params.withTimeout(putPipelineRequest.timeout());
        params.withClusterManagerTimeout(putPipelineRequest.clusterManagerNodeTimeout());
        request.addParameters(params.asMap());
        request.setEntity(RequestConverters.createEntity((ToXContent)putPipelineRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request deletePipeline(DeleteSearchPipelineRequest deletePipelineRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_search/pipeline").addPathPart(deletePipelineRequest.getId()).build();
        Request request = new Request("DELETE", endpoint);
        RequestConverters.Params parameters = new RequestConverters.Params();
        parameters.withTimeout(deletePipelineRequest.timeout());
        parameters.withClusterManagerTimeout(deletePipelineRequest.clusterManagerNodeTimeout());
        request.addParameters(parameters.asMap());
        return request;
    }

    static Request getPipeline(GetSearchPipelineRequest getPipelineRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_search/pipeline").addCommaSeparatedPathParts(getPipelineRequest.getIds()).build();
        Request request = new Request("GET", endpoint);
        RequestConverters.Params parameters = new RequestConverters.Params();
        parameters.withClusterManagerTimeout(getPipelineRequest.clusterManagerNodeTimeout());
        request.addParameters(parameters.asMap());
        return request;
    }
}

