/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.client.indices;

import io.skylite.common.Nullable;
import io.skylite.core.ParseField;
import io.skylite.core.cluster.health.ClusterHealthStatus;
import io.skylite.core.xcontent.ConstructingObjectParser;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class DataStream {
    private final String name;
    private final String timeStampField;
    private final List<String> indices;
    private final long generation;
    ClusterHealthStatus dataStreamStatus;
    @Nullable
    String indexTemplate;
    public static final ParseField NAME_FIELD = new ParseField("name", new String[0]);
    public static final ParseField TIMESTAMP_FIELD_FIELD = new ParseField("timestamp_field", new String[0]);
    public static final ParseField INDICES_FIELD = new ParseField("indices", new String[0]);
    public static final ParseField GENERATION_FIELD = new ParseField("generation", new String[0]);
    public static final ParseField STATUS_FIELD = new ParseField("status", new String[0]);
    public static final ParseField INDEX_TEMPLATE_FIELD = new ParseField("template", new String[0]);
    private static final ConstructingObjectParser<DataStream, Void> PARSER = new ConstructingObjectParser("data_stream", args -> {
        String dataStreamName = (String)args[0];
        String timeStampField = (String)((Map)args[1]).get("name");
        List<String> indices = ((List)args[2]).stream().map(m -> (String)m.get("index_name")).collect(Collectors.toList());
        Long generation = (Long)args[3];
        String statusStr = (String)args[4];
        ClusterHealthStatus status = ClusterHealthStatus.fromString((String)statusStr);
        String indexTemplate = (String)args[5];
        return new DataStream(dataStreamName, timeStampField, indices, generation, status, indexTemplate);
    });

    public DataStream(String name, String timeStampField, List<String> indices, long generation, ClusterHealthStatus dataStreamStatus, @Nullable String indexTemplate) {
        this.name = name;
        this.timeStampField = timeStampField;
        this.indices = indices;
        this.generation = generation;
        this.dataStreamStatus = dataStreamStatus;
        this.indexTemplate = indexTemplate;
    }

    public String getName() {
        return this.name;
    }

    public String getTimeStampField() {
        return this.timeStampField;
    }

    public List<String> getIndices() {
        return this.indices;
    }

    public long getGeneration() {
        return this.generation;
    }

    public ClusterHealthStatus getDataStreamStatus() {
        return this.dataStreamStatus;
    }

    public String getIndexTemplate() {
        return this.indexTemplate;
    }

    public static DataStream fromXContent(XContentParser parser) throws IOException {
        return (DataStream)PARSER.parse(parser, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataStream that = (DataStream)o;
        return this.generation == that.generation && this.name.equals(that.name) && this.timeStampField.equals(that.timeStampField) && this.indices.equals(that.indices) && this.dataStreamStatus == that.dataStreamStatus && Objects.equals(this.indexTemplate, that.indexTemplate);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.timeStampField, this.indices, this.generation, this.dataStreamStatus, this.indexTemplate);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), NAME_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.map(), TIMESTAMP_FIELD_FIELD);
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> p.mapStrings(), INDICES_FIELD);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), GENERATION_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), STATUS_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), INDEX_TEMPLATE_FIELD);
    }
}

