/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.client.indices.rollover;

import io.skylite.core.ParseField;
import io.skylite.core.action.clustermanager.ShardsAcknowledgedResponse;
import io.skylite.core.xcontent.ConstructingObjectParser;
import io.skylite.core.xcontent.XContentParser;
import java.util.Map;
import java.util.Objects;

public final class RolloverResponse
extends ShardsAcknowledgedResponse {
    private static final ParseField NEW_INDEX = new ParseField("new_index", new String[0]);
    private static final ParseField OLD_INDEX = new ParseField("old_index", new String[0]);
    private static final ParseField DRY_RUN = new ParseField("dry_run", new String[0]);
    private static final ParseField ROLLED_OVER = new ParseField("rolled_over", new String[0]);
    private static final ParseField CONDITIONS = new ParseField("conditions", new String[0]);
    private static final ConstructingObjectParser<RolloverResponse, Void> PARSER = new ConstructingObjectParser("rollover", true, args -> new RolloverResponse((String)args[0], (String)args[1], (Map)args[2], (Boolean)args[3], (Boolean)args[4], (Boolean)args[5], (Boolean)args[6]));
    private final String oldIndex;
    private final String newIndex;
    private final Map<String, Boolean> conditionStatus;
    private final boolean dryRun;
    private final boolean rolledOver;

    public RolloverResponse(String oldIndex, String newIndex, Map<String, Boolean> conditionResults, boolean dryRun, boolean rolledOver, boolean acknowledged, boolean shardsAcknowledged) {
        super(acknowledged, shardsAcknowledged);
        this.oldIndex = oldIndex;
        this.newIndex = newIndex;
        this.dryRun = dryRun;
        this.rolledOver = rolledOver;
        this.conditionStatus = conditionResults;
    }

    public String getOldIndex() {
        return this.oldIndex;
    }

    public String getNewIndex() {
        return this.newIndex;
    }

    public Map<String, Boolean> getConditionStatus() {
        return this.conditionStatus;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public boolean isRolledOver() {
        return this.rolledOver;
    }

    public static RolloverResponse fromXContent(XContentParser parser) {
        return (RolloverResponse)((Object)PARSER.apply(parser, null));
    }

    public boolean equals(Object o) {
        if (super.equals(o)) {
            RolloverResponse that = (RolloverResponse)((Object)o);
            return this.dryRun == that.dryRun && this.rolledOver == that.rolledOver && Objects.equals(this.oldIndex, that.oldIndex) && Objects.equals(this.newIndex, that.newIndex) && Objects.equals(this.conditionStatus, that.conditionStatus);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.oldIndex, this.newIndex, this.conditionStatus, this.dryRun, this.rolledOver);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), OLD_INDEX);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), NEW_INDEX);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (parser, context) -> parser.map(), CONDITIONS);
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), DRY_RUN);
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), ROLLED_OVER);
        RolloverResponse.declareAcknowledgedAndShardsAcknowledgedFields(PARSER);
    }
}

