/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.client.tasks;

import io.lucenia.client.Validatable;
import io.lucenia.client.ValidationException;
import io.skylite.common.unit.TimeValue;
import java.util.Objects;
import java.util.Optional;

public class GetTaskRequest
implements Validatable {
    private final String nodeId;
    private final long taskId;
    private boolean waitForCompletion = false;
    private TimeValue timeout = null;

    public GetTaskRequest(String nodeId, long taskId) {
        this.nodeId = nodeId;
        this.taskId = taskId;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public boolean getWaitForCompletion() {
        return this.waitForCompletion;
    }

    public GetTaskRequest setWaitForCompletion(boolean waitForCompletion) {
        this.waitForCompletion = waitForCompletion;
        return this;
    }

    public TimeValue getTimeout() {
        return this.timeout;
    }

    public GetTaskRequest setTimeout(TimeValue timeout) {
        this.timeout = timeout;
        return this;
    }

    @Override
    public Optional<ValidationException> validate() {
        ValidationException validationException = new ValidationException();
        if (this.timeout != null && !this.waitForCompletion) {
            validationException.addValidationError("Timeout settings are only accepted if waitForCompletion is also set");
        }
        if (validationException.validationErrors().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(validationException);
    }

    public int hashCode() {
        return Objects.hash(this.nodeId, this.taskId, this.waitForCompletion, this.timeout);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GetTaskRequest other = (GetTaskRequest)obj;
        return Objects.equals(this.nodeId, other.nodeId) && this.taskId == other.taskId && this.waitForCompletion == other.waitForCompletion && Objects.equals(this.timeout, other.timeout);
    }
}

