/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.client.tasks;

import io.skylite.core.ParseField;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SkyliteException {
    private static final String TYPE = "type";
    private static final String REASON = "reason";
    private static final String CAUSED_BY = "caused_by";
    private static final ParseField SUPPRESSED = new ParseField("suppressed", new String[0]);
    private static final String STACK_TRACE = "stack_trace";
    private static final String HEADER = "header";
    private static final String ROOT_CAUSE = "root_cause";
    private String msg;
    private SkyliteException cause;
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private final List<SkyliteException> suppressed = new ArrayList<SkyliteException>();

    SkyliteException(String msg) {
        this.msg = msg;
        this.cause = null;
    }

    SkyliteException(String msg, SkyliteException cause) {
        this.msg = msg;
        this.cause = cause;
    }

    public String getMsg() {
        return this.msg;
    }

    public SkyliteException getCause() {
        return this.cause;
    }

    public List<SkyliteException> getSuppressed() {
        return this.suppressed;
    }

    void addSuppressed(List<SkyliteException> suppressed) {
        this.suppressed.addAll(suppressed);
    }

    static SkyliteException fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.nextToken();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)token, (XContentParser)parser);
        return SkyliteException.innerFromXContent(parser, false);
    }

    private static SkyliteException innerFromXContent(XContentParser parser, boolean parseRootCauses) throws IOException {
        XContentParser.Token token = parser.currentToken();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)token, (XContentParser)parser);
        String type = null;
        String reason = null;
        String stack = null;
        SkyliteException cause = null;
        HashMap<String, List<Object>> headers = new HashMap<String, List<Object>>();
        ArrayList<SkyliteException> rootCauses = new ArrayList<SkyliteException>();
        ArrayList<SkyliteException> suppressed = new ArrayList<SkyliteException>();
        while (token == XContentParser.Token.FIELD_NAME) {
            String currentFieldName = parser.currentName();
            token = parser.nextToken();
            if (token.isValue()) {
                if (TYPE.equals(currentFieldName)) {
                    type = parser.text();
                } else if (REASON.equals(currentFieldName)) {
                    reason = parser.text();
                } else if (STACK_TRACE.equals(currentFieldName)) {
                    stack = parser.text();
                }
            } else if (token == XContentParser.Token.START_OBJECT) {
                if (CAUSED_BY.equals(currentFieldName)) {
                    cause = SkyliteException.fromXContent(parser);
                } else if (HEADER.equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        values = headers.getOrDefault(currentFieldName, new ArrayList());
                        if (token == XContentParser.Token.VALUE_STRING) {
                            values.add(parser.text());
                        } else if (token == XContentParser.Token.START_ARRAY) {
                            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                                if (token == XContentParser.Token.VALUE_STRING) {
                                    values.add(parser.text());
                                    continue;
                                }
                                parser.skipChildren();
                            }
                        } else if (token == XContentParser.Token.START_OBJECT) {
                            parser.skipChildren();
                        }
                        headers.put(currentFieldName, values);
                    }
                } else {
                    parser.skipChildren();
                }
            } else if (token == XContentParser.Token.START_ARRAY) {
                if (parseRootCauses && ROOT_CAUSE.equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        rootCauses.add(SkyliteException.fromXContent(parser));
                    }
                } else if (SUPPRESSED.match(currentFieldName, parser.getDeprecationHandler())) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        suppressed.add(SkyliteException.fromXContent(parser));
                    }
                } else {
                    values = new ArrayList();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        if (token == XContentParser.Token.VALUE_STRING) {
                            values.add(parser.text());
                            continue;
                        }
                        parser.skipChildren();
                    }
                }
            }
            token = parser.nextToken();
        }
        SkyliteException e = new SkyliteException(SkyliteException.buildMessage(type, reason, stack), cause);
        for (Map.Entry header : headers.entrySet()) {
            e.addHeader((String)header.getKey(), (List)header.getValue());
        }
        e.suppressed.addAll(rootCauses);
        e.suppressed.addAll(suppressed);
        return e;
    }

    void addHeader(String key, List<String> value) {
        this.headers.put(key, value);
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    static String buildMessage(String type, String reason, String stack) {
        StringBuilder message = new StringBuilder("Skylite exception [");
        message.append(TYPE).append('=').append(type).append(", ");
        message.append(REASON).append('=').append(reason);
        if (stack != null) {
            message.append(", ").append(STACK_TRACE).append('=').append(stack);
        }
        message.append(']');
        return message.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SkyliteException)) {
            return false;
        }
        SkyliteException that = (SkyliteException)o;
        return Objects.equals(this.getMsg(), that.getMsg()) && Objects.equals(this.getCause(), that.getCause()) && Objects.equals(this.getHeaders(), that.getHeaders()) && Objects.equals(this.getSuppressed(), that.getSuppressed());
    }

    public int hashCode() {
        return Objects.hash(this.getMsg(), this.getCause(), this.getHeaders(), this.getSuppressed());
    }

    public String toString() {
        return "SkyliteException{msg='" + this.msg + "', cause=" + String.valueOf(this.cause) + ", headers=" + String.valueOf(this.headers) + ", suppressed=" + String.valueOf(this.suppressed) + "}";
    }
}

