/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.painless;

import io.lucenia.painless.Compiler;
import io.lucenia.painless.WriterConstants;
import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.LambdaConversionException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.security.AccessController;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

public final class LambdaBootstrap {
    private static final String DELEGATED_CTOR_WRAPPER_NAME = "delegate$ctor";
    private static final String LAMBDA_FACTORY_METHOD_NAME = "create$lambda";

    public static CallSite lambdaBootstrap(MethodHandles.Lookup lookup, String interfaceMethodName, MethodType factoryMethodType, MethodType interfaceMethodType, String delegateClassName, int delegateInvokeType, String delegateMethodName, MethodType delegateMethodType, int isDelegateInterface, int isDelegateAugmented, Object ... injections) throws LambdaConversionException {
        Compiler.Loader loader = (Compiler.Loader)lookup.lookupClass().getClassLoader();
        String lambdaClassName = Type.getInternalName(lookup.lookupClass()) + "$$Lambda" + loader.newLambdaIdentifier();
        Type lambdaClassType = Type.getObjectType((String)lambdaClassName);
        Type delegateClassType = Type.getObjectType((String)delegateClassName.replace('.', '/'));
        LambdaBootstrap.validateTypes(interfaceMethodType, delegateMethodType);
        ClassWriter cw = LambdaBootstrap.beginLambdaClass(lambdaClassName, factoryMethodType.returnType());
        Capture[] captures = LambdaBootstrap.generateCaptureFields(cw, factoryMethodType);
        LambdaBootstrap.generateLambdaConstructor(cw, lambdaClassType, factoryMethodType, captures);
        if (delegateInvokeType == 8) {
            assert ("<init>".equals(delegateMethodName));
            LambdaBootstrap.generateStaticCtorDelegator(cw, 2, DELEGATED_CTOR_WRAPPER_NAME, delegateClassType, delegateMethodType);
            delegateMethodName = DELEGATED_CTOR_WRAPPER_NAME;
            delegateClassType = lambdaClassType;
            delegateInvokeType = 6;
        }
        LambdaBootstrap.generateInterfaceMethod(cw, factoryMethodType, lambdaClassType, interfaceMethodName, interfaceMethodType, delegateClassType, delegateInvokeType, delegateMethodName, delegateMethodType, isDelegateInterface == 1, isDelegateAugmented == 1, captures, injections);
        LambdaBootstrap.endLambdaClass(cw);
        Class<?> lambdaClass = LambdaBootstrap.createLambdaClass(loader, cw, lambdaClassType);
        if (captures.length > 0) {
            return LambdaBootstrap.createCaptureCallSite(lookup, factoryMethodType, lambdaClass);
        }
        return LambdaBootstrap.createNoCaptureCallSite(factoryMethodType, lambdaClass);
    }

    private static void validateTypes(MethodType interfaceMethodType, MethodType delegateMethodType) throws LambdaConversionException {
        if (interfaceMethodType.returnType() != Void.TYPE && delegateMethodType.returnType() == Void.TYPE) {
            throw new LambdaConversionException("lambda expects return type [" + String.valueOf(interfaceMethodType.returnType()) + "], but found return type [void]");
        }
    }

    private static ClassWriter beginLambdaClass(String lambdaClassName, Class<?> lambdaInterface) {
        String baseClass = Type.getInternalName(Object.class);
        int modifiers = 4145;
        ClassWriter cw = new ClassWriter(1);
        cw.visit(52, modifiers, lambdaClassName, null, baseClass, new String[]{Type.getInternalName(lambdaInterface)});
        return cw;
    }

    private static Capture[] generateCaptureFields(ClassWriter cw, MethodType factoryMethodType) {
        int captureTotal = factoryMethodType.parameterCount();
        Capture[] captures = new Capture[captureTotal];
        for (int captureCount = 0; captureCount < captureTotal; ++captureCount) {
            captures[captureCount] = new Capture(captureCount, (Class<?>)factoryMethodType.parameterType(captureCount));
            int modifiers = 18;
            FieldVisitor fv = cw.visitField(modifiers, captures[captureCount].name, captures[captureCount].desc, null, null);
            fv.visitEnd();
        }
        return captures;
    }

    private static void generateLambdaConstructor(ClassWriter cw, Type lambdaClassType, MethodType factoryMethodType, Capture[] captures) {
        String conDesc = factoryMethodType.changeReturnType(Void.TYPE).toMethodDescriptorString();
        Method conMeth = new Method("<init>", conDesc);
        Type baseConType = Type.getType(Object.class);
        Method baseConMeth = new Method("<init>", MethodType.methodType(Void.TYPE).toMethodDescriptorString());
        int modifiers = captures.length > 0 ? 2 : 1;
        GeneratorAdapter constructor = new GeneratorAdapter(modifiers, conMeth, cw.visitMethod(modifiers, "<init>", conDesc, null, null));
        constructor.visitCode();
        constructor.loadThis();
        constructor.invokeConstructor(baseConType, baseConMeth);
        for (int captureCount = 0; captureCount < captures.length; ++captureCount) {
            constructor.loadThis();
            constructor.loadArg(captureCount);
            constructor.putField(lambdaClassType, captures[captureCount].name, captures[captureCount].type);
        }
        constructor.returnValue();
        constructor.endMethod();
        if (captures.length > 0) {
            LambdaBootstrap.generateStaticCtorDelegator(cw, 1, LAMBDA_FACTORY_METHOD_NAME, lambdaClassType, factoryMethodType);
        }
    }

    private static void generateStaticCtorDelegator(ClassWriter cw, int access, String delegatorMethodName, Type delegateClassType, MethodType delegateMethodType) {
        Method wrapperMethod = new Method(delegatorMethodName, delegateMethodType.toMethodDescriptorString());
        Method constructorMethod = new Method("<init>", delegateMethodType.changeReturnType(Void.TYPE).toMethodDescriptorString());
        int modifiers = access | 8;
        GeneratorAdapter factory = new GeneratorAdapter(modifiers, wrapperMethod, cw.visitMethod(modifiers, delegatorMethodName, delegateMethodType.toMethodDescriptorString(), null, null));
        factory.visitCode();
        factory.newInstance(delegateClassType);
        factory.dup();
        factory.loadArgs();
        factory.invokeConstructor(delegateClassType, constructorMethod);
        factory.returnValue();
        factory.endMethod();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void generateInterfaceMethod(ClassWriter cw, MethodType factoryMethodType, Type lambdaClassType, String interfaceMethodName, MethodType interfaceMethodType, Type delegateClassType, int delegateInvokeType, String delegateMethodName, MethodType delegateMethodType, boolean isDelegateInterface, boolean isDelegateAugmented, Capture[] captures, Object ... injections) throws LambdaConversionException {
        String lamDesc = interfaceMethodType.toMethodDescriptorString();
        Method lamMeth = new Method(lambdaClassType.getInternalName(), lamDesc);
        int modifiers = 1;
        GeneratorAdapter iface = new GeneratorAdapter(modifiers, lamMeth, cw.visitMethod(modifiers, interfaceMethodName, lamDesc, null, null));
        iface.visitCode();
        for (int captureCount = 0; captureCount < captures.length; ++captureCount) {
            iface.loadThis();
            iface.getField(lambdaClassType, captures[captureCount].name, captures[captureCount].type);
        }
        iface.loadArgs();
        if (delegateInvokeType == 6) {
            interfaceMethodType = interfaceMethodType.insertParameterTypes(0, factoryMethodType.parameterArray());
            delegateMethodType = delegateMethodType.insertParameterTypes(0, factoryMethodType.parameterArray());
        } else {
            if (delegateInvokeType != 5 && delegateInvokeType != 9) throw new IllegalStateException("unexpected invocation type [" + delegateInvokeType + "]");
            if (captures.length == 0) {
                TypeDescriptor.OfField clazz = delegateMethodType.parameterType(0);
                delegateClassType = Type.getType((Class)clazz);
                delegateMethodType = delegateMethodType.dropParameterTypes(0, 1);
            } else {
                if (captures.length != 1) throw new LambdaConversionException("unexpected number of captures [ " + captures.length + "]");
                TypeDescriptor.OfField clazz = factoryMethodType.parameterType(0);
                delegateClassType = Type.getType((Class)clazz);
                interfaceMethodType = interfaceMethodType.insertParameterTypes(0, new Class[]{clazz});
            }
        }
        Handle delegateHandle = new Handle(delegateInvokeType, delegateClassType.getInternalName(), delegateMethodName, delegateMethodType.toMethodDescriptorString(), isDelegateInterface);
        Object[] args = new Object[2 + injections.length];
        args[0] = delegateHandle;
        args[1] = delegateInvokeType == 6 && !isDelegateAugmented ? 0 : 1;
        System.arraycopy(injections, 0, args, 2, injections.length);
        iface.invokeDynamic(delegateMethodName, Type.getMethodType((String)interfaceMethodType.toMethodDescriptorString()).getDescriptor(), WriterConstants.DELEGATE_BOOTSTRAP_HANDLE, args);
        iface.returnValue();
        iface.endMethod();
    }

    private static void endLambdaClass(ClassWriter cw) {
        cw.visitEnd();
    }

    private static Class<?> createLambdaClass(Compiler.Loader loader, ClassWriter cw, Type lambdaClassType) {
        byte[] classBytes = cw.toByteArray();
        return AccessController.doPrivileged(() -> loader.defineLambda(lambdaClassType.getClassName(), classBytes));
    }

    private static CallSite createNoCaptureCallSite(MethodType factoryMethodType, Class<?> lambdaClass) {
        try {
            return new ConstantCallSite(MethodHandles.constant(factoryMethodType.returnType(), lambdaClass.getConstructor(new Class[0]).newInstance(new Object[0])));
        }
        catch (ReflectiveOperationException exception) {
            throw new IllegalStateException("unable to instantiate lambda class", exception);
        }
    }

    private static CallSite createCaptureCallSite(MethodHandles.Lookup lookup, MethodType factoryMethodType, Class<?> lambdaClass) {
        try {
            return new ConstantCallSite(lookup.findStatic(lambdaClass, LAMBDA_FACTORY_METHOD_NAME, factoryMethodType));
        }
        catch (ReflectiveOperationException exception) {
            throw new IllegalStateException("unable to create lambda class", exception);
        }
    }

    public static CallSite delegateBootstrap(MethodHandles.Lookup lookup, String delegateMethodName, MethodType interfaceMethodType, MethodHandle delegateMethodHandle, int isVirtual, Object ... injections) {
        if (injections.length > 0) {
            delegateMethodHandle = MethodHandles.insertArguments(delegateMethodHandle, isVirtual, injections);
        }
        return new ConstantCallSite(delegateMethodHandle.asType(interfaceMethodType));
    }

    private static final class Capture {
        private final String name;
        private final Type type;
        private final String desc;

        private Capture(int count, Class<?> type) {
            this.name = "arg$" + count;
            this.type = Type.getType(type);
            this.desc = this.type.getDescriptor();
        }
    }
}

