/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.painless;

import io.lucenia.painless.CompilerSettings;
import io.lucenia.painless.PainlessScriptEngine;
import io.lucenia.painless.action.PainlessContextAction;
import io.lucenia.painless.action.PainlessExecuteAction;
import io.lucenia.painless.spi.Allowlist;
import io.lucenia.painless.spi.AllowlistLoader;
import io.lucenia.painless.spi.PainlessExtension;
import io.lucenia.plugins.ActionPlugin;
import io.lucenia.plugins.ExtensiblePlugin;
import io.lucenia.plugins.Plugin;
import io.lucenia.plugins.ScriptPlugin;
import io.skylite.common.SetOnce;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.node.DiscoveryNodes;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.io.stream.NamedWriteableRegistry;
import io.skylite.core.env.Environment;
import io.skylite.core.env.NodeEnvironment;
import io.skylite.core.repositories.RepositoriesService;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.script.ScriptContext;
import io.skylite.core.script.ScriptEngine;
import io.skylite.core.script.ScriptService;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.IndexScopedSettings;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.SettingsFilter;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.xcontent.NamedXContentRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.opensearch.rest.RestController;
import org.opensearch.script.IngestScript;
import org.opensearch.script.ScoreScript;
import org.opensearch.search.aggregations.pipeline.MovingFunctionScript;
import org.opensearch.watcher.ResourceWatcherService;

public final class PainlessModulePlugin
extends Plugin
implements ScriptPlugin,
ExtensiblePlugin,
ActionPlugin {
    private static final Map<ScriptContext<?>, List<Allowlist>> allowlists;
    private final SetOnce<PainlessScriptEngine> painlessScriptEngine = new SetOnce();

    public ScriptEngine getScriptEngine(Settings settings, Collection<ScriptContext<?>> contexts) {
        HashMap contextsWithAllowlists = new HashMap();
        for (ScriptContext<?> context : contexts) {
            List<Allowlist> contextAllowlists = allowlists.get(context);
            if (contextAllowlists == null) {
                contextAllowlists = new ArrayList<Allowlist>(Allowlist.BASE_ALLOWLISTS);
            }
            contextsWithAllowlists.put(context, contextAllowlists);
        }
        this.painlessScriptEngine.set((Object)new PainlessScriptEngine(settings, contextsWithAllowlists));
        return (ScriptEngine)this.painlessScriptEngine.get();
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver expressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        return Collections.singletonList(this.painlessScriptEngine.get());
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(CompilerSettings.REGEX_ENABLED, CompilerSettings.REGEX_LIMIT_FACTOR);
    }

    public void loadExtensions(ExtensiblePlugin.ExtensionLoader loader) {
        loader.loadExtensions(PainlessExtension.class).stream().flatMap(extension -> extension.getContextAllowlists().entrySet().stream()).forEach(entry -> {
            List existing = allowlists.computeIfAbsent((ScriptContext)entry.getKey(), c -> new ArrayList(Allowlist.BASE_ALLOWLISTS));
            existing.addAll((Collection)entry.getValue());
        });
    }

    public List<ScriptContext<?>> getContexts() {
        return Collections.singletonList(PainlessExecuteAction.PainlessTestScript.CONTEXT);
    }

    public List<ActionPlugin.ActionHandler> getActions() {
        ArrayList<ActionPlugin.ActionHandler> actions = new ArrayList<ActionPlugin.ActionHandler>();
        actions.add(new ActionPlugin.ActionHandler((ActionType)PainlessExecuteAction.INSTANCE, PainlessExecuteAction.TransportAction.class, new Class[0]));
        actions.add(new ActionPlugin.ActionHandler((ActionType)PainlessContextAction.INSTANCE, PainlessContextAction.TransportAction.class, new Class[0]));
        return actions;
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        ArrayList<RestHandler> handlers = new ArrayList<RestHandler>();
        handlers.add((RestHandler)new PainlessExecuteAction.RestAction());
        handlers.add((RestHandler)new PainlessContextAction.RestAction());
        return handlers;
    }

    static {
        HashMap map = new HashMap();
        ArrayList<Allowlist> movFn = new ArrayList<Allowlist>(Allowlist.BASE_ALLOWLISTS);
        movFn.add(AllowlistLoader.loadFromResourceFiles(Allowlist.class, (String[])new String[]{"org.opensearch.aggs.movfn.txt"}));
        map.put(MovingFunctionScript.CONTEXT, movFn);
        ArrayList<Allowlist> scoreFn = new ArrayList<Allowlist>(Allowlist.BASE_ALLOWLISTS);
        scoreFn.add(AllowlistLoader.loadFromResourceFiles(Allowlist.class, (String[])new String[]{"org.opensearch.score.txt"}));
        map.put(ScoreScript.CONTEXT, scoreFn);
        ArrayList<Allowlist> ingest = new ArrayList<Allowlist>(Allowlist.BASE_ALLOWLISTS);
        ingest.add(AllowlistLoader.loadFromResourceFiles(Allowlist.class, (String[])new String[]{"org.opensearch.ingest.txt"}));
        map.put(IngestScript.CONTEXT, ingest);
        allowlists = map;
    }
}

