/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.painless;

import io.lucenia.painless.WriterConstants;
import io.skylite.core.script.ScriptException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;

public interface PainlessScript {
    public String getName();

    public String getSource();

    public BitSet getStatements();

    default public ScriptException convertToScriptException(Throwable t, Map<String, List<String>> extraMetadata) {
        ArrayList<String> scriptStack = new ArrayList<String>();
        ScriptException.Position pos = null;
        for (StackTraceElement element : t.getStackTrace()) {
            if (WriterConstants.CLASS_NAME.equals(element.getClassName())) {
                int endOffset;
                int offset;
                int startOffset;
                int originalOffset = element.getLineNumber();
                if (originalOffset == -1) {
                    scriptStack.add("<<< unknown portion of script >>>");
                    break;
                }
                if ((startOffset = this.getPreviousStatement(offset = --originalOffset)) == -1) {
                    if (!1.$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    startOffset = 0;
                }
                if ((endOffset = this.getNextStatement(startOffset)) == -1) {
                    endOffset = this.getSource().length();
                }
                String snippet = this.getSource().substring(startOffset, endOffset);
                scriptStack.add(snippet);
                StringBuilder pointer = new StringBuilder();
                for (int i = startOffset; i < offset; ++i) {
                    pointer.append(' ');
                }
                pointer.append("^---- HERE");
                scriptStack.add(pointer.toString());
                pos = new ScriptException.Position(originalOffset, startOffset, endOffset);
                break;
            }
            if (this.shouldFilter(element)) continue;
            scriptStack.add(element.toString());
        }
        ScriptException scriptException = new ScriptException("runtime error", t, scriptStack, this.getName(), "painless", pos);
        for (Map.Entry<String, List<String>> entry : extraMetadata.entrySet()) {
            scriptException.addMetadata(entry.getKey(), entry.getValue());
        }
        return scriptException;
    }

    default public boolean shouldFilter(StackTraceElement element) {
        return element.getClassName().startsWith("io.lucenia.painless.") || element.getClassName().startsWith("java.lang.invoke.") || element.getClassName().startsWith("sun.invoke.");
    }

    default public int getPreviousStatement(int offset) {
        return this.getStatements().previousSetBit(offset);
    }

    default public int getNextStatement(int offset) {
        return this.getStatements().nextSetBit(offset + 1);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

