/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.painless.antlr;

import io.lucenia.painless.Location;
import io.lucenia.painless.antlr.PainlessLexer;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.LexerNoViableAltException;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;

final class EnhancedPainlessLexer
extends PainlessLexer {
    private final String sourceName;
    private Token current = null;

    EnhancedPainlessLexer(CharStream charStream, String sourceName) {
        super(charStream);
        this.sourceName = sourceName;
    }

    public Token nextToken() {
        this.current = super.nextToken();
        return this.current;
    }

    public void recover(LexerNoViableAltException lnvae) {
        CharStream charStream = lnvae.getInputStream();
        int startIndex = lnvae.getStartIndex();
        String text = charStream.getText(Interval.of((int)startIndex, (int)charStream.index()));
        Location location = new Location(this.sourceName, this._tokenStartCharIndex);
        String message = "unexpected character [" + this.getErrorDisplay(text) + "].";
        char firstChar = text.charAt(0);
        if ((firstChar == '\'' || firstChar == '\"') && text.length() - 2 > 0 && text.charAt(text.length() - 2) == '\\') {
            message = message + " The only valid escape sequences in strings starting with [" + firstChar + "] are [\\\\] and [\\" + firstChar + "].";
        }
        throw location.createError(new IllegalArgumentException(message, (Throwable)lnvae));
    }

    @Override
    protected boolean isSlashRegex() {
        Token lastToken = this.current;
        if (lastToken == null) {
            return true;
        }
        switch (lastToken.getType()) {
            case 6: 
            case 8: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 83: 
            case 84: 
            case 85: {
                return false;
            }
        }
        return true;
    }
}

