/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.painless.ir;

import io.lucenia.painless.ClassWriter;
import io.lucenia.painless.Location;
import io.lucenia.painless.MethodWriter;
import io.lucenia.painless.Operation;
import io.lucenia.painless.WriterConstants;
import io.lucenia.painless.ir.BinaryNode;
import io.lucenia.painless.ir.NullNode;
import io.lucenia.painless.lookup.PainlessLookupUtility;
import io.lucenia.painless.lookup.def;
import io.lucenia.painless.phase.IRTreeVisitor;
import io.lucenia.painless.symbol.WriteScope;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

public class ComparisonNode
extends BinaryNode {
    private Operation operation;
    private Class<?> comparisonType;

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setComparisonType(Class<?> comparisonType) {
        this.comparisonType = comparisonType;
    }

    public Class<?> getComparisonType() {
        return this.comparisonType;
    }

    public String getComparisonCanonicalTypeName() {
        return PainlessLookupUtility.typeToCanonicalTypeName(this.comparisonType);
    }

    @Override
    public <Scope> void visit(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        irTreeVisitor.visitComparison(this, scope);
    }

    @Override
    public <Scope> void visitChildren(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        this.getLeftNode().visit(irTreeVisitor, scope);
        this.getRightNode().visit(irTreeVisitor, scope);
    }

    public ComparisonNode(Location location) {
        super(location);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void write(ClassWriter classWriter, MethodWriter methodWriter, WriteScope writeScope) {
        boolean writejump;
        Label end;
        Label jump;
        block31: {
            Type type;
            boolean ne;
            boolean eq;
            block37: {
                Type descriptor;
                boolean gte;
                boolean gt;
                boolean lte;
                boolean lt;
                block39: {
                    block38: {
                        block33: {
                            block36: {
                                block35: {
                                    block34: {
                                        block32: {
                                            methodWriter.writeDebugInfo(this.getLocation());
                                            this.getLeftNode().write(classWriter, methodWriter, writeScope);
                                            if (!(this.getRightNode() instanceof NullNode)) {
                                                this.getRightNode().write(classWriter, methodWriter, writeScope);
                                            }
                                            jump = new Label();
                                            end = new Label();
                                            eq = this.operation == Operation.EQ || this.operation == Operation.EQR;
                                            ne = this.operation == Operation.NE || this.operation == Operation.NER;
                                            lt = this.operation == Operation.LT;
                                            lte = this.operation == Operation.LTE;
                                            gt = this.operation == Operation.GT;
                                            gte = this.operation == Operation.GTE;
                                            writejump = true;
                                            type = MethodWriter.getType(this.comparisonType);
                                            if (this.comparisonType == Void.TYPE) throw new IllegalStateException("unexpected comparison operation [" + String.valueOf((Object)this.operation) + "] for type [" + this.getExpressionCanonicalTypeName() + "]");
                                            if (this.comparisonType == Byte.TYPE) throw new IllegalStateException("unexpected comparison operation [" + String.valueOf((Object)this.operation) + "] for type [" + this.getExpressionCanonicalTypeName() + "]");
                                            if (this.comparisonType == Short.TYPE) throw new IllegalStateException("unexpected comparison operation [" + String.valueOf((Object)this.operation) + "] for type [" + this.getExpressionCanonicalTypeName() + "]");
                                            if (this.comparisonType == Character.TYPE) {
                                                throw new IllegalStateException("unexpected comparison operation [" + String.valueOf((Object)this.operation) + "] for type [" + this.getExpressionCanonicalTypeName() + "]");
                                            }
                                            if (this.comparisonType != Boolean.TYPE) break block32;
                                            if (eq) {
                                                methodWriter.ifCmp(type, 153, jump);
                                                break block31;
                                            } else {
                                                if (!ne) {
                                                    throw new IllegalStateException("unexpected comparison operation [" + String.valueOf((Object)this.operation) + "] for type [" + this.getExpressionCanonicalTypeName() + "]");
                                                }
                                                methodWriter.ifCmp(type, 154, jump);
                                            }
                                            break block31;
                                        }
                                        if (this.comparisonType != Integer.TYPE && this.comparisonType != Long.TYPE && this.comparisonType != Float.TYPE && this.comparisonType != Double.TYPE) break block33;
                                        if (!eq) break block34;
                                        methodWriter.ifCmp(type, 153, jump);
                                        break block31;
                                    }
                                    if (!ne) break block35;
                                    methodWriter.ifCmp(type, 154, jump);
                                    break block31;
                                }
                                if (!lt) break block36;
                                methodWriter.ifCmp(type, 155, jump);
                                break block31;
                            }
                            if (lte) {
                                methodWriter.ifCmp(type, 158, jump);
                                break block31;
                            } else if (gt) {
                                methodWriter.ifCmp(type, 157, jump);
                                break block31;
                            } else {
                                if (!gte) {
                                    throw new IllegalStateException("unexpected comparison operation [" + String.valueOf((Object)this.operation) + "] for type [" + this.getExpressionCanonicalTypeName() + "]");
                                }
                                methodWriter.ifCmp(type, 156, jump);
                            }
                            break block31;
                        }
                        if (this.comparisonType != def.class) break block37;
                        Type booleanType = Type.getType(Boolean.TYPE);
                        descriptor = Type.getMethodType((Type)booleanType, (Type[])new Type[]{MethodWriter.getType(this.getLeftNode().getExpressionType()), MethodWriter.getType(this.getRightNode().getExpressionType())});
                        if (!eq) break block38;
                        if (this.getRightNode() instanceof NullNode) {
                            methodWriter.ifNull(jump);
                            break block31;
                        } else {
                            if (!(this.getLeftNode() instanceof NullNode) && this.operation == Operation.EQ) {
                                methodWriter.invokeDefCall("eq", descriptor, 8, 1);
                                return;
                            }
                            methodWriter.ifCmp(type, 153, jump);
                        }
                        break block31;
                    }
                    if (!ne) break block39;
                    if (this.getRightNode() instanceof NullNode) {
                        methodWriter.ifNonNull(jump);
                        break block31;
                    } else if (!(this.getLeftNode() instanceof NullNode) && this.operation == Operation.NE) {
                        methodWriter.invokeDefCall("eq", descriptor, 8, 1);
                        methodWriter.ifZCmp(153, jump);
                        break block31;
                    } else {
                        methodWriter.ifCmp(type, 154, jump);
                    }
                    break block31;
                }
                if (lt) {
                    methodWriter.invokeDefCall("lt", descriptor, 8, 0);
                    return;
                }
                if (lte) {
                    methodWriter.invokeDefCall("lte", descriptor, 8, 0);
                    return;
                }
                if (gt) {
                    methodWriter.invokeDefCall("gt", descriptor, 8, 0);
                    return;
                }
                if (!gte) {
                    throw new IllegalStateException("unexpected comparison operation [" + String.valueOf((Object)this.operation) + "] for type [" + this.getExpressionCanonicalTypeName() + "]");
                }
                methodWriter.invokeDefCall("gte", descriptor, 8, 0);
                return;
            }
            if (eq) {
                if (this.getRightNode() instanceof NullNode) {
                    methodWriter.ifNull(jump);
                } else {
                    if (this.operation == Operation.EQ) {
                        methodWriter.invokeStatic(WriterConstants.OBJECTS_TYPE, WriterConstants.EQUALS);
                        return;
                    }
                    methodWriter.ifCmp(type, 153, jump);
                }
            } else {
                if (!ne) {
                    throw new IllegalStateException("unexpected comparison operation [" + String.valueOf((Object)this.operation) + "] for type [" + this.getExpressionCanonicalTypeName() + "]");
                }
                if (this.getRightNode() instanceof NullNode) {
                    methodWriter.ifNonNull(jump);
                } else if (this.operation == Operation.NE) {
                    methodWriter.invokeStatic(WriterConstants.OBJECTS_TYPE, WriterConstants.EQUALS);
                    methodWriter.ifZCmp(153, jump);
                } else {
                    methodWriter.ifCmp(type, 154, jump);
                }
            }
        }
        if (!writejump) return;
        methodWriter.push(false);
        methodWriter.goTo(end);
        methodWriter.mark(jump);
        methodWriter.push(true);
        methodWriter.mark(end);
    }
}

